/*-
 * Copyright (c) 2014 Robert N. M. Watson
 * Copyright (c) 2014 SRI International
 * All rights reserved.
 *
 * This software was developed by SRI International and the University of
 * Cambridge Computer Laboratory under DARPA/AFRL contract (FA8750-10-C-0237)
 * ("CTSRD"), as part of the DARPA CRASH research programme.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _LIBEXEC_LIBPNG_SB_HELPER_H_
#define	_LIBEXEC_LIBPNG_SB_HELPER_H_

#define	LIBPNG_SB_HELPER_OP_CREATE_READ_STRUCT		1
#define LIBPNG_SB_HELPER_OP_CREATE_INFO_STRUCT		2
#define	LIBPNG_SB_HELPER_OP_READ_INFO			3
#define	LIBPNG_SB_HELPER_OP_SET_EXPAND_GRAY_1_2_4_TO_8	4
#define	LIBPNG_SB_HELPER_OP_SET_PALETTE_TO_RGB		5
#define	LIBPNG_SB_HELPER_OP_SET_TRNS_TO_ALPHA		6
#define	LIBPNG_SB_HELPER_OP_SET_FILLER			7
#define	LIBPNG_SB_HELPER_OP_SET_STRIP_16		8
#define	LIBPNG_SB_HELPER_OP_READ_UPDATE_INFO		9
#define	LIBPNG_SB_HELPER_OP_READ_IMAGE			10
#define	LIBPNG_SB_HELPER_OP_PROCESS_DATA		11
#define	LIBPNG_SB_HELPER_OP_GET_COLOR_TYPE		12
#define	LIBPNG_SB_HELPER_OP_SET_GRAY_TO_RGB		13
#define	LIBPNG_SB_HELPER_OP_GET_VALID			14
#define	LIBPNG_SB_HELPER_OP_GET_ROWBYTES		15
#define	LIBPNG_SB_HELPER_OP_GET_IMAGE_WIDTH		16
#define	LIBPNG_SB_HELPER_OP_GET_IMAGE_HEIGHT		17
#define	LIBPNG_SB_HELPER_OP_GET_BIT_DEPTH		18
#define LIBPNG_SB_HELPER_OP_GET_INTERLACE_TYPE		19
#define	LIBPNG_SB_HELPER_OP_SET_READ_FN			20
#define	LIBPNG_SB_HELPER_OP_SET_PROGRESSIVE_READ_FN	21
#define	LIBPNG_SB_HELPER_MAX_OP				21

#define	LIBPNG_SB_USERFN_READ_CALLBACK			(CHERI_SYSTEM_USER_BASE)
#define	LIBPNG_SB_USERFN_INFO_CALLBACK			(CHERI_SYSTEM_USER_BASE + 1)
#define	LIBPNG_SB_USERFN_ROW_CALLBACK			(CHERI_SYSTEM_USER_BASE + 2)
#define	LIBPNG_SB_USERFN_END_CALLBACK			(CHERI_SYSTEM_USER_BASE + 3)

#endif /* !_LIBEXEC_LIBPNG_SB_HELPER_OP_H_ */
