/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.portfolios.swing;

import java.awt.Component;
import java.awt.event.KeyEvent;

import t3.portfolios.PortfolioEvent;

/**
 * Represents an AWT key event caused by a portfolio key event. 
 * @author pjt40
 *
 */
public class SwingFramePortfolioKeyEvent extends KeyEvent {

	public final PortfolioEvent cause;
	
	SwingFramePortfolioKeyEvent(PortfolioEvent cause, Component source, int id, long when,
			int modifiers, int keyCode, char keyChar, int keyLocation) {
		super(source, id, when, modifiers, keyCode, keyChar, keyLocation);
		this.cause = cause;
	}

	SwingFramePortfolioKeyEvent(PortfolioEvent cause, Component source, int id, long when,
			int modifiers, int keyCode, char keyChar) {
		super(source, id, when, modifiers, keyCode, keyChar);
		this.cause = cause;
	}

	SwingFramePortfolioKeyEvent(PortfolioEvent cause, Component source, int id, long when,
			int modifiers, int keyCode) {
		super(source, id, when, modifiers, keyCode);
		this.cause = cause;
	}

}
