/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */

package t3.portfolios.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;

/*
 * This class is completely thread safe
 * 
 */


class MyPopupFactory extends PopupFactory {

	private static final Logger logger = Logger.getLogger("t3.hrd.portfolios.swing");
	private HashMap<JRootPane,List<MyPopup>> h;
	private final PopupFactory pf;
			
	MyPopupFactory(PopupFactory pf) {
		this.h = new HashMap<JRootPane,List<MyPopup>>();
		this.pf = pf;
	}
	
	synchronized public Popup getPopup(Component owner, Component contents, int desiredScreenX, int desiredScreenY) throws IllegalArgumentException{
	
		Popup p = pf.getPopup(owner, contents, desiredScreenX, desiredScreenY);
		if(owner instanceof JComponent && contents instanceof JComponent) {
			return new MyPopup(p , (JComponent)contents, desiredScreenX, desiredScreenY, this, ((JComponent)owner).getRootPane() );
		} else {
			return p;
		}			
	}

	
	synchronized void notifyOfHide(MyPopup p) {
		h.get(p.sourceRootPane).remove(p);
		
		// for some reason, when a popup is disposed of, java doesn't
		// redraw underneath it. so we'll do it ourselves.
		// of course, we have to add the dirty region to the 
		// source root frame, not the popup because the popup has now 
		// disappeared from our records.
		Rectangle r = p.getRDesiredPopupBoundsInFrameOfRefOfSourceRootPane(); 
		
		SwingFramePortfolio.rpm.addDirtyRegion(p.sourceRootPane, r.x, r.y, r.width, r.height);
	}
	
	synchronized void notifyOfShow(MyPopup p) {
		if(!h.containsKey(p.sourceRootPane)) {
			h.put(p.sourceRootPane,new LinkedList<MyPopup>());
		}
		h.get(p.sourceRootPane).add(p);

		Rectangle r = p.getRDesiredPopupBoundsInFrameOfRefOfSourceRootPane(); 
		SwingFramePortfolio.rpm.addDirtyRegion(p.sourceRootPane, r.x, r.y, r.width, r.height);
	}
	
	synchronized List<MyPopup> getPopupsForSourceRootPane(JRootPane r) {
		List<MyPopup> l = this.h.get(r);
		if(l==null) {
			return new LinkedList<MyPopup>();
		} else {
			return new LinkedList<MyPopup>(this.h.get(r));
		}			
	}
}