/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.util;

import java.util.logging.Logger;

public class ThingsPSTimer {
    private final String start;
    private final String end;
    private final double maxThingsPStoReport, deviation;
    private final long msBetweenChecksForDeviation;
    private final long msBetweenAlwaysReport;
    private final double timesByWhenPrintOut; 
    private long timeOfLastDevCheck = System.currentTimeMillis();
    private long timeOfLastReport = System.currentTimeMillis();
    private long nThingsSinceLastDevCheck = 0;
    private double thingsPsLastReported = 0;
    private static final Logger logger = Logger.getLogger("t3.hrd.util.FPSTimer");

    
    public ThingsPSTimer(String start, String end, double maxThingsPStoReport, double deviation, long msBetweenChecksForDeviation, long msBetweenAlwaysReport, double timesByWhenPrintOut) {
        this.start = start;
        this.end = end;
        this.maxThingsPStoReport = maxThingsPStoReport;
        this.deviation =deviation;
        this.msBetweenChecksForDeviation = msBetweenChecksForDeviation;
        this.msBetweenAlwaysReport = msBetweenAlwaysReport;
        this.timesByWhenPrintOut = timesByWhenPrintOut;
    }
    
    public void moreThings(long c) {
        this.nThingsSinceLastDevCheck+=c;
        long timeElapsedSinceLastDevCheck = System.currentTimeMillis()-this.timeOfLastDevCheck;
        if(timeElapsedSinceLastDevCheck>this.msBetweenChecksForDeviation) {
            double thingsps = (double)(nThingsSinceLastDevCheck)/(double)(timeElapsedSinceLastDevCheck)*1000.0;
            long timeSinceLastReport = System.currentTimeMillis()-this.timeOfLastReport;
            if(thingsps<maxThingsPStoReport && (timeSinceLastReport>this.msBetweenAlwaysReport || thingsps>this.thingsPsLastReported*(1.0+this.deviation) || thingsps<this.thingsPsLastReported*(1.0-this.deviation))) {
                this.thingsPsLastReported = thingsps;
                logger.info(""+start+ (thingsps*this.timesByWhenPrintOut)+end+" over "+(((double)timeSinceLastReport)/1000.0)+"s");
                this.timeOfLastReport = System.currentTimeMillis();
            }
            this.timeOfLastDevCheck = System.currentTimeMillis();
            this.nThingsSinceLastDevCheck = 0;
        } else {
            // DO NOTHING
        }   
    }
}
