/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.util;

public class FPSLimiter {
    // this class will limit to approximately the target, but not exactly.
    private final long targetMsBetweenFrames;
    private long timeOfLastFrameStart = System.currentTimeMillis();
    private long dif = 0;
    private final long resetDifEveryMs = 1000;
    private final long minSleep = 5;
    private long lastReset = System.currentTimeMillis();
    
    public FPSLimiter(long targetMsBetweenFrames) {
        this.targetMsBetweenFrames = targetMsBetweenFrames;
    }
    public void oneFrame() throws InterruptedException{
        // call this when a frame completes.
        long curTime = System.currentTimeMillis();
        long elapsed = curTime-timeOfLastFrameStart;
        this.dif += (targetMsBetweenFrames-elapsed);
        if(this.dif>minSleep) {
            if(this.dif>minSleep) {
                Thread.sleep(this.dif);
            } else {
                // do nothing. can't speed it up!
            }
            long newCurTime = System.currentTimeMillis();
            // this next line is v important. Thread.sleep is not accurate so we have to 
            // initialise dif to an appropriate value that takes this into account.
            this.dif = -(newCurTime-curTime-this.dif);
            this.lastReset = newCurTime;
            this.timeOfLastFrameStart = newCurTime;
        } else if( this.dif<-50000 || curTime-lastReset>resetDifEveryMs ) {
            // dif is either negative or has grown to under 20 over a long time 
            // so don't worry about sleeping
            this.dif = 0;
            this.lastReset = curTime;
            this.timeOfLastFrameStart = curTime;            
        } else {
            // do nothing. can't speed it up!
            this.timeOfLastFrameStart = curTime;
        }
            
    }
    
    public static void main(String[] args) throws Throwable{
        // test it
        int TARGETFRAMERATE = 60;
        FPSLimiter ff = new FPSLimiter(Math.round(1000.0/TARGETFRAMERATE));
        FPSTimer f = new FPSTimer("fps=", "", 1000, 0.1, 1000, 1000 );
 
        
        while(true) {
            ff.oneFrame();
            f.oneFrame();
            for(int i=0; i<10000000; i++) {
                
            }
        }
    }
    
}