/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.renderer;

import Jama.Matrix;

/**
 * A data structure allowing you to specify the configuration of a single projector.
 * 
 * @author pjt40
 *
 */
public class ProjectorConfig {
	
	/**
	 * Index of the GraphicsDevice for the projector in the array
	 * GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()
	 */
	public int graphicsDeviceIndex = 0;	
	public boolean window_fullScreenExclusive = true;	
	public Matrix[] mDESKcornersOfProjectorLimitClockwiseInWOGL; 
	public boolean UOGLtoWOGLflipsVert, UOGLtoWOGLflipsHoriz;
	public double UOGLtoWOGLrotationClockwise; 
		
}
