/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3examples;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import t3.hrd.state.Link;
import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.portfolios.AnimatorJobsThread;
import t3.portfolios.PointInputDevice;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.Portfolio;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioLink;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;
import t3.portfolios.commonbehaviours.RNTWTORAndRegroupAndShrinkAndDestroy;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;
import t3.portfolios.swing.SwingFramePortfolio;

/*
UNCOMMENT IF YOU DOWNLOAD AND USE WEBRENDERER
import com.webrenderer.swing.BrowserFactory;
import com.webrenderer.swing.IBrowserCanvas;
import com.webrenderer.swing.event.BrowserAdapter;
import com.webrenderer.swing.event.BrowserEvent;
*/

/**
 * By default this example uses the HTML 3 renderer in the Java system libraries,
 * so most web pages won't render correctly, if at all.
 * You could remedy this situation by download the WebRenderer Java HTML 4 renderer
 * (demo version is free for 30 days). You'll need to uncomment or change the indicated
 * lines in the Example6.java source file, and you'll need to add the WebRenderer jar files to
 * the class path in run-example.bat. 
 * 
 * @author pjt40
 *
 */
public class Example6 extends SwingFramePortfolio {
    
    
    final static int w=1024, h=700;
    final static double pxpermm=3;
    static RNTWTORAndRegroupAndShrinkAndDestroy c;
    
    // SET TO TRUE IF YOU USE WEBRENDERER
    final static boolean usewebrenderer = false;
    final static boolean scroll = true;
    
    /*
    UNCOMMENT AND CHANGE IF YOU DOWNLOAD AND USE WEBRENDERER
    static final String WR_LICENSE_A="30dtrial", WR_LICENSE_B="O8T46GOAO4P51GB88B1LGAQ1";
    */
    
    final static boolean link = true;
    
    
    
    public Example6(PortfolioServer ps, Portfolio p, final String url) {
        super(ps, p, new CannotDragWRTParent(),  w, h, 0, 0, true);
        try {
            
            JComponent s;
            if(usewebrenderer) {
                s=null;
                /*
                 UNCOMMENT IF YOU DOWNLOAD AND USE WEBRENDERER
                 BrowserFactory.setLicenseData( WR_LICENSE_A, WR_LICENSE_B );
                IBrowserCanvas browser = BrowserFactory.spawnMozilla();
                browser.allowPopups(false);
                browser.enablePlugins(false);
                browser.enableDefaultContextMenu(false);
                browser.addBrowserListener(new BrowserAdapter() {
                    public void onLoadIntercept(BrowserEvent e) {
                            if(!e.getURL().equalsIgnoreCase(url) && !e.getURL().equalsIgnoreCase("http://"+url+"/") && !e.getURL().equalsIgnoreCase("http://www."+url+".com/")) {
                                    // Blocking the load of the URL
                                    e.blockLoad();
                                    Example6.this.clickedOnLink(e.getURL());
                            }
                        }
                });
                browser.showScrollBars(scroll);
                s = (JComponent) browser.getComponent();
                browser.loadURL(url);*/
            } else {
                JEditorPane myJEditorPane;
                try {
                    myJEditorPane = new JEditorPane(url);
                } catch(Exception e) {
                    myJEditorPane = new JEditorPane("text/html",url);
                }
                myJEditorPane.setEditable(false);
                myJEditorPane.addHyperlinkListener(new HyperlinkListener() {
                    public void hyperlinkUpdate(final HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            Example6.this.clickedOnLink(e.getURL().toExternalForm());
                        }
                    }
                });
                JScrollPane scrollPane = new JScrollPane(myJEditorPane);
                scrollPane.setPreferredSize(new Dimension(w,h));
                scrollPane.setMinimumSize(new Dimension(10,10));
                scrollPane.setVerticalScrollBarPolicy(
                        scroll ?
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS : JScrollPane.VERTICAL_SCROLLBAR_NEVER);
                scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
                s=scrollPane;
            }
            
            this.getFrame().add(s);
            
            this.setTileWidthAndHeightInPORT(this.getTileWidthInTILE()/pxpermm,this.getTileHeightInTILE()/pxpermm);
            
        } catch(Throwable e) {
            ps.fatalError(e);
        }
    }
    
    public void clickedOnLink(final String newUrl) {
        ScaRotTraTransformImmutableUniformScale finaltx = new ScaRotTraTransformImmutableUniformScale( 
                Example6.this.gettPORTtoDESK().getScale(),
                Example6.this.gettPORTtoDESK().getThetaClockwise(),
                Example6.this.gettPORTtoDESK().getTx()+20.0,
                Example6.this.gettPORTtoDESK().getTy()+20.0
            );
        createNewWebPage(this.portfolioServer, newUrl, finaltx, this);
    }
    
    public static void createNewWebPage(final PortfolioServer ps, final String newUrl, final ScaRotTraTransformImmutableUniformScale finaltx, final Portfolio source) {
        try {
            URL url = new URL(newUrl);
        } catch(MalformedURLException e) {
            return;
        }
        SwingFramePortfolio.runLaterFromSwingThreadUsesPortfolios( ps, new Runnable() { public void run() {
            System.out.println("Creating new: "+newUrl);
            WebPagePortfolioOuter webport = new WebPagePortfolioOuter(
                    ps, 
                    ps.rootPortfolio, 
                    newUrl
                    );

            ScaRotTraTransformImmutableUniformScale starttx = new ScaRotTraTransformImmutableUniformScale( 
                    finaltx.getScale()*0.2,
                    finaltx.getThetaClockwise(),
                    finaltx.getTx(),
                    finaltx.getTy()
                );
            webport.setPORTtoDESK( starttx );
            webport.setVisibleWhenParentVisible(true);
            if(link && source!=null) {
                new PortfolioLink(Link.DISPLAYTYPE_NORMAL, new Color(255,255,0,128), source, webport);
            }
            
            LinkedList<AnimatorJobsThread.AnimationJob> ajs = new LinkedList<AnimatorJobsThread.AnimationJob>();
            ajs.add(
                new AnimatorJobsThread.AnimationJob(
                    webport,
                    finaltx
                )
            );
            new AnimatorJobsThread(30, ps, ajs,300,new Runnable() {public void run() {}} ).start();           
        }});
    }
    
    
    public static class WebPagePortfolioOuter extends Portfolio {
        private static final int TILEW=512, TILEH=512, BORDERTILETHICKNESS=5, ARCWIDTH=50, ARCHEIGHT=100;
        private static final double DESKGAP=10.0;
        private final Color BORDERCOL = Color.BLUE;
            
        public WebPagePortfolioOuter(
                PortfolioServer ps, Portfolio parent, String url
            ) {
            super(false, ps, parent, c, true, TILEW, TILEH, 0,0);
            Portfolio inner = new Example6(ps, this, url);
            inner.setVisibleWhenParentVisible(true);
            this.setTileWidthAndHeightInPORT(inner.getTileWidthInPORT()+2*DESKGAP, inner.getTileHeightInPORT()+2*DESKGAP);
            
            
            this.triggerRepaintEntireTile();
            
        }
        
        public boolean customProcessEventForThisPortfolioNotChildren(final PortfolioEvent e, boolean bubbled) { 
            return false;
        }
        
        public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
            g.setColor(new Color(0,0,0,0));
            g.fillRect(0,0,TILEW,TILEH);
            g.setColor(BORDERCOL);
            g.setStroke(new BasicStroke(BORDERTILETHICKNESS));
            g.drawRoundRect(0,0,TILEW-BORDERTILETHICKNESS, TILEH-BORDERTILETHICKNESS, ARCWIDTH, ARCHEIGHT);
        }

        public void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
            
        }
        
        public  void customProcessEndOfFDOPmode(PointInputDevice pen, int button) {
            
        }        
    }
    
    public static class ContainerPortfolio extends Portfolio {
        private static final int TILEW=512, TILEH=512, BORDERTILETHICKNESS=5, ARCWIDTH=100, ARCHEIGHT=100;
        private static final double dw = 300.0, dh=220.0;
        private final Color BORDERCOL = Color.GREEN;
        private final Color BGCOL = new Color(0,128,0);
            
        public ContainerPortfolio(PortfolioServer ps) {
            super(false, ps, ps.rootPortfolio, new RotateNTranslateWithTranslateOnlyRegion(), true, TILEW, TILEH, 0,0);
            this.setTileWidthAndHeightInPORT(dw, dh);
            this.triggerRepaintEntireTile();
            
        }
        
        public boolean customProcessEventForThisPortfolioNotChildren(final PortfolioEvent e, boolean bubbled) { 
            return false;
        }
        
        public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
            g.setColor(new Color(0,0,0,0));
            g.fillRect(0,0,TILEW,TILEH);
            g.setColor(BGCOL);
            g.fillRoundRect(0,0,TILEW-BORDERTILETHICKNESS, TILEH-BORDERTILETHICKNESS, ARCWIDTH, ARCHEIGHT);
            g.setColor(BORDERCOL);
            g.setStroke(new BasicStroke(BORDERTILETHICKNESS));
            g.drawRoundRect(0,0,TILEW-BORDERTILETHICKNESS, TILEH-BORDERTILETHICKNESS, ARCWIDTH, ARCHEIGHT);
        }

        public void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
            
        }
        
        public  void customProcessEndOfFDOPmode(PointInputDevice pen, int button) {
            
        }        
    }
    
    public static class BlackHolePortfolio extends Portfolio {
        private static final int TILEW=512, TILEH=512, BORDERTILETHICKNESS=5, ARCWIDTH=100, ARCHEIGHT=100;
        private static final double dw = 100.0, dh=100.0;
        private final Color BORDERCOL = Color.RED;
        private final Color BGCOL = new Color(128,0,0);
            
        public BlackHolePortfolio(PortfolioServer ps) {
            super(false, ps, ps.rootPortfolio, new RotateNTranslateWithTranslateOnlyRegion(), true, TILEW, TILEH, 0,0);
            this.setTileWidthAndHeightInPORT(dw, dh);
            this.triggerRepaintEntireTile();
            
        }
        
        public boolean customProcessEventForThisPortfolioNotChildren(final PortfolioEvent e, boolean bubbled) { 
            return false;
        }
        
        public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
            g.setColor(new Color(0,0,0,0));
            g.fillRect(0,0,TILEW,TILEH);
            g.setColor(BGCOL);
            g.fillRoundRect(0,0,TILEW-BORDERTILETHICKNESS, TILEH-BORDERTILETHICKNESS, ARCWIDTH, ARCHEIGHT);
            g.setColor(BORDERCOL);
            g.setStroke(new BasicStroke(BORDERTILETHICKNESS));
            g.drawRoundRect(0,0,TILEW-BORDERTILETHICKNESS, TILEH-BORDERTILETHICKNESS, ARCWIDTH, ARCHEIGHT);
        }

        public void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
            
        }
        
        public  void customProcessEndOfFDOPmode(PointInputDevice pen, int button) {
            
        }        
    }
    
    public static class URLentryPortfolio extends SwingFramePortfolio {
        private static final int TILEW=700, TILEH=30, BORDERTILETHICKNESS=5, ARCWIDTH=100, ARCHEIGHT=100;
        private static final double dw=TILEW/pxpermm, dh=TILEH/pxpermm;
        private JTextField jtf;
        private JButton jbs, jbu;
        public URLentryPortfolio(PortfolioServer ps) {
            super(ps,ps.rootPortfolio, new RotateNTranslateWithTranslateOnlyRegion(),TILEW,TILEH,0,0);
            SpringLayout layout = new SpringLayout();
            JPanel pane = new JPanel(layout);
            JLabel label = new JLabel ("Address or search phrase:");
            pane.add(label); 
            jtf = new JTextField("");
            pane.add(jtf); 
            ActionListener al = new ActionListener() {
                String lastOpen = "";
                String lastSearch = "";
                public void actionPerformed(ActionEvent e) {
                    if(e.getActionCommand().equals("Open") && !jtf.getText().equals(lastOpen)) {
                        lastOpen = jtf.getText();
                        createNewWebPage(URLentryPortfolio.this.portfolioServer, jtf.getText(), URLentryPortfolio.this.gettPORTtoDESK(), URLentryPortfolio.this);
                        System.out.println("Opening: "+lastOpen);
                    } else if(e.getActionCommand().equals("Search") && !jtf.getText().equals(lastSearch)) {
                        lastSearch= jtf.getText();
                        String newUrl = "http://www.google.co.uk/search?hl=en&q="+URLEncoder.encode(lastSearch)+"&meta=";
                        createNewWebPage(URLentryPortfolio.this.portfolioServer, newUrl, URLentryPortfolio.this.gettPORTtoDESK(), URLentryPortfolio.this);
                        System.out.println("Opening: "+lastSearch);
                    }
                }                
            };
            jbs = new JButton("Search");
            jbs.setActionCommand("Search");
            jbs.addActionListener(al);
            jbu = new JButton("Open Page");
            jbu.setActionCommand("Open");
            jbu.addActionListener(al);
            pane.add(jbs); 
            pane.add(jbu); 
            layout.putConstraint(SpringLayout.WEST, jtf,
                    5,
                    SpringLayout.EAST, label);
            
            
            layout.putConstraint(SpringLayout.WEST, jbs,
                    5,
                    SpringLayout.EAST, jtf);

            layout.putConstraint(SpringLayout.WEST, jbu,
                    5,
                    SpringLayout.EAST, jbs);
            layout.putConstraint(SpringLayout.EAST, pane,
                    5,
                    SpringLayout.EAST, jbu);
            layout.putConstraint(SpringLayout.WEST, pane,
                    10,
                    SpringLayout.WEST, label);
            
            this.getFrame().add(pane);
                        this.setTileWidthAndHeightInPORT(dw,dh);
        }
    }
    
    
    
    public static void main(String[] args) throws Exception {
        
        // create a new server
        final PortfolioServer ps = new PortfolioServer(new ServerSocket(2000),new ServerSocket(2001), false);

        Portfolio bh = new BlackHolePortfolio(ps);
        bh.setVisibleWhenParentVisible(true);
        
        c = new RNTWTORAndRegroupAndShrinkAndDestroy(
                    new PointInputDeviceTypeAndButtonSet(
                        new PointInputDeviceTypeAndButton(0,1)
                    ), 
                    true, 0.0,0.0,
                    0.3,
                    0.3,
                    0.0008,
                    bh
                );
        
        c.containers.add(bh);        
        
        Portfolio containera = new ContainerPortfolio(ps);
        containera.setVisibleWhenParentVisible(true);
        c.containers.add(containera);
        containera.setPORTtoDESK( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
        
        Portfolio containerb = new ContainerPortfolio(ps);
        containerb.setVisibleWhenParentVisible(true);
        c.containers.add(containerb);
        containerb.setPORTtoDESK( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
        
        Portfolio containerc = new ContainerPortfolio(ps);
        containerc.setVisibleWhenParentVisible(true);
        c.containers.add(containerc);
        containerc.setPORTtoDESK( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
        
        Portfolio urla = new URLentryPortfolio(ps);
        urla.setVisibleWhenParentVisible(true);
        urla.setPORTtoDESK( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
        
        try {
        
            SwingFramePortfolio.runLaterFromSwingThreadUsesPortfolios( ps, new Runnable() { public void run() { 
        
                final SwingFramePortfolio mySwingPortf = new SwingFramePortfolio(ps, ps.rootPortfolio, c,  300, 300, 0, 0);
                JPanel pane = new JPanel(new GridLayout(0, 1));
                pane.add(new JComboBox(new String[] { "Bird", "Cat", "Dog", "Rabbit", "Pig" }));
                pane.add(new JTextField("Test text field")); 
                pane.add(new JButton("Test button"));
                pane.add(new JRadioButton("Test radio"));
                pane.setBorder(BorderFactory.createEmptyBorder(
                                                30, //top
                                                30, //left
                                                10, //bottom
                                                30) //right
                                                );
                mySwingPortf.getFrame().add(pane);
                mySwingPortf.setPORTtoPPORT( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
                mySwingPortf.setTileWidthAndHeightInPORT(mySwingPortf.getTileWidthInTILE()/pxpermm,mySwingPortf.getTileHeightInTILE()/pxpermm);
                mySwingPortf.setVisibleWhenParentVisible(true);
                
                final WebPagePortfolioOuter webport3 = new WebPagePortfolioOuter(ps, ps.rootPortfolio, "http://www.cai.cam.ac.uk/");
                webport3.setPORTtoDESK( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
                webport3.setVisibleWhenParentVisible(true);
            
                   
            }} );
                        
            
        } catch(Throwable e) {
            ps.fatalError(e);
        }
    }    
    
    
}
