/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.util.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class TextureData {
    private int width;
    private int height;
    private int border;
    private int pixelFormat;
    private int pixelType;
    private int internalFormat;
    private boolean mipmap;
    private boolean dataIsCompressed;
    private boolean mustFlipVertically;
    private Buffer buffer;
    private Buffer[] mipmapData;
    private Flusher flusher;
    private int alignment;
    private int estimatedMemorySize;
    private static final ColorModel rgbaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, true, 3, 0);
    private static final ColorModel rgbColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);

    public TextureData(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, Buffer buffer, Flusher flusher) throws IllegalArgumentException {
        if (bl && bl2) {
            throw new IllegalArgumentException("Can not generate mipmaps for compressed textures");
        }
        this.width = n2;
        this.height = n3;
        this.border = n4;
        this.pixelFormat = n5;
        this.pixelType = n6;
        this.internalFormat = n;
        this.mipmap = bl;
        this.dataIsCompressed = bl2;
        this.mustFlipVertically = bl3;
        this.buffer = buffer;
        this.flusher = flusher;
        this.alignment = 1;
        this.estimatedMemorySize = this.estimatedMemorySize(buffer);
    }

    public TextureData(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, Buffer[] bufferArray, Flusher flusher) throws IllegalArgumentException {
        this.width = n2;
        this.height = n3;
        this.border = n4;
        this.pixelFormat = n5;
        this.pixelType = n6;
        this.internalFormat = n;
        this.dataIsCompressed = bl;
        this.mustFlipVertically = bl2;
        this.mipmapData = (Buffer[])bufferArray.clone();
        this.flusher = flusher;
        this.alignment = 1;
        for (int i = 0; i < bufferArray.length; ++i) {
            this.estimatedMemorySize += this.estimatedMemorySize(bufferArray[i]);
        }
    }

    public TextureData(int n, int n2, boolean bl, BufferedImage bufferedImage) {
        this.internalFormat = n == 0 ? (bufferedImage.getColorModel().hasAlpha() ? 6408 : 6407) : n;
        this.createFromImage(bufferedImage);
        this.mipmap = bl;
        this.estimatedMemorySize = this.estimatedMemorySize(this.buffer);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBorder() {
        return this.border;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public int getPixelType() {
        return this.pixelType;
    }

    public int getInternalFormat() {
        return this.internalFormat;
    }

    public boolean getMipmap() {
        return this.mipmap;
    }

    public boolean isDataCompressed() {
        return this.dataIsCompressed;
    }

    public boolean getMustFlipVertically() {
        return this.mustFlipVertically;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Buffer[] getMipmapData() {
        return this.mipmapData;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setPixelFormat(int n) {
        this.pixelFormat = n;
    }

    public void setPixelType(int n) {
        this.pixelType = n;
    }

    public void setInternalFormat(int n) {
        this.internalFormat = n;
    }

    public void setMipmap(boolean bl) {
        this.mipmap = bl;
    }

    public void setIsDataCompressed(boolean bl) {
        this.dataIsCompressed = bl;
    }

    public void setMustFlipVertically(boolean bl) {
        this.mustFlipVertically = bl;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public void flush() {
        if (this.flusher != null) {
            this.flusher.flush();
            this.flusher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNIOBufferFromImage(BufferedImage bufferedImage, boolean bl) {
        block16: {
            if (bl) {
                ImageUtil.flipImageVertically(bufferedImage);
            }
            try {
                DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
                if (dataBuffer instanceof DataBufferByte) {
                    if (this.pixelType == 0) {
                        this.pixelType = 5121;
                    }
                    this.buffer = ByteBuffer.wrap(this.copyIfNecessary(((DataBufferByte)dataBuffer).getData(), bl));
                    break block16;
                }
                if (dataBuffer instanceof DataBufferDouble) {
                    throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
                }
                if (dataBuffer instanceof DataBufferFloat) {
                    if (this.pixelType == 0) {
                        this.pixelType = 5126;
                    }
                    this.buffer = FloatBuffer.wrap(this.copyIfNecessary(((DataBufferFloat)dataBuffer).getData(), bl));
                    break block16;
                }
                if (dataBuffer instanceof DataBufferInt) {
                    if (this.pixelType == 0) {
                        this.pixelType = 5125;
                    }
                    this.buffer = IntBuffer.wrap(this.copyIfNecessary(((DataBufferInt)dataBuffer).getData(), bl));
                    break block16;
                }
                if (dataBuffer instanceof DataBufferShort) {
                    if (this.pixelType == 0) {
                        this.pixelType = 5122;
                    }
                    this.buffer = ShortBuffer.wrap(this.copyIfNecessary(((DataBufferShort)dataBuffer).getData(), bl));
                    break block16;
                }
                if (dataBuffer instanceof DataBufferUShort) {
                    if (this.pixelType == 0) {
                        this.pixelType = 5123;
                    }
                    this.buffer = ShortBuffer.wrap(this.copyIfNecessary(((DataBufferShort)dataBuffer).getData(), bl));
                    break block16;
                }
                throw new RuntimeException("Unexpected DataBuffer type?");
            }
            finally {
                if (bl) {
                    ImageUtil.flipImageVertically(bufferedImage);
                }
            }
        }
    }

    private byte[] copyIfNecessary(byte[] byArray, boolean bl) {
        if (bl) {
            return (byte[])byArray.clone();
        }
        return byArray;
    }

    private short[] copyIfNecessary(short[] sArray, boolean bl) {
        if (bl) {
            return (short[])sArray.clone();
        }
        return sArray;
    }

    private int[] copyIfNecessary(int[] nArray, boolean bl) {
        if (bl) {
            return (int[])nArray.clone();
        }
        return nArray;
    }

    private float[] copyIfNecessary(float[] fArray, boolean bl) {
        if (bl) {
            return (float[])fArray.clone();
        }
        return fArray;
    }

    private double[] copyIfNecessary(double[] dArray, boolean bl) {
        if (bl) {
            return (double[])dArray.clone();
        }
        return dArray;
    }

    private void createFromImage(BufferedImage bufferedImage) {
        this.pixelType = 0;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        switch (bufferedImage.getType()) {
            case 1: {
                this.pixelFormat = 32993;
                this.pixelType = 33639;
                this.alignment = 4;
                break;
            }
            case 3: {
                this.pixelFormat = 32993;
                this.pixelType = 33639;
                this.alignment = 4;
                break;
            }
            case 4: {
                this.pixelFormat = 6408;
                this.pixelType = 33639;
                this.alignment = 4;
                break;
            }
            case 5: {
                WritableRaster writableRaster = bufferedImage.getRaster();
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
                if (componentSampleModel.getScanlineStride() / 3 == componentSampleModel.getWidth()) {
                    this.pixelFormat = 32992;
                    this.pixelType = 5121;
                    this.alignment = 1;
                    break;
                }
                this.createFromCustom(bufferedImage);
                return;
            }
            case 7: {
                WritableRaster writableRaster = bufferedImage.getRaster();
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
                if (componentSampleModel.getScanlineStride() / 4 == componentSampleModel.getWidth()) {
                    // empty if block
                }
                this.createFromCustom(bufferedImage);
                return;
            }
            case 8: {
                this.pixelFormat = 6407;
                this.pixelType = 33635;
                this.alignment = 2;
                break;
            }
            case 9: {
                this.pixelFormat = 32993;
                this.pixelType = 33638;
                this.alignment = 2;
                break;
            }
            case 10: {
                this.pixelFormat = 6409;
                this.pixelType = 5121;
                this.alignment = 1;
                break;
            }
            case 11: {
                this.pixelFormat = 6409;
                this.pixelType = 5123;
                this.alignment = 2;
                break;
            }
            default: {
                ColorModel colorModel = bufferedImage.getColorModel();
                if (colorModel.equals(rgbColorModel)) {
                    this.pixelFormat = 6407;
                    this.pixelType = 5121;
                    this.alignment = 1;
                    break;
                }
                if (colorModel.equals(rgbaColorModel)) {
                    this.pixelFormat = 6408;
                    this.pixelType = 5121;
                    this.alignment = 4;
                    break;
                }
                this.createFromCustom(bufferedImage);
                return;
            }
        }
        this.createNIOBufferFromImage(bufferedImage, true);
    }

    private void createFromCustom(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        ColorModel colorModel = null;
        int n3 = bufferedImage.getRaster().getDataBuffer().getDataType();
        colorModel = n3 == 0 ? (bl ? rgbaColorModel : rgbColorModel) : (bl ? new ComponentColorModel(ColorSpace.getInstance(1000), null, true, true, 3, n3) : new ComponentColorModel(ColorSpace.getInstance(1000), null, false, false, 1, n3));
        boolean bl2 = colorModel.isAlphaPremultiplied();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, bl2, null);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(bufferedImage, 0, n2, n, 0, 0, 0, n, n2, null);
        graphics2D.dispose();
        this.createNIOBufferFromImage(bufferedImage2, false);
        this.pixelFormat = bl ? 6408 : 6407;
        this.alignment = 1;
    }

    private int estimatedMemorySize(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        int n = buffer.capacity();
        if (buffer instanceof ByteBuffer) {
            return n;
        }
        if (buffer instanceof IntBuffer) {
            return n * 4;
        }
        if (buffer instanceof FloatBuffer) {
            return n * 4;
        }
        if (buffer instanceof ShortBuffer) {
            return n * 2;
        }
        if (buffer instanceof LongBuffer) {
            return n * 8;
        }
        if (buffer instanceof DoubleBuffer) {
            return n * 8;
        }
        throw new RuntimeException("Unexpected buffer type " + buffer.getClass().getName());
    }

    public static interface Flusher {
        public void flush();
    }
}

