/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PLYWRITER_H
#define PLYWRITER_H

#include <fstream>
#include <sstream>
#include "flatmeshhandler.h"

namespace snurbs {

/**
 * Writes out a Stanford PLY file in the format read by PlyReader.
 *
 * @ingroup Support
 */
class PlyWriter : public FlatMeshHandler
{
public:
    /**
     * PlyWriter constructor
     * @param fileStream The stream to write the ply file to.
     */
    PlyWriter(std::ostream *fileStream);
    /**
     * PlyWriter destructor. Closes the #file
     */
    ~PlyWriter(void);
    void addVertex(VertexPrecision x,
                   VertexPrecision y,
                   VertexPrecision z,
                   VertexPrecision w);
    void startFace(unsigned int numEdges);
    void addToFace(unsigned int vertNum);
    void closeFace(void);
    void addKnotInterval(unsigned int vertex1,
                         unsigned int vertex2,
                         KnotPrecision interval);
    void finishKnotIntervals(void);

private:
    /**
     * The @c std::ostream used to represent the target file.
     */
    std::ostream *file;

    /** Holds the number of calls to writeVertex. */
    unsigned int numVertices;
    /** Holds the number of calls to closeFace. */
    unsigned int numFaces;
    /** Holds the number of calls to writeKnotInterval. */
    unsigned int numKnotIntervals;

    /**
     * PlyWriter holds an internal buffer, in memory, for the contents of the
     * PLY file that follow the header. An alternative implementation would be
     * to write this out to a temporary file, if memory is scarce.
     */
    std::stringstream buffer;
};

}

#endif
