/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MESHBUILDER_H
#define MESHBUILDER_H

#include "flatmeshhandler.h"
#include "types.h"

namespace snurbs {

class Mesh;

/**
 * A MeshBuilder is used to construct a Mesh. MeshBuilder is an abstract class
 * -- PrimalMeshBuilder and DualMeshBuilder are the concrete implementations.
 *
 * @ingroup Support
 */
class MeshBuilder : public FlatMeshHandler
{
public:
    /**
     * Create a MeshBuilder. The caller should use dispose() to release the
     * MeshBuilder.
     * @param mesh The mesh to receive objects. The @link Mesh::degree degree
     * @endlink of this mesh object determines the type of MeshBuilder that is
     * returned.
     * @see MeshFlattener::create
     */
    static MeshBuilder *create(Mesh &mesh);

    /**
    * A very simple disposal method. For the rationale, see "Six of the best"
    * by Kevlin Henney: "Make acquisition and release symmetric"
    * @param meshBuilder The MeshBuilder to delete.
    * @see MeshFlattener::dispose
    */
    static void dispose(MeshBuilder *meshBuilder);

protected:
    /**
     * MeshBuilder constructor is protected -- use MeshBuilder::create to get
     * a MeshBuilder instance.
     */
    MeshBuilder(Mesh &mesh) : mesh(mesh) {};
    /** The Mesh to build. */
    Mesh &mesh;
};

}

#endif
