/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "uvfwriter.h"

namespace snurbs {

using namespace std;

UvfWriter::UvfWriter(ostream *fileStream) : file(fileStream),
                                            numVertices(0),
                                            numFaces(0)
{
}

// The header is written in endFile(), when we know the number of each type of
// element. A stringstream buffer is used to save the contents of the UVF
// file in memory until we've written the header. So we don't implement
// startMesh.

void UvfWriter::addVertex(VertexPrecision x,
                          VertexPrecision y,
                          VertexPrecision z,
                          VertexPrecision w)
{
    buffer << x/w << " " << y/w << " " << z/w << endl;
    ++numVertices;
}

void UvfWriter::addToFace(unsigned int vertNum)
{
    buffer << vertNum << " ";
}

void UvfWriter::addTexCoords(KnotPrecision u, KnotPrecision v)
{
    buffer << u << " " << v << " ";
}

void UvfWriter::closeFace(void)
{
    buffer << endl;
    ++numFaces;
}

void UvfWriter::finishKnotIntervals(void)
{
    *file << numVertices << " " << numFaces << endl;

    // Copy the contents of the buffer to the output file.
    istreambuf_iterator<char> in(buffer);
    istreambuf_iterator<char> eos;
    ostreambuf_iterator<char> out(*file);
    copy(in, eos, out);
}

}
