/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef UNARYPATCHTREE_H
#define UNARYPATCHTREE_H

#include "abstractunarypatchtree.h"

namespace snurbs {

/**
 * Concrete version of AbstractUnaryPatchTree that contains a @c parent
 * pointer. Suitable for use as a PatchTree node similar to BinaryPatchTree
 * and QuadPatchTree but with only one child.
 *
 * @ingroup Mesh
 */
class UnaryPatchTree : public AbstractUnaryPatchTree
{
public:
    /** UnaryPatchTree constructor. */
    UnaryPatchTree(PatchTreeLeaf *leaf);

    PatchTree *&getParent(void);

    void setParent(PatchTree *newParent);

    Direction dirFromParent(void) const;

private:
    /** The parent PatchTree. */
    PatchTree *parent;
};

UnaryPatchTree::UnaryPatchTree(PatchTreeLeaf *leaf) :
                                                   AbstractUnaryPatchTree(leaf)
{
    leaf->setParent(this);
}

inline PatchTree *&UnaryPatchTree::getParent(void)
{
    return parent;
}

inline void UnaryPatchTree::setParent(PatchTree *newParent)
{
    parent = newParent;
}

inline PatchTree::Direction UnaryPatchTree::dirFromParent(void) const
{
    return parent->childDir(this);
}

}

#endif
