/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/** @mainpage SubdNURBS
 *
 * @section intro_sec Introduction
 *
 * This is a shared library implementing a set of "NURBS-compatible"
 * subdivision surfaces that can represent existing NURBS patches exactly,
 * but also handle extraordinary points. See the "snurbs-vis" client
 * application to experiment with the surfaces. It is released under the GPL
 * license: see COPYING for details.
 *
 * @subsection limits_sec Limitations
 *
 * @li Degree up to 27
 * @li Only odd degree so far
 * @li No adaptive subdivision in the first version (although the design should
 *      support it for the future)
 *
 * @todo Snurbs-vis UI improvements:
 * - Show only refine/only some number of smoothing stages
 * - Visual feedback for size of knot intervals (colouring? print numbers?)
 * - Colour by gaussian curvature
 *
 * @defgroup Iterators  Iterators
 * @defgroup Mesh       Mesh Components
 * @defgroup Support    Support Classes
 * @defgroup Exception  Exceptions
 */

#ifndef SNURBS_H
#define SNURBS_H

/**
 * @file
 * Global header to include in code that uses the snurbs library.
 */

#include "mesh.h"
#include "meshbuilder.h"
#include "meshflattener.h"
#include "plyreader.h"
#include "plywriter.h"
#include "uvfwriter.h"

#endif
