/***************************************************************************
 *   Copyright (C) 2008 by Tom Cashman                                     *
 *   Tom.Cashman@cantab.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PRIMALMESHFLATTENER_H
#define PRIMALMESHFLATTENER_H

#include "meshflattener.h"

namespace snurbs {

class PatchTree;
class PatchTreeLeaf;

/**
 * Used to flatten a primal Mesh (i.e.\ one with odd @link Mesh::degree degree
 * @endlink)
 *
 * @ingroup Support
 */
class PrimalMeshFlattener : public MeshFlattener
{
public:
    /**
     * PrimalMeshFlattener constructor.
     */
    PrimalMeshFlattener(const Mesh &mesh);

    KnotInterval *getKnotIntervalForEdge(unsigned int face, unsigned int edge);

    void flattenFaces(void);
};

}

#endif
