SI-HDR - subjective evaluation of single-image high dynamic range reconstruction methods
2022 August

# Overview

The pairwise comparison experiment was conducted on a subset of 27 images from the [SI-HDR datasat](https://doi.org/10.17863/CAM.87333) (these can be viewed on the [interactive viewer](https://www.cl.cam.ac.uk/research/rainbow/projects/sihdr_benchmark/external/index.html)). 14 volunteers participated in the experiment, each completing a full batch of comparisons scheduled by ASAP [2], an active sampling algorithm.

# Structure
The attached CSV file contains results of our subjective evaluation after scaling w.r.t the input standard dynamic range (SDR) image. Each row represents quality, in just objectionable difference (JOD) units, of the reconstruction produced by one of the 7 compared methods (6 previous SI-HDR + 1 reference). The JOD values have been averaged over the 14 participants and indicate how much better or worse each method is relative to the input SDR. "jod_high" and "jod_low" refer to 95% confidence intervals. These results are plotted in Figure 3 in the main paper and Figure 1 in the supplementary.

# Project web page

More details can be found at: https://www.cl.cam.ac.uk/research/rainbow/projects/sihdr_benchmark/

If you find this data useful, please cite [1].

# References

[1] Param Hanji, Rafał K. Mantiuk, Gabriel Eilertsen, Saghi Hajisharif, and Jonas Unger. 2022. “Comparison of single image hdr reconstruction methods — the caveats of quality assessment.” In *Special Interest Group on Computer Graphics and Interactive Techniques Conference Proceedings (SIGGRAPH ’22 Conference Proceedings)*. [Online]. Available: https://www.cl.cam.ac.uk/research/rainbow/projects/sihdr_benchmark/

[2] Aliaksei Mikhailiuk, Clifford Wilmot, Maria Perez-Ortiz, Dingcheng Yue, and Rafał K. Mantiuk. 2021. “Active Sampling for Pairwise Comparisons via Approximate Message Passing and Information Gain Maximization.” In *2020 25th International Conference on Pattern Recognition (ICPR)*. 2559–2566. https://doi.org/10.1109/ICPR48806.2021.9412676

