#pragma once

#include "ParameterRange.h"

using namespace System;
using namespace System::Collections::Generic;

namespace Stereo { namespace GpGpuLib {

	/// <summary>
	/// The main abstract data type for parameter definitions.
	/// The range of values that the parameter can take is immutable,
	/// but everything else is mutable.
	/// </summary>
	public ref class TechniqueParameter abstract
	{
	protected:
		ParameterRange^ paramRange;

	public:
		TechniqueParameter(ParameterRange^ parameterRange)
			: paramRange(parameterRange) { }

		property ParameterRange^ Range
		{
			ParameterRange^ get() { return paramRange; }
		}

#pragma region Abstract properties
		virtual property Object^ Value 
		{
			Object^ get() abstract;
			void set(Object^ val) abstract;
		}

		virtual property Type^ ParameterType
		{
			Type^ get() abstract;
		}

		virtual property String^ ParameterName
		{
			String^ get() abstract;
		}

		virtual property String^ ParameterDescription
		{
			String^ get() abstract;
		}
#pragma endregion
	};


	/// <summary>
	/// The generic specialization of <code>TechniqueParameter</code>, an implementation (not abstraction) aid,
	/// which enforces type constraints when the property is set.
	/// </summary>
	generic<typename T>
	public ref class TechniqueParameterT abstract : public TechniqueParameter
	{
	public:
		TechniqueParameterT(ParameterRange^ parameterRange) 
			: TechniqueParameter(parameterRange) { }

		virtual property Object^ Value
		{
			Object^ get() override { return PropertyValue; }

			void set(Object^ val) override
			{
				if(val->GetType()->Equals(T::typeid))
					PropertyValue = (T)val;
				else
					throw gcnew InvalidOperationException(
						String::Format("The type of the parameter setter is incorrect, it should be {0}, and is {1}", 
							T::typeid, val->GetType()));
			}
		}
		virtual property Type^ ParameterType
		{
			Type^ get() override { return T::typeid; }
		}

	protected:
		virtual property T PropertyValue
		{
			T get() abstract;
			void set(T val) abstract;
		}
	};

} }