#pragma once

#include "DisparityEstimator.h"
#include <builtin_types.h>

class SimpleWtaDisparityEstimator : public DisparityEstimator
{
private:
	unsigned int* lImageCudaData;
	unsigned int* rImageCudaData;
	int imagesPitch;

	cudaPitchedPtr costCudaData;
	cudaExtent costSpaceExtent;

	void FreeCudaData();

protected:
	virtual void ReserveNewSpace(int width, int height, int ndisparities);
	virtual void GenerateDisparityMap(unsigned int* inImageL, unsigned int* inImageR, int width, int height, int ndisparities, float scaling, float* outImage);

public:
	SimpleWtaDisparityEstimator() : lImageCudaData(0), rImageCudaData(0) { costCudaData.ptr = 0; }
	virtual ~SimpleWtaDisparityEstimator();
};