#include "GpuDepthMap.h"
#include "CudaHelperCommon.cuh"

void GpuDepthMap::Create(GpuDepthMapType type, int width, int height)
{
	if(type != mapType || width != w || height != h)
	{
		Destroy();

		LOG_EVENT("Creating depth map");
		CUDA_CALL(cudaMallocPitch((void**)&gpuImage, &gpuImagePitch, width * sizeof(float), height));
		w = width;
		h = height;
		mapType = type;
	}
}

void GpuDepthMap::Destroy()
{
	LOG_EVENT("Destroying depth map");
	CUDA_FREE(gpuImage);
	w = h = 0;
}

void GpuDepthMap::CopyDataOut(float* hostData)
{
	CUDA_CALL(cudaMemcpy2D(hostData, w * sizeof(float), gpuImage, gpuImagePitch, 
		w * sizeof(float), h, cudaMemcpyDeviceToHost));
}

void GpuDepthMap::SwapData(GpuDepthMap & other)
{
	Swap<float*>(gpuImage, other.gpuImage);
	Swap<size_t>(gpuImagePitch, other.gpuImagePitch);
	Swap<GpuDepthMapType>(mapType, other.mapType);
	Swap<int>(w, other.w);
	Swap<int>(h, other.h);
}