﻿// $Id: GaussianDownsampler.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib.Parameters;
using Stereo.GpGpuLib;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Downsamples input images and cost space, but not number of disparity levels.
	/// </summary>
	[Obsolete("Sample the image (not the cost space) with ImageDownsampler instead")]
	class GaussianDownsampler : StereoNode, IDisposable
	{
		#region Parameters

		/// <summary>Gets or sets the anti-aliasing blur to apply before down-sampling</summary>
		[Parameter(Minimum = 0.01, Maximum = 10, Default = 0.25)]
		public float Sigma { get; set; }

		#endregion

		private CostSpace tempCosts = new CostSpace();

		public CostSpace Downsample(CostSpace input, int downsampleFactor, CostSpace output)
		{
			if (downsampleFactor < 2)
				return input;

			ManagedDownsamplers.BlurCostSpaceLevels(input, tempCosts, Sigma * (float)downsampleFactor);
			ManagedDownsamplers.DownsampleCostSpace(input, downsampleFactor, output);

			return output;
		}

		public void Blur(CostSpace input)
		{
			ManagedDownsamplers.BlurCostSpaceLevels(input, tempCosts, Sigma);
		}

		public override TechniqueType Type
		{
			get { return TechniqueType.Unknown; }
		}

		public void Dispose()
		{
			tempCosts.Dispose();
			tempCosts = null;
		}
	}
}
