﻿// $Id: NullAggregator.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Does not aggregate costs.
	/// </summary>
	class NullAggregator : AggregatorStereoNode
	{
		public NullAggregator() : base() { }
		public NullAggregator(ExecutionStream stream) : base(stream) { }

		/// <summary>
		/// Aggregates (locally optimizes) the costs.
		/// </summary>
		/// <remarks>Does nothing</remarks>
		/// <param name="leftImage">The left input image.</param>
		/// <param name="rightImage">The right input image.</param>
		/// <param name="costGrid">The cost grid.</param>
		public override void AggregateCosts(InputImage leftImage, InputImage rightImage, CostSpace costGrid)
		{
			// this space intentionally left blank
		}
	}

	class NullAggregatorFactory : StereoNodeFactory<AggregatorStereoNode>
	{
		public override AggregatorStereoNode Create(ExecutionStream stream)
		{
			return new NullAggregator(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = true; // always valid
		}

		public override string Name
		{
			get { return "No cost aggregation"; }
		}

		public override string SortKey { get { return "_1_" + Name; } } // put this first
	}
}
