﻿// $Id: VideoSize.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace RealTimeStereoTestViewer
{
	public class VideoSize : IComparable<VideoSize>
	{
		public VideoSize() { }
		public Size TargetSize { get; set; }

		public override string ToString()
		{
			return String.Format("{0} × {1}", TargetSize.Width, TargetSize.Height);
		}

		public override int GetHashCode() { return TargetSize.GetHashCode(); }
		public override bool Equals(object obj)
		{
			if (obj is VideoSize) return TargetSize == ((VideoSize)obj).TargetSize;
			return base.Equals(obj);
		}

		public int CompareTo(VideoSize other)
		{
			if (TargetSize.Width < other.TargetSize.Width) return -1;
			if (TargetSize.Width > other.TargetSize.Width) return 1;
			if (TargetSize.Height < other.TargetSize.Height) return -1;
			if (TargetSize.Height > other.TargetSize.Height) return 1;
			return 0;
		}
	}
}
