﻿// $Id: BoxAggregator.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;
using VideoLib.Parameters;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Aggregates costs using a simple box filter.
	/// </summary>
	class BoxAggregator : AggregatorStereoNode, IDisposable
	{
		#region Parameters

		[Parameter(Minimum = 0, Maximum = 16, Default = 3, FriendlyName = "Box radius")]
		public int FilterHsize { get; set; }

		#endregion

		private CostSpace tempCosts = new CostSpace();

		public BoxAggregator() : base() { }
		public BoxAggregator(ExecutionStream stream) : base(stream) { }

		/// <summary>
		/// Aggregates (locally optimizes) the costs.
		/// </summary>
		/// <param name="leftImage">The left input image.</param>
		/// <param name="rightImage">The right input image.</param>
		/// <param name="costGrid">The cost grid.</param>
		public override void AggregateCosts(InputImage leftImage, InputImage rightImage, CostSpace costGrid)
		{
			ManagedAggregators.RunBoxKernel(costGrid, FilterHsize, tempCosts, stream);
		}

		public void Dispose()
		{
			tempCosts.Dispose();
			tempCosts = null;
		}
	}

	class BoxAggregatorFactory : StereoNodeFactory<AggregatorStereoNode>
	{
		public override AggregatorStereoNode Create(ExecutionStream stream)
		{
			return new BoxAggregator(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = (gridType == CostSpaceType.Single); 
		}

		public override string Name
		{
			get { return "Box aggregation"; }
		}

		public override string SortKey { get { return "_2_" + Name; } } // put this second
	}
}
