// $Id: TiledGrids.h 65 2010-03-18 17:06:22Z cr333 $
#pragma once

#include "GpuTiledImages.hpp"
#include "ExecutionStream.h"

using namespace System;

namespace Stereo { namespace GpGpuLib {

/// <summary>
/// A simple wrapper around the unmanaged image type for use in managed code
/// </summary>
public ref class TiledGrids
{
private:
	GpuTiledImages3D<float2>* images;

public:
	TiledGrids()
	{
		images = new GpuTiledImages3D<float2>(1 << 13);
	}

	~TiledGrids()
	{
		if(images != 0)
		{
			delete images;
			images = 0;
		}
	}

internal:
	GpuTiledImages3D<float2>* GetPointer() { return images; }
};

} }