#pragma once

using namespace System;
using namespace System::Collections::Generic;

namespace Stereo { namespace GpGpuLib {

	/// <summary>
	/// A particular value that a discretely-valued parameter might take.
	/// As each value can be given a labelling and description, it is recommended that this be used for
	/// enumerations and integer parameters with very small ranges
	/// </summary>
	public ref struct DiscreteParameterValue
	{
	public:
		DiscreteParameterValue() : value(nullptr), name(nullptr), description(nullptr) { }

		Object^ value;
		String^ name;
		String^ description;
	};

	/// <summary>
	/// Represents a range of possible values for a parameter (either discrete or continuous).
	/// </summary>
	public ref class ParameterRange abstract
	{
	public:
		virtual property Boolean^ IsContinuous
		{
			Boolean^ get() abstract;
		}

		// Only valid if continuous
		virtual property Object^ Minimum
		{
			Object^ get() abstract;
		}
		// Only valid if continuous
		virtual property Object^ Maximum
		{
			Object^ get() abstract;
		}
		// Only valid if discrete
		virtual List<DiscreteParameterValue^>^ GetAllParameterValues() abstract;
	};


	//
	// Implementations of ParameterRange - these are trivial
	//

	public ref class ContinuousParameterRange : public ParameterRange
	{
	private:
		Object^ minimum;
		Object^ maximum;

	public:
		ContinuousParameterRange(Object^ minVal, Object^ maxVal)
			: minimum(minVal), maximum(maxVal) { }
		
#pragma region Overrides
		virtual property Boolean^ IsContinuous
		{
			Boolean^ get() override { return true; }
		}
		virtual property Object^ Minimum
		{
			Object^ get() override { return minimum; }
		}
		virtual property Object^ Maximum
		{
			Object^ get() override { return maximum; }
		}
		virtual List<DiscreteParameterValue^>^ GetAllParameterValues() override
		{
			throw gcnew InvalidOperationException("The parameter is continuous, and does not have a finite set of values");
		}
#pragma endregion
	};

	public ref class DiscreteParameterRange : public ParameterRange
	{
	private:
		List<DiscreteParameterValue^>^ parameterValues;

	public:
		DiscreteParameterRange(List<DiscreteParameterValue^>^ paramValues)
			: parameterValues(paramValues) { }

#pragma region Overrides
		virtual property Boolean^ IsContinuous
		{
			Boolean^ get() override { return false; }
		}

		virtual property Object^ Minimum
		{
			Object^ get() override { throw gcnew InvalidOperationException("The parameter is discrete, so does not have a bounded continuous range of values"); }
		}
		virtual property Object^ Maximum
		{
			Object^ get() override { throw gcnew InvalidOperationException("The parameter is discrete, so does not have a bounded continuous range of values"); }
		}
		virtual List<DiscreteParameterValue^>^ GetAllParameterValues() override
		{
			return parameterValues;
		}
#pragma endregion
	};

}}