// $Id: ManagedDownsamplers.cpp 65 2010-03-18 17:06:22Z cr333 $
#include "UnmanagedDownsamplers.h"
#include "ManagedDownsamplers.h"

using namespace Stereo::GpGpuLib;

void ManagedDownsamplers::BlurCostSpaceLevels(CostSpace^ input, CostSpace^ temp, float sigma)
{
	GpuCostSpace* gpuIn = input->Get();
	GpuCostSpace* gpuTemp = temp->Get();

	// Ensure that the temporary memory is of the correct size
	gpuTemp->Create(gpuIn->GetType(), gpuIn->GetHeight(), gpuIn->GetWidth(), gpuIn->GetDepth());

	switch(gpuIn->GetType())
	{
	case COST_SPACE_TYPE_SINGLE:
		RunCostBlurKernel(gpuIn->Get(), gpuIn->GetDepth(), sigma, gpuTemp->Get());
		RunCostBlurKernel(gpuTemp->Get(), gpuIn->GetDepth(), sigma, gpuIn->Get());
		break;
	}
}

void ManagedDownsamplers::DownsampleCostSpace(CostSpace^ input, int scaleFactor, CostSpace^ output)
{
	GpuCostSpace* gpuIn = input->Get();
	GpuCostSpace* gpuOut = output->Get();

	gpuOut->DownsampleFrom(gpuIn, scaleFactor);
}

void ManagedDownsamplers::DownsampleImage(InputImage^ input, int scaleFactor, InputImage^ output)
{
	GpuImage* gpuIn = input->Get();
	GpuImage* gpuOut = output->Get();

	gpuOut->DownsampleFrom(gpuIn, scaleFactor);
}