// $Id: ManagedCostComputers.h 65 2010-03-18 17:06:22Z cr333 $
#pragma once

#include "InputImage.h"
#include "CostSpace.h"
#include "ExecutionStream.h"

namespace Stereo { namespace GpGpuLib {

/// <summary>
/// A set of methods for computing a cost space from a pair of images, which have already been shifted such that the minimum disparity is 0.
/// </summary>
public ref class ManagedCostComputers
{
public:
    static void RunSadKernel(       InputImage^ leftImage, InputImage^ rightImage, int nDisparities, float costGradient, float costLimit, CostSpace^ costSpace, ExecutionStream^ stream);
    static void RunMadKernel(       InputImage^ leftImage, InputImage^ rightImage, int nDisparities, float costGradient, float costLimit, CostSpace^ costSpace, ExecutionStream^ stream);
    
    static void RunCrAdKernel(  InputImage^ leftImage, InputImage^ rightImage, int nDisparities, float costGradient, float costLimit, CostSpace^ costSpace, ExecutionStream^ stream);
    static void RunCrSdKernel(  InputImage^ leftImage, InputImage^ rightImage, int nDisparities, float costGradient, float costLimit, CostSpace^ costSpace, ExecutionStream^ stream);
};

} }