#pragma once

using namespace System;

namespace Stereo { namespace GpGpuLib {

	public ref class CudaException : Exception
	{
	public:
		CudaException(String^ errorString) : Exception(errorString) { }
		CudaException(String^ errorString, String^ message) : Exception(String::Format("{0} in {1}", errorString, message)) { }

		/// <summary>
		/// Gets or sets the function containing the code that threw the exception
		/// </summary>
		property String^ InFunction;
		/// <summary>
		/// Gets or sets the file containing the code that threw the exception
		/// </summary>
		property String^ InFile;
		/// <summary>
		/// Gets or sets the line number of the code that threw the exception
		/// </summary>
		property int AtLine;
	};

	public ref class CudaOutOfMemoryException : CudaException
	{
	public:
		CudaOutOfMemoryException(String^ errorString) : CudaException(errorString) { }
		CudaOutOfMemoryException(String^ errorString, String^ message) : CudaException(errorString, message) { }
	};

	public ref class CudaConfigurationException : CudaException
	{
	public:
		CudaConfigurationException(String^ errorString) : CudaException(errorString) { }
		CudaConfigurationException(String^ errorString, String^ message) : CudaException(errorString, message) { }
	};

	public ref class CudaInvalidPointerException : CudaException
	{
	public:
		CudaInvalidPointerException(String^ errorString) : CudaException(errorString) { }
		CudaInvalidPointerException(String^ errorString, String^ message) : CudaException(errorString, message) { }
	};

	public ref class CudaLaunchTimeoutException : CudaException
	{
	public:
		CudaLaunchTimeoutException(String^ errorString) : CudaException(errorString) { }
		CudaLaunchTimeoutException(String^ errorString, String^ message) : CudaException(errorString, message) { }
	};


} }