/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.IValidatable;
import org.apache.commons.beanutils.PropertyUtils;

public class JListBinding<T>
implements Binding {
    private final String _property;
    private final JList<T> _list;
    private final Color _validColor;

    public JListBinding(String property, JList<T> list) {
        if (property == null || list == null) {
            throw new NullPointerException();
        }
        if (property.equals("")) {
            throw new IllegalArgumentException();
        }
        this._property = property;
        this._list = list;
        this._validColor = this._list.getBackground();
    }

    @Override
    public String getProperty() {
        return this._property;
    }

    @Override
    public void clear(IValidatable bean) {
        this._list.setModel(new DefaultListModel());
    }

    @Override
    public void put(IValidatable bean) {
        try {
            DefaultListModel model = new DefaultListModel();
            List list = (List)PropertyUtils.getProperty(bean, this._property);
            if (list != null) {
                for (Object item : list) {
                    model.addElement(item);
                }
            }
            this._list.setModel(model);
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void get(IValidatable bean) {
        try {
            DefaultListModel model = (DefaultListModel)this._list.getModel();
            int size = model.getSize();
            ArrayList list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                list.add(model.get(i));
            }
            PropertyUtils.setProperty(bean, this._property, list);
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void markValid() {
        this._list.setBackground(this._validColor);
        this._list.requestFocusInWindow();
    }

    @Override
    public void markInvalid() {
        this._list.setBackground(Binding.INVALID_COLOR);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._list.setEnabled(enabled);
    }
}

