/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.solr.client.api.util.ReflectWritable;
import org.apache.solr.common.ConditionalKeyMapWriter;
import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.PushWriter;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.ByteArrayUtf8CharSequence;
import org.apache.solr.common.util.ByteUtils;
import org.apache.solr.common.util.BytesBlock;
import org.apache.solr.common.util.Cache;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StringBytes;
import org.apache.solr.common.util.Utf8CharSequence;
import org.apache.solr.common.util.Utils;
import org.noggit.CharArr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBinCodec
implements PushWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicBoolean WARNED_ABOUT_INDEX_TIME_BOOSTS = new AtomicBoolean();
    public static final byte NULL = 0;
    public static final byte BOOL_TRUE = 1;
    public static final byte BOOL_FALSE = 2;
    public static final byte BYTE = 3;
    public static final byte SHORT = 4;
    public static final byte DOUBLE = 5;
    public static final byte INT = 6;
    public static final byte LONG = 7;
    public static final byte FLOAT = 8;
    public static final byte DATE = 9;
    public static final byte MAP = 10;
    public static final byte SOLRDOC = 11;
    public static final byte SOLRDOCLST = 12;
    public static final byte BYTEARR = 13;
    public static final byte ITERATOR = 14;
    public static final byte END = 15;
    public static final byte SOLRINPUTDOC = 16;
    public static final byte MAP_ENTRY_ITER = 17;
    public static final byte ENUM_FIELD_VALUE = 18;
    public static final byte MAP_ENTRY = 19;
    public static final byte UUID = 20;
    public static final byte PRIMITIVE_ARR = 21;
    public static final byte TAG_AND_LEN = 32;
    public static final byte STR = 32;
    public static final byte SINT = 64;
    public static final byte SLONG = 96;
    public static final byte ARR = -128;
    public static final byte ORDERED_MAP = -96;
    public static final byte NAMED_LST = -64;
    public static final byte EXTERN_STRING = -32;
    private static final int MAX_UTF8_SIZE_FOR_ARRAY_GROW_STRATEGY = 65536;
    private static byte VERSION = (byte)2;
    private final ObjectResolver resolver;
    protected FastOutputStream daos;
    private StringCache stringCache;
    private WritableDocFields writableDocFields;
    private boolean alreadyMarshalled;
    private boolean alreadyUnmarshalled;
    protected boolean readStringAsCharSeq = false;
    private boolean readMapAsNamedList = EnvUtils.getPropertyAsBool("solr.solrj.javabin.readMapAsNamedList", false);
    byte version;
    protected static final Object END_OBJ = new Object();
    protected byte tagByte;
    public final BinEntryWriter ew = new BinEntryWriter();
    private boolean ignoreWritable = false;
    private MapWriter.EntryWriter cew;
    static final Predicate<CharSequence> IGNORECHILDDOCS = it -> !"_childDocuments_".equals(it.toString());
    public final IteratorWriter.ItemWriter itemWriter = new IteratorWriter.ItemWriter(){

        @Override
        public IteratorWriter.ItemWriter add(Object o) throws IOException {
            JavaBinCodec.this.writeVal(o);
            return this;
        }

        @Override
        public IteratorWriter.ItemWriter add(int v) throws IOException {
            JavaBinCodec.this.writeInt(v);
            return this;
        }

        @Override
        public IteratorWriter.ItemWriter add(long v) throws IOException {
            JavaBinCodec.this.writeLong(v);
            return this;
        }

        @Override
        public IteratorWriter.ItemWriter add(float v) throws IOException {
            JavaBinCodec.this.writeFloat(v);
            return this;
        }

        @Override
        public IteratorWriter.ItemWriter add(double v) throws IOException {
            JavaBinCodec.this.writeDouble(v);
            return this;
        }

        @Override
        public IteratorWriter.ItemWriter add(boolean v) throws IOException {
            JavaBinCodec.this.writeBoolean(v);
            return this;
        }
    };
    byte[] bytes;
    CharArr arr = new CharArr();
    private StringBytes bytesRef = new StringBytes(this.bytes, 0, 0);
    static final int MAX_UTF8_SZ = 65536;
    private Function<ByteArrayUtf8CharSequence, String> stringProvider;
    private BytesBlock bytesBlock;
    private int stringsCount = 0;
    private Map<String, Integer> stringsMap;
    private List<CharSequence> stringsList;

    public JavaBinCodec() {
        this.resolver = null;
        this.writableDocFields = null;
    }

    public JavaBinCodec setReadStringAsCharSeq(boolean flag) {
        this.readStringAsCharSeq = flag;
        return this;
    }

    public JavaBinCodec(OutputStream os, ObjectResolver resolver) throws IOException {
        this.resolver = resolver;
        this.initWrite(os);
    }

    public JavaBinCodec(ObjectResolver resolver) {
        this(resolver, null);
    }

    public JavaBinCodec setWritableDocFields(WritableDocFields writableDocFields) {
        this.writableDocFields = writableDocFields;
        return this;
    }

    public JavaBinCodec(ObjectResolver resolver, StringCache stringCache) {
        this.resolver = resolver;
        this.stringCache = stringCache;
    }

    public ObjectResolver getResolver() {
        return this.resolver;
    }

    public void marshal(Object nl, OutputStream os) throws IOException {
        try {
            this.initWrite(os);
            this.writeVal(nl);
        }
        finally {
            this.alreadyMarshalled = true;
            this.daos.flushBuffer();
        }
    }

    protected void initWrite(OutputStream os) throws IOException {
        assert (!this.alreadyMarshalled);
        this.init(FastOutputStream.wrap(os));
        this.daos.writeByte(VERSION);
    }

    public void init(FastOutputStream os) {
        this.daos = os;
    }

    public Object unmarshal(byte[] buf) throws IOException {
        FastInputStream dis = this.initRead(buf);
        return this.readVal(dis);
    }

    public Object unmarshal(InputStream is) throws IOException {
        FastInputStream dis = this.initRead(is);
        return this.readVal(dis);
    }

    protected FastInputStream initRead(InputStream is) throws IOException {
        assert (!this.alreadyUnmarshalled);
        FastInputStream dis = FastInputStream.wrap(is);
        return this._init(dis);
    }

    protected FastInputStream initRead(byte[] buf) throws IOException {
        assert (!this.alreadyUnmarshalled);
        FastInputStream dis = new FastInputStream(null, buf, 0, buf.length);
        return this._init(dis);
    }

    protected FastInputStream _init(FastInputStream dis) throws IOException {
        this.version = dis.readByte();
        if (this.version != VERSION) {
            throw new RuntimeException("Invalid version (expected " + VERSION + ", but " + this.version + ") or the data in not in 'javabin' format");
        }
        this.alreadyUnmarshalled = true;
        return dis;
    }

    public SimpleOrderedMap<Object> readOrderedMap(DataInputInputStream dis) throws IOException {
        int sz = this.readSize(dis);
        SimpleOrderedMap<Object> nl = new SimpleOrderedMap<Object>(sz);
        for (int i = 0; i < sz; ++i) {
            String name = (String)this.readVal(dis);
            Object val = this.readVal(dis);
            nl.add(name, val);
        }
        return nl;
    }

    public NamedList<Object> readNamedList(DataInputInputStream dis) throws IOException {
        int sz = this.readSize(dis);
        NamedList<Object> nl = new NamedList<Object>(sz);
        for (int i = 0; i < sz; ++i) {
            String name = (String)this.readVal(dis);
            Object val = this.readVal(dis);
            nl.add(name, val);
        }
        return nl;
    }

    public void writeNamedList(NamedList<?> nl) throws IOException {
        this.writeTag(nl instanceof SimpleOrderedMap ? (byte)-96 : -64, nl.size());
        for (int i = 0; i < nl.size(); ++i) {
            String name = nl.getName(i);
            this.writeExternString(name);
            Object val = nl.getVal(i);
            this.writeVal(val);
        }
    }

    public void writeVal(Object val) throws IOException {
        if (this.writeKnownType(val)) {
            return;
        }
        ObjectResolver resolver = null;
        resolver = val instanceof ObjectResolver ? (ObjectResolver)val : this.resolver;
        if (resolver != null) {
            Object tmpVal = resolver.resolve(val, this);
            if (tmpVal == null) {
                return;
            }
            if (this.writeKnownType(tmpVal)) {
                return;
            }
        }
        this.writeVal(Utils.getReflectWriter(val));
    }

    public Object readVal(DataInputInputStream dis) throws IOException {
        this.tagByte = dis.readByte();
        return this.readObject(dis);
    }

    protected Object readObject(DataInputInputStream dis) throws IOException {
        switch (this.tagByte >>> 5) {
            case 1: {
                return this.readStr(dis, this.stringCache, this.readStringAsCharSeq);
            }
            case 2: {
                return this.readSmallInt(dis);
            }
            case 3: {
                return this.readSmallLong(dis);
            }
            case 0x7FFFFFC: {
                return this.readArray(dis);
            }
            case 0x7FFFFFD: {
                return this.readOrderedMap(dis);
            }
            case 0x7FFFFFE: {
                return this.readNamedList(dis);
            }
            case 0x7FFFFFF: {
                return this.readExternString(dis);
            }
        }
        switch (this.tagByte) {
            case 0: {
                return null;
            }
            case 9: {
                return new Date(dis.readLong());
            }
            case 6: {
                return dis.readInt();
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 8: {
                return Float.valueOf(dis.readFloat());
            }
            case 5: {
                return dis.readDouble();
            }
            case 7: {
                return dis.readLong();
            }
            case 3: {
                return dis.readByte();
            }
            case 4: {
                return dis.readShort();
            }
            case 10: {
                return this.readMap(dis);
            }
            case 11: {
                return this.readSolrDocument(dis);
            }
            case 12: {
                return this.readSolrDocumentList(dis);
            }
            case 13: {
                return this.readByteArray(dis);
            }
            case 14: {
                return this.readIterator(dis);
            }
            case 15: {
                return END_OBJ;
            }
            case 16: {
                return this.readSolrInputDocument(dis);
            }
            case 18: {
                return this.readEnumFieldValue(dis);
            }
            case 19: {
                return this.readMapEntry(dis);
            }
            case 17: {
                return this.readMapIter(dis);
            }
            case 21: {
                return this.readPrimitiveArray(dis);
            }
        }
        throw new RuntimeException("Unknown type " + this.tagByte);
    }

    public boolean writeKnownType(Object val) throws IOException {
        if (this.writePrimitive(val)) {
            return true;
        }
        if (val instanceof NamedList) {
            this.writeNamedList((NamedList)val);
            return true;
        }
        if (val instanceof SolrDocumentList) {
            this.writeSolrDocumentList((SolrDocumentList)val);
            return true;
        }
        if (val instanceof SolrInputField) {
            return this.writeKnownType(((SolrInputField)val).getValue());
        }
        if (val instanceof IteratorWriter) {
            this.writeIterator((IteratorWriter)val);
            return true;
        }
        if (val instanceof Collection) {
            this.writeArray((Collection)val);
            return true;
        }
        if (val instanceof Object[]) {
            this.writeArray((Object[])val);
            return true;
        }
        if (val instanceof SolrDocument) {
            this.writeSolrDocument((SolrDocument)val);
            return true;
        }
        if (val instanceof SolrInputDocument) {
            this.writeSolrInputDocument((SolrInputDocument)val);
            return true;
        }
        if (val instanceof MapWriter) {
            this.writeMap((MapWriter)val);
            return true;
        }
        if (val instanceof ReflectWritable) {
            this.writeVal(Utils.getReflectWriter(val));
            return true;
        }
        if (val instanceof Map) {
            this.writeMap((Map)val);
            return true;
        }
        if (val instanceof Iterator) {
            this.writeIterator((Iterator)val);
            return true;
        }
        if (val instanceof Path) {
            this.writeStr(((Path)val).toAbsolutePath().toString());
            return true;
        }
        if (val instanceof Iterable) {
            this.writeIterator(((Iterable)val).iterator());
            return true;
        }
        if (val instanceof EnumFieldValue) {
            this.writeEnumFieldValue((EnumFieldValue)val);
            return true;
        }
        if (val instanceof Map.Entry) {
            this.writeMapEntry((Map.Entry)val);
            return true;
        }
        if (val instanceof MapSerializable) {
            this.writeMap(((MapSerializable)val).toMap(new NamedList().asShallowMap()));
            return true;
        }
        if (val instanceof AtomicInteger) {
            this.writeInt(((AtomicInteger)val).get());
            return true;
        }
        if (val instanceof AtomicLong) {
            this.writeLong(((AtomicLong)val).get());
            return true;
        }
        if (val instanceof AtomicBoolean) {
            this.writeBoolean(((AtomicBoolean)val).get());
            return true;
        }
        if (val instanceof float[]) {
            this.writeFloatArr((float[])val);
            return true;
        }
        if (val instanceof int[]) {
            this.writeIntArr((int[])val);
            return true;
        }
        if (val instanceof long[]) {
            this.writeLongArr((long[])val);
            return true;
        }
        if (val instanceof double[]) {
            this.writeDoubleArr((double[])val);
            return true;
        }
        if (val instanceof short[]) {
            this.writeShortArr((short[])val);
            return true;
        }
        if (val instanceof boolean[]) {
            this.writeBoolArr((boolean[])val);
            return true;
        }
        return false;
    }

    public Object readPrimitiveArray(DataInputInputStream dis) throws IOException {
        this.tagByte = dis.readByte();
        int len = JavaBinCodec.readVInt(dis);
        switch (this.tagByte) {
            case 8: {
                float[] v = new float[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = dis.readFloat();
                }
                return v;
            }
            case 6: {
                int[] v = new int[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = dis.readInt();
                }
                return v;
            }
            case 7: {
                long[] v = new long[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = dis.readLong();
                }
                return v;
            }
            case 5: {
                double[] v = new double[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = dis.readDouble();
                }
                return v;
            }
            case 4: {
                short[] v = new short[len];
                for (int i = 0; i < len; ++i) {
                    v[i] = dis.readShort();
                }
                return v;
            }
            case 1: 
            case 2: {
                boolean[] v = new boolean[len];
                for (int i = 0; i < len; ++i) {
                    byte b = dis.readByte();
                    v[i] = b != 2;
                }
                return v;
            }
            case 3: {
                byte[] v = new byte[len];
                dis.readFully(v);
                return v;
            }
        }
        throw new RuntimeException("Invalid type : " + this.tagByte);
    }

    public void writePrimitiveArrHeader(byte tag, int len) throws IOException {
        this.writeTag((byte)21);
        this.writeTag(tag);
        JavaBinCodec.writeVInt(len, this.daos);
    }

    public void writeFloatArr(float[] vals) throws IOException {
        this.writePrimitiveArrHeader((byte)8, vals.length);
        for (float f : vals) {
            this.daos.writeFloat(f);
        }
    }

    public void writeIntArr(int[] vals) throws IOException {
        this.writePrimitiveArrHeader((byte)6, vals.length);
        for (int i : vals) {
            this.daos.writeInt(i);
        }
    }

    public void writeDoubleArr(double[] vals) throws IOException {
        this.writePrimitiveArrHeader((byte)5, vals.length);
        for (double d : vals) {
            this.daos.writeDouble(d);
        }
    }

    public void writeLongArr(long[] vals) throws IOException {
        this.writePrimitiveArrHeader((byte)7, vals.length);
        for (long l : vals) {
            this.daos.writeLong(l);
        }
    }

    public void writeBoolArr(boolean[] vals) throws IOException {
        this.writePrimitiveArrHeader((byte)1, vals.length);
        for (boolean b : vals) {
            this.writeBoolean(b);
        }
    }

    public void writeShortArr(short[] vals) throws IOException {
        this.writePrimitiveArrHeader((byte)4, vals.length);
        for (short l : vals) {
            this.daos.writeShort(l);
        }
    }

    @Override
    public void writeMap(MapWriter val) throws IOException {
        this.writeTag((byte)17);
        val.writeMap(this.ew);
        this.writeTag((byte)15);
    }

    public void writeTag(byte tag) throws IOException {
        this.daos.writeByte(tag);
    }

    public void writeTag(byte tag, int size) throws IOException {
        if ((tag & 0xE0) != 0) {
            if (size < 31) {
                this.daos.writeByte(tag | size);
            } else {
                this.daos.writeByte(tag | 0x1F);
                JavaBinCodec.writeVInt(size - 31, this.daos);
            }
        } else {
            this.daos.writeByte(tag);
            JavaBinCodec.writeVInt(size, this.daos);
        }
    }

    public void writeByteArray(byte[] arr, int offset, int len) throws IOException {
        this.writeTag((byte)13, len);
        this.daos.write(arr, offset, len);
    }

    public byte[] readByteArray(DataInputInputStream dis) throws IOException {
        byte[] arr = new byte[JavaBinCodec.readVInt(dis)];
        dis.readFully(arr);
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSolrDocument(SolrDocument doc) throws IOException {
        List<SolrDocument> children = doc.getChildDocuments();
        int fieldsCount = 0;
        if (this.writableDocFields == null || this.writableDocFields.wantsAllFields() || this.ignoreWritable) {
            fieldsCount = doc.size();
        } else {
            for (Map.Entry<String, Object> e : doc) {
                if (!this.toWrite(e.getKey())) continue;
                ++fieldsCount;
            }
        }
        int sz = fieldsCount + (children == null ? 0 : children.size());
        this.writeTag((byte)11);
        this.writeTag((byte)-96, sz);
        if (this.cew == null) {
            this.cew = new ConditionalKeyMapWriter.EntryWriterWrapper(this.ew, k -> this.toWrite(k.toString()));
        }
        doc.writeMap(this.cew);
        if (children != null) {
            try {
                this.ignoreWritable = true;
                for (SolrDocument child : children) {
                    this.writeSolrDocument(child);
                }
            }
            finally {
                this.ignoreWritable = false;
            }
        }
    }

    protected boolean toWrite(String key) {
        return this.writableDocFields == null || this.ignoreWritable || this.writableDocFields.isWritable(key);
    }

    public SolrDocument readSolrDocument(DataInputInputStream dis) throws IOException {
        this.tagByte = dis.readByte();
        int size = this.readSize(dis);
        SolrDocument doc = new SolrDocument(CollectionUtil.newLinkedHashMap(size));
        for (int i = 0; i < size; ++i) {
            Object obj = this.readVal(dis);
            if (obj instanceof SolrDocument) {
                doc.addChildDocument((SolrDocument)obj);
                continue;
            }
            String fieldName = (String)obj;
            Object fieldVal = this.readVal(dis);
            doc.setField(fieldName, fieldVal);
        }
        return doc;
    }

    public SolrDocumentList readSolrDocumentList(DataInputInputStream dis) throws IOException {
        SolrDocumentList solrDocs = new SolrDocumentList();
        List list = (List)this.readVal(dis);
        solrDocs.setNumFound((Long)list.get(0));
        solrDocs.setStart((Long)list.get(1));
        solrDocs.setMaxScore((Float)list.get(2));
        if (list.size() > 3) {
            solrDocs.setNumFoundExact((Boolean)list.get(3));
        }
        List l = (List)this.readVal(dis);
        solrDocs.addAll(l);
        return solrDocs;
    }

    public void writeSolrDocumentList(SolrDocumentList docs) throws IOException {
        this.writeTag((byte)12);
        ArrayList<Serializable> l = new ArrayList<Serializable>(4);
        l.add(Long.valueOf(docs.getNumFound()));
        l.add(Long.valueOf(docs.getStart()));
        l.add(docs.getMaxScore());
        l.add(docs.getNumFoundExact());
        this.writeArray((List<?>)l);
        this.writeArray(docs);
    }

    public SolrInputDocument readSolrInputDocument(DataInputInputStream dis) throws IOException {
        int sz = JavaBinCodec.readVInt(dis);
        float docBoost = ((Float)this.readVal(dis)).floatValue();
        if (docBoost != 1.0f) {
            String message = "Ignoring document boost: " + docBoost + " as index-time boosts are not supported anymore";
            if (WARNED_ABOUT_INDEX_TIME_BOOSTS.compareAndSet(false, true)) {
                log.warn(message);
            } else {
                log.debug(message);
            }
        }
        SolrInputDocument sdoc = this.createSolrInputDocument(sz);
        for (int i = 0; i < sz; ++i) {
            String fieldName;
            Object obj = this.readVal(dis);
            if (obj instanceof Float) {
                float boost = ((Float)obj).floatValue();
                if (boost != 1.0f) {
                    String message = "Ignoring field boost: " + boost + " as index-time boosts are not supported anymore";
                    if (WARNED_ABOUT_INDEX_TIME_BOOSTS.compareAndSet(false, true)) {
                        log.warn(message);
                    } else {
                        log.debug(message);
                    }
                }
                fieldName = (String)this.readVal(dis);
            } else {
                if (obj instanceof SolrInputDocument) {
                    sdoc.addChildDocument((SolrInputDocument)obj);
                    continue;
                }
                fieldName = (String)obj;
            }
            Object fieldVal = this.readVal(dis);
            sdoc.setField(fieldName, fieldVal);
        }
        return sdoc;
    }

    protected SolrInputDocument createSolrInputDocument(int sz) {
        return new SolrInputDocument(CollectionUtil.newLinkedHashMap(sz));
    }

    public void writeSolrInputDocument(SolrInputDocument sdoc) throws IOException {
        List<SolrInputDocument> children = sdoc.getChildDocuments();
        int sz = sdoc.size() + (children == null ? 0 : children.size());
        this.writeTag((byte)16, sz);
        this.writeFloat(1.0f);
        sdoc.writeMap(new ConditionalKeyMapWriter.EntryWriterWrapper(this.ew, IGNORECHILDDOCS));
        if (children != null) {
            for (SolrInputDocument child : children) {
                this.writeSolrInputDocument(child);
            }
        }
    }

    public Map<Object, Object> readMapIter(DataInputInputStream dis) throws IOException {
        Object key;
        Map<Object, Object> m = this.newMap(-1);
        while ((key = this.readVal(dis)) != END_OBJ) {
            Object val = this.readVal(dis);
            m.put(key, val);
        }
        return m;
    }

    protected Map<Object, Object> newMap(int size) {
        return size < 0 ? new LinkedHashMap<Object, Object>() : CollectionUtil.newLinkedHashMap(size);
    }

    public Map<?, Object> readMap(DataInputInputStream dis) throws IOException {
        int sz = JavaBinCodec.readVInt(dis);
        if (this.readMapAsNamedList) {
            return this.readMapAsSimpleOrderedMapForStringKeys(dis, sz);
        }
        return this.readMap(dis, sz);
    }

    protected Map<Object, Object> readMap(DataInputInputStream dis, int sz) throws IOException {
        Map<Object, Object> m = this.newMap(sz);
        for (int i = 0; i < sz; ++i) {
            Object key = this.readVal(dis);
            Object val = this.readVal(dis);
            m.put(key, val);
        }
        return m;
    }

    protected Map<?, Object> readMapAsSimpleOrderedMapForStringKeys(DataInputInputStream dis, int sz) throws IOException {
        SimpleOrderedMap<Object> entries = new SimpleOrderedMap<Object>(sz);
        for (int i = 0; i < sz; ++i) {
            Object key = this.readVal(dis);
            Object val = this.readVal(dis);
            entries.add((String)key, val);
        }
        return entries;
    }

    @Override
    public void writeIterator(IteratorWriter val) throws IOException {
        this.writeTag((byte)14);
        val.writeIter(this.itemWriter);
        this.writeTag((byte)15);
    }

    public void writeIterator(Iterator<?> iter) throws IOException {
        this.writeTag((byte)14);
        while (iter.hasNext()) {
            this.writeVal(iter.next());
        }
        this.writeTag((byte)15);
    }

    public List<Object> readIterator(DataInputInputStream fis) throws IOException {
        Object o;
        ArrayList<Object> l = new ArrayList<Object>();
        while ((o = this.readVal(fis)) != END_OBJ) {
            l.add(o);
        }
        return l;
    }

    public void writeArray(List<?> l) throws IOException {
        this.writeTag((byte)-128, l.size());
        for (int i = 0; i < l.size(); ++i) {
            this.writeVal(l.get(i));
        }
    }

    public void writeArray(Collection<?> coll) throws IOException {
        this.writeTag((byte)-128, coll.size());
        for (Object o : coll) {
            this.writeVal(o);
        }
    }

    public void writeArray(Object[] arr) throws IOException {
        this.writeTag((byte)-128, arr.length);
        for (int i = 0; i < arr.length; ++i) {
            Object o = arr[i];
            this.writeVal(o);
        }
    }

    public List<Object> readArray(DataInputInputStream dis) throws IOException {
        int sz = this.readSize(dis);
        return this.readArray(dis, sz);
    }

    protected List readArray(DataInputInputStream dis, int sz) throws IOException {
        ArrayList<Object> l = new ArrayList<Object>(sz);
        for (int i = 0; i < sz; ++i) {
            l.add(this.readVal(dis));
        }
        return l;
    }

    public void writeEnumFieldValue(EnumFieldValue enumFieldValue) throws IOException {
        this.writeTag((byte)18);
        this.writeInt(enumFieldValue.toInt());
        this.writeStr(enumFieldValue.toString());
    }

    public void writeMapEntry(Map.Entry<?, ?> val) throws IOException {
        this.writeTag((byte)19);
        this.writeVal(val.getKey());
        this.writeVal(val.getValue());
    }

    public EnumFieldValue readEnumFieldValue(DataInputInputStream dis) throws IOException {
        Integer intValue = (Integer)this.readVal(dis);
        String stringValue = (String)ByteArrayUtf8CharSequence.convertCharSeq(this.readVal(dis));
        return new EnumFieldValue(intValue, stringValue);
    }

    public Map.Entry<Object, Object> readMapEntry(DataInputInputStream dis) throws IOException {
        final Object key = this.readVal(dis);
        final Object value = this.readVal(dis);
        return new Map.Entry<Object, Object>(){

            @Override
            public Object getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return value;
            }

            public String toString() {
                return "MapEntry[" + key + ":" + value + "]";
            }

            @Override
            public Object setValue(Object value2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode() {
                int result = 31;
                result *= 31 + this.getKey().hashCode();
                return result *= 31 + this.getValue().hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    return this.getKey().equals(entry.getKey()) && this.getValue().equals(entry.getValue());
                }
                return false;
            }
        };
    }

    public void writeStr(CharSequence s) throws IOException {
        if (s == null) {
            this.writeTag((byte)0);
            return;
        }
        if (s instanceof Utf8CharSequence) {
            this.writeUTF8Str((Utf8CharSequence)s);
            return;
        }
        int end = s.length();
        int maxSize = end * 3;
        if (maxSize <= 65536) {
            if (this.bytes == null || this.bytes.length < maxSize) {
                this.bytes = new byte[maxSize];
            }
            int sz = ByteUtils.UTF16toUTF8(s, 0, end, this.bytes, 0);
            this.writeTag((byte)32, sz);
            this.daos.write(this.bytes, 0, sz);
        } else {
            int sz = ByteUtils.calcUTF16toUTF8Length(s, 0, end);
            this.writeTag((byte)32, sz);
            if (this.bytes == null || this.bytes.length < 8192) {
                this.bytes = new byte[8192];
            }
            ByteUtils.writeUTF16toUTF8(s, 0, end, this.daos, this.bytes);
        }
    }

    public CharSequence readStr(DataInputInputStream dis) throws IOException {
        return this.readStr(dis, null, this.readStringAsCharSeq);
    }

    public CharSequence readStr(DataInputInputStream dis, StringCache stringCache, boolean readStringAsCharSeq) throws IOException {
        if (readStringAsCharSeq) {
            return this.readUtf8(dis);
        }
        int sz = this.readSize(dis);
        return this._readStr(dis, stringCache, sz);
    }

    private CharSequence _readStr(DataInputInputStream dis, StringCache stringCache, int sz) throws IOException {
        if (this.bytes == null || this.bytes.length < sz) {
            this.bytes = new byte[sz];
        }
        dis.readFully(this.bytes, 0, sz);
        if (stringCache != null) {
            return stringCache.get(this.bytesRef.reset(this.bytes, 0, sz));
        }
        this.arr.reset();
        ByteUtils.UTF8toUTF16(this.bytes, 0, sz, this.arr);
        return this.arr.toString();
    }

    protected CharSequence readUtf8(DataInputInputStream dis) throws IOException {
        int sz = this.readSize(dis);
        return this.readUtf8(dis, sz);
    }

    protected CharSequence readUtf8(DataInputInputStream dis, int sz) throws IOException {
        ByteArrayUtf8CharSequence result = new ByteArrayUtf8CharSequence(null, 0, 0);
        if (dis.readDirectUtf8(result, sz)) {
            result.stringProvider = this.getStringProvider();
            return result;
        }
        if (sz > 65536) {
            return this._readStr(dis, null, sz);
        }
        if (this.bytesBlock == null) {
            this.bytesBlock = new BytesBlock(4096);
        }
        BytesBlock block = this.bytesBlock.expand(sz);
        dis.readFully(block.getBuf(), block.getStartPos(), sz);
        result.reset(block.getBuf(), block.getStartPos(), sz, null);
        result.stringProvider = this.getStringProvider();
        return result;
    }

    private Function<ByteArrayUtf8CharSequence, String> getStringProvider() {
        if (this.stringProvider == null) {
            this.stringProvider = new Function<ByteArrayUtf8CharSequence, String>(){
                final CharArr charArr = new CharArr(8);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String apply(ByteArrayUtf8CharSequence butf8cs) {
                    CharArr charArr = this.charArr;
                    synchronized (charArr) {
                        this.charArr.reset();
                        ByteUtils.UTF8toUTF16(butf8cs.buf, butf8cs.offset(), butf8cs.size(), this.charArr);
                        return this.charArr.toString();
                    }
                }
            };
        }
        return this.stringProvider;
    }

    public void writeInt(int val) throws IOException {
        if (val > 0) {
            int b = 0x40 | val & 0xF;
            if (val >= 15) {
                this.daos.writeByte(b |= 0x10);
                JavaBinCodec.writeVInt(val >>> 4, this.daos);
            } else {
                this.daos.writeByte(b);
            }
        } else {
            this.daos.writeByte(6);
            this.daos.writeInt(val);
        }
    }

    public int readSmallInt(DataInputInputStream dis) throws IOException {
        int v = this.tagByte & 0xF;
        if ((this.tagByte & 0x10) != 0) {
            v = JavaBinCodec.readVInt(dis) << 4 | v;
        }
        return v;
    }

    public void writeLong(long val) throws IOException {
        if ((val & 0xFF00000000000000L) == 0L) {
            int b = 0x60 | (int)val & 0xF;
            if (val >= 15L) {
                this.daos.writeByte(b |= 0x10);
                JavaBinCodec.writeVLong(val >>> 4, this.daos);
            } else {
                this.daos.writeByte(b);
            }
        } else {
            this.daos.writeByte(7);
            this.daos.writeLong(val);
        }
    }

    public long readSmallLong(DataInputInputStream dis) throws IOException {
        long v = this.tagByte & 0xF;
        if ((this.tagByte & 0x10) != 0) {
            v = JavaBinCodec.readVLong(dis) << 4 | v;
        }
        return v;
    }

    public void writeFloat(float val) throws IOException {
        this.daos.writeByte(8);
        this.daos.writeFloat(val);
    }

    public boolean writePrimitive(Object val) throws IOException {
        if (val == null) {
            this.daos.writeByte(0);
            return true;
        }
        if (val instanceof Utf8CharSequence) {
            this.writeUTF8Str((Utf8CharSequence)val);
            return true;
        }
        if (val instanceof CharSequence) {
            this.writeStr((CharSequence)val);
            return true;
        }
        if (val instanceof Number) {
            if (val instanceof Integer) {
                this.writeInt((Integer)val);
                return true;
            }
            if (val instanceof Long) {
                this.writeLong((Long)val);
                return true;
            }
            if (val instanceof Float) {
                this.writeFloat(((Float)val).floatValue());
                return true;
            }
            if (val instanceof Double) {
                this.writeDouble((Double)val);
                return true;
            }
            if (val instanceof Byte) {
                this.daos.writeByte(3);
                this.daos.writeByte(((Byte)val).intValue());
                return true;
            }
            if (val instanceof Short) {
                this.daos.writeByte(4);
                this.daos.writeShort(((Short)val).intValue());
                return true;
            }
            return false;
        }
        if (val instanceof Date) {
            this.daos.writeByte(9);
            this.daos.writeLong(((Date)val).getTime());
            return true;
        }
        if (val instanceof Boolean) {
            this.writeBoolean((Boolean)val);
            return true;
        }
        if (val instanceof byte[]) {
            this.writeByteArray((byte[])val, 0, ((byte[])val).length);
            return true;
        }
        if (val instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)val;
            this.writeByteArray(buf.array(), buf.arrayOffset() + buf.position(), buf.limit() - buf.position());
            return true;
        }
        if (val == END_OBJ) {
            this.writeTag((byte)15);
            return true;
        }
        if (val instanceof LongAdder) {
            this.daos.writeLong(((LongAdder)val).longValue());
            return true;
        }
        if (val instanceof LongAccumulator) {
            this.daos.writeLong(((LongAccumulator)val).longValue());
            return true;
        }
        return false;
    }

    protected void writeBoolean(boolean val) throws IOException {
        if (val) {
            this.daos.writeByte(1);
        } else {
            this.daos.writeByte(2);
        }
    }

    protected void writeDouble(double val) throws IOException {
        this.daos.writeByte(5);
        this.daos.writeDouble(val);
    }

    public void writeMap(Map<?, ?> val) throws IOException {
        this.writeTag((byte)10, val.size());
        if (val instanceof MapWriter) {
            ((MapWriter)((Object)val)).writeMap(this.ew);
            return;
        }
        for (Map.Entry<?, ?> entry : val.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                this.writeExternString((String)key);
            } else {
                this.writeVal(key);
            }
            this.writeVal(entry.getValue());
        }
    }

    public int readSize(DataInputInputStream in) throws IOException {
        int sz = this.tagByte & 0x1F;
        if (sz == 31) {
            sz += JavaBinCodec.readVInt(in);
        }
        return sz;
    }

    public static void writeVInt(int i, FastOutputStream out) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            out.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public static int readVInt(DataInputInputStream in) throws IOException {
        byte b = in.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public static void writeVLong(long i, FastOutputStream out) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public static long readVLong(DataInputInputStream in) throws IOException {
        byte b = in.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i |= (long)(b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public void writeExternString(CharSequence s) throws IOException {
        Integer idx;
        if (s == null) {
            this.writeTag((byte)0);
            return;
        }
        Integer n = idx = this.stringsMap == null ? null : this.stringsMap.get(s.toString());
        if (idx == null) {
            idx = 0;
        }
        this.writeTag((byte)-32, idx);
        if (idx == 0) {
            this.writeStr(s);
            if (this.stringsMap == null) {
                this.stringsMap = new HashMap<String, Integer>();
            }
            this.stringsMap.put(s.toString(), ++this.stringsCount);
        }
    }

    public CharSequence readExternString(DataInputInputStream fis) throws IOException {
        int idx = this.readSize(fis);
        if (idx != 0) {
            return this.stringsList.get(idx - 1);
        }
        this.tagByte = fis.readByte();
        CharSequence s = this.readStr(fis, this.stringCache, false);
        if (s != null) {
            s = s.toString();
        }
        if (this.stringsList == null) {
            this.stringsList = new ArrayList<CharSequence>();
        }
        this.stringsList.add(s);
        return s;
    }

    public void writeUTF8Str(Utf8CharSequence utf8) throws IOException {
        this.writeTag((byte)32, utf8.size());
        this.daos.writeUtf8CharSeq(utf8);
    }

    public long getTotalBytesWritten() {
        if (this.daos != null) {
            return this.daos.written;
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.daos != null) {
            this.daos.flushBuffer();
        }
    }

    public void readMapAsNamedList(boolean readMapAsNamedList) {
        this.readMapAsNamedList = readMapAsNamedList;
    }

    public static class StringCache {
        private final Cache<StringBytes, String> cache;

        public StringCache(Cache<StringBytes, String> cache) {
            this.cache = cache;
        }

        public String get(StringBytes b) {
            String result = this.cache.get(b);
            if (result == null) {
                StringBytes copy = new StringBytes(Arrays.copyOfRange(b.bytes, b.offset, b.offset + b.length), 0, b.length);
                CharArr arr = new CharArr();
                ByteUtils.UTF8toUTF16(b.bytes, b.offset, b.length, arr);
                result = arr.toString();
                this.cache.put(copy, result);
            }
            return result;
        }
    }

    public static interface WritableDocFields {
        public boolean isWritable(String var1);

        public boolean wantsAllFields();
    }

    public static interface ObjectResolver {
        public Object resolve(Object var1, JavaBinCodec var2) throws IOException;
    }

    public class BinEntryWriter
    implements MapWriter.EntryWriter {
        private BiConsumer<CharSequence, Object> biConsumer;

        @Override
        public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
            JavaBinCodec.this.writeExternString(k);
            JavaBinCodec.this.writeVal(v);
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, int v) throws IOException {
            JavaBinCodec.this.writeExternString(k);
            JavaBinCodec.this.writeInt(v);
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, long v) throws IOException {
            JavaBinCodec.this.writeExternString(k);
            JavaBinCodec.this.writeLong(v);
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, float v) throws IOException {
            JavaBinCodec.this.writeExternString(k);
            JavaBinCodec.this.writeFloat(v);
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, double v) throws IOException {
            JavaBinCodec.this.writeExternString(k);
            JavaBinCodec.this.writeDouble(v);
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, boolean v) throws IOException {
            JavaBinCodec.this.writeExternString(k);
            JavaBinCodec.this.writeBoolean(v);
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, CharSequence v) throws IOException {
            JavaBinCodec.this.writeExternString(k);
            JavaBinCodec.this.writeStr(v);
            return this;
        }

        @Override
        public BiConsumer<CharSequence, Object> getBiConsumer() {
            if (this.biConsumer == null) {
                this.biConsumer = MapWriter.EntryWriter.super.getBiConsumer();
            }
            return this.biConsumer;
        }
    }
}

