/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.solr.client.solrj.FastStreamingDocsCallback;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DataEntry;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.FastJavaBinDecoder;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;

public class StreamingBinaryResponseParser
extends BinaryResponseParser {
    public final StreamingResponseCallback callback;
    public final FastStreamingDocsCallback fastCallback;
    private DataEntry.EntryListener fieldListener;
    private DataEntry.EntryListener docListener;

    public StreamingBinaryResponseParser(StreamingResponseCallback cb) {
        this.callback = cb;
        this.fastCallback = null;
    }

    public StreamingBinaryResponseParser(FastStreamingDocsCallback cb) {
        this.fastCallback = cb;
        this.callback = null;
    }

    @Override
    public NamedList<Object> processResponse(InputStream body, String encoding) {
        if (this.callback != null) {
            return this.streamDocs(body);
        }
        try {
            return this.fastStreamDocs(body, this.fastCallback);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse", e);
        }
    }

    private NamedList<Object> fastStreamDocs(InputStream body, final FastStreamingDocsCallback fastCallback) throws IOException {
        this.fieldListener = new DataEntry.EntryListener(){

            @Override
            public void entry(DataEntry field) {
                if (((FastJavaBinDecoder.EntryImpl)field).getTag() == FastJavaBinDecoder.Tag._SOLRDOC) {
                    field.listenContainer(fastCallback.startChildDoc(field.ctx()), StreamingBinaryResponseParser.this.fieldListener);
                } else {
                    fastCallback.field(field, field.ctx());
                }
            }

            @Override
            public void end(DataEntry e) {
                fastCallback.endDoc(((FastJavaBinDecoder.EntryImpl)e).ctx);
            }
        };
        this.docListener = e -> {
            FastJavaBinDecoder.EntryImpl entry = (FastJavaBinDecoder.EntryImpl)e;
            if (entry.getTag() == FastJavaBinDecoder.Tag._SOLRDOC) {
                entry.listenContainer(fastCallback.startDoc(entry.ctx()), this.fieldListener);
            }
        };
        new FastJavaBinDecoder().withInputStream(body).decode(new DataEntry.EntryListener(){

            @Override
            public void entry(DataEntry e) {
                FastJavaBinDecoder.EntryImpl entry = (FastJavaBinDecoder.EntryImpl)e;
                if (!entry.type().isContainer) {
                    return;
                }
                if (e.isKeyValEntry() && entry.getTag() == FastJavaBinDecoder.Tag._SOLRDOCLST) {
                    List l = (List)e.metadata();
                    e.listenContainer(fastCallback.initDocList((Long)l.get(0), (Long)l.get(1), (Float)l.get(2)), StreamingBinaryResponseParser.this.docListener);
                } else {
                    e.listenContainer(null, this);
                }
            }
        });
        return null;
    }

    private NamedList<Object> streamDocs(InputStream body) {
        NamedList namedList;
        JavaBinCodec codec = new JavaBinCodec(){
            private int nestedLevel;

            @Override
            public SolrDocument readSolrDocument(DataInputInputStream dis) throws IOException {
                ++this.nestedLevel;
                SolrDocument doc = super.readSolrDocument(dis);
                --this.nestedLevel;
                if (this.nestedLevel == 0) {
                    StreamingBinaryResponseParser.this.callback.streamSolrDocument(doc);
                    return null;
                }
                return doc;
            }

            @Override
            public SolrDocumentList readSolrDocumentList(DataInputInputStream dis) throws IOException {
                SolrDocumentList solrDocs = new SolrDocumentList();
                List list = (List)this.readVal(dis);
                solrDocs.setNumFound((Long)list.get(0));
                solrDocs.setStart((Long)list.get(1));
                solrDocs.setMaxScore((Float)list.get(2));
                StreamingBinaryResponseParser.this.callback.streamDocListInfo(solrDocs.getNumFound(), solrDocs.getStart(), solrDocs.getMaxScore());
                this.tagByte = dis.readByte();
                if (this.tagByte >>> 5 != 0x7FFFFFC) {
                    throw new RuntimeException("doclist must have an array");
                }
                int sz = this.readSize(dis);
                for (int i = 0; i < sz; ++i) {
                    this.readVal(dis);
                }
                return solrDocs;
            }
        };
        try {
            namedList = (NamedList)codec.unmarshal(body);
        }
        catch (Throwable throwable) {
            try {
                try {
                    codec.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
            }
        }
        codec.close();
        return namedList;
    }
}

