/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.CookieStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClientFunction;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.V2RequestSupport;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.AuthenticationStoreHolder;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.HttpSolrClientBase;
import org.apache.solr.client.solrj.impl.HttpSolrClientBuilderBase;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.util.AsyncListener;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProtocolHandlers;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.util.InputStreamRequestContent;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.MultiPartRequestContent;
import org.eclipse.jetty.client.util.OutputStreamRequestContent;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.KeyStoreScanner;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Http2SolrClient
extends HttpSolrClientBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REQ_PRINCIPAL_KEY = "solr-req-principal";
    private static final String USER_AGENT = "Solr[" + MethodHandles.lookup().lookupClass().getName() + "] 9.9.0";
    private static volatile SSLConfig defaultSSLConfig;
    private final HttpClient httpClient;
    private final long idleTimeoutMillis;
    private List<HttpListenerFactory> listenerFactory = new ArrayList<HttpListenerFactory>();
    protected AsyncTracker asyncTracker = new AsyncTracker();
    private final boolean closeClient;
    private ExecutorService executor;
    private boolean shutdownExecutor;
    private AuthenticationStoreHolder authenticationStore;
    private KeyStoreScanner scanner;

    protected Http2SolrClient(String serverBaseUrl, Builder builder) {
        super(serverBaseUrl, builder);
        if (builder.httpClient != null) {
            if (builder.followRedirects != null || builder.connectionTimeoutMillis != null || builder.maxConnectionsPerHost != null || builder.useHttp1_1 != null || builder.proxyHost != null || builder.sslConfig != null || builder.cookieStore != null || builder.keyStoreReloadIntervalSecs != null) {
                throw new IllegalArgumentException("You cannot provide the HttpClient and also specify options that are used to build a new client");
            }
            this.httpClient = builder.httpClient;
            if (this.executor == null) {
                this.executor = builder.executor;
            }
            this.initAuthStoreFromExistingClient(this.httpClient);
            this.closeClient = false;
        } else {
            this.httpClient = this.createHttpClient(builder);
            this.closeClient = true;
        }
        if (builder.listenerFactory != null) {
            this.listenerFactory.addAll(builder.listenerFactory);
        }
        this.updateDefaultMimeTypeForParser();
        this.httpClient.setFollowRedirects(Boolean.TRUE.equals(builder.followRedirects));
        this.idleTimeoutMillis = builder.getIdleTimeoutMillis();
        try {
            this.applyHttpClientBuilderFactory();
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Exception exceptionOnClose) {
                e.addSuppressed(exceptionOnClose);
            }
            throw e;
        }
        assert (ObjectReleaseTracker.track(this));
    }

    private void initAuthStoreFromExistingClient(HttpClient httpClient) {
        assert (httpClient.getAuthenticationStore() instanceof AuthenticationStoreHolder);
        this.authenticationStore = (AuthenticationStoreHolder)httpClient.getAuthenticationStore();
    }

    private void applyHttpClientBuilderFactory() {
        String factoryClassName = System.getProperty("solr.httpclient.builder.factory");
        if (factoryClassName != null) {
            HttpClientBuilderFactory factory;
            log.debug("Using Http Builder Factory: {}", (Object)factoryClassName);
            try {
                factory = Class.forName(factoryClassName).asSubclass(HttpClientBuilderFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to instantiate " + Http2SolrClient.class.getName(), e);
            }
            factory.setup(this);
        }
    }

    @Deprecated(since="9.7")
    public void addListenerFactory(HttpListenerFactory factory) {
        this.listenerFactory.add(factory);
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    ProtocolHandlers getProtocolHandlers() {
        return this.httpClient.getProtocolHandlers();
    }

    private HttpClient createHttpClient(Builder builder) {
        HttpClient httpClient;
        this.executor = builder.executor;
        if (this.executor == null) {
            BlockingArrayQueue queue = new BlockingArrayQueue(256, 256);
            this.executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(32, 256, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue, new SolrNamedThreadFactory("h2sc"));
            this.shutdownExecutor = true;
        } else {
            this.shutdownExecutor = false;
        }
        SSLConfig sslConfig = builder.sslConfig != null ? builder.sslConfig : defaultSSLConfig;
        SslContextFactory.Client sslContextFactory = sslConfig == null ? Http2SolrClient.getDefaultSslContextFactory() : sslConfig.createClientContextFactory();
        Long keyStoreReloadIntervalSecs = builder.keyStoreReloadIntervalSecs;
        if (keyStoreReloadIntervalSecs == null && Boolean.getBoolean("solr.keyStoreReload.enabled")) {
            keyStoreReloadIntervalSecs = Long.getLong("solr.jetty.sslContext.reload.scanInterval", 30L);
        }
        if (sslContextFactory != null && sslContextFactory.getKeyStoreResource() != null && keyStoreReloadIntervalSecs != null && keyStoreReloadIntervalSecs > 0L) {
            this.scanner = new KeyStoreScanner((SslContextFactory)sslContextFactory);
            try {
                this.scanner.setScanInterval((int)Math.min(keyStoreReloadIntervalSecs, Integer.MAX_VALUE));
                this.scanner.start();
                if (log.isDebugEnabled()) {
                    log.debug("Key Store Scanner started");
                }
            }
            catch (Exception e) {
                RuntimeException startException = new RuntimeException("Unable to start key store scanner", e);
                try {
                    this.scanner.stop();
                }
                catch (Exception stopException) {
                    startException.addSuppressed(stopException);
                }
                throw startException;
            }
        }
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setReuseAddress(true);
        clientConnector.setSslContextFactory(sslContextFactory);
        clientConnector.setSelectors(2);
        if (builder.shouldUseHttp1_1()) {
            if (log.isDebugEnabled()) {
                log.debug("Create Http2SolrClient with HTTP/1.1 transport");
            }
            HttpClientTransportOverHTTP transport = new HttpClientTransportOverHTTP(clientConnector);
            httpClient = new HttpClient((HttpClientTransport)transport);
            if (builder.maxConnectionsPerHost != null) {
                httpClient.setMaxConnectionsPerDestination(builder.maxConnectionsPerHost.intValue());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Create Http2SolrClient with HTTP/2 transport");
            }
            HTTP2Client http2client = new HTTP2Client(clientConnector);
            HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(http2client);
            httpClient = new HttpClient((HttpClientTransport)transport);
            httpClient.setMaxConnectionsPerDestination(4);
        }
        httpClient.setExecutor((Executor)this.executor);
        httpClient.setStrictEventOrdering(false);
        httpClient.setConnectBlocking(true);
        httpClient.setFollowRedirects(false);
        httpClient.setMaxRequestsQueuedPerDestination(this.asyncTracker.getMaxRequestsQueuedPerDestination());
        httpClient.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, USER_AGENT));
        httpClient.setConnectTimeout(builder.getConnectionTimeoutMillis());
        CookieStore cookieStore = builder.getCookieStore();
        if (cookieStore != null) {
            httpClient.setCookieStore(cookieStore);
        }
        this.authenticationStore = new AuthenticationStoreHolder();
        httpClient.setAuthenticationStore((AuthenticationStore)this.authenticationStore);
        this.setupProxy(builder, httpClient);
        try {
            httpClient.start();
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
        return httpClient;
    }

    private void setupProxy(Builder builder, HttpClient httpClient) {
        Socks4Proxy proxy;
        if (builder.proxyHost == null) {
            return;
        }
        Origin.Address address = new Origin.Address(builder.proxyHost, builder.proxyPort);
        if (builder.proxyIsSocks4) {
            proxy = new Socks4Proxy(address, builder.proxyIsSecure);
        } else {
            Origin.Protocol protocol;
            if (builder.shouldUseHttp1_1()) {
                protocol = HttpClientTransportOverHTTP.HTTP11;
            } else {
                String protocolName = builder.proxyIsSecure ? "h2" : "h2c";
                protocol = new Origin.Protocol(List.of(protocolName), false);
            }
            proxy = new HttpProxy(address, builder.proxyIsSecure, protocol);
        }
        httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)proxy);
    }

    @Override
    public void close() {
        this.asyncTracker.waitForComplete();
        try {
            if (this.closeClient) {
                this.httpClient.stop();
                this.httpClient.destroy();
                if (this.scanner != null) {
                    this.scanner.stop();
                    if (log.isDebugEnabled()) {
                        log.debug("Key Store Scanner stopped");
                    }
                    this.scanner = null;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception on closing client", e);
        }
        finally {
            if (this.shutdownExecutor) {
                ExecutorUtil.shutdownAndAwaitTermination(this.executor);
            }
        }
        assert (ObjectReleaseTracker.release(this));
    }

    public void setAuthenticationStore(AuthenticationStore authenticationStore) {
        this.authenticationStore.updateAuthenticationStore(authenticationStore);
    }

    public long getIdleTimeout() {
        return this.idleTimeoutMillis;
    }

    public OutStream initOutStream(String baseUrl, UpdateRequest updateRequest, String collection) throws IOException {
        String contentType = this.requestWriter.getUpdateContentType();
        ModifiableSolrParams origParams = new ModifiableSolrParams(updateRequest.getParams());
        ModifiableSolrParams requestParams = this.initializeSolrParams(updateRequest, this.responseParser(updateRequest));
        Object basePath = baseUrl;
        if (collection != null) {
            basePath = (String)basePath + "/" + collection;
        }
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        OutputStreamRequestContent content = new OutputStreamRequestContent(contentType);
        Request postRequest = this.httpClient.newRequest((String)basePath + "update" + requestParams.toQueryString()).method(HttpMethod.POST).body((Request.Content)content);
        this.decorateRequest(postRequest, updateRequest, false);
        InputStreamReleaseTrackingResponseListener responseListener = new InputStreamReleaseTrackingResponseListener();
        postRequest.send((Response.CompleteListener)responseListener);
        boolean isXml = "application/xml; charset=UTF-8".equals(this.requestWriter.getUpdateContentType());
        OutStream outStream = new OutStream(collection, origParams, content, responseListener, isXml);
        if (isXml) {
            outStream.write("<stream>".getBytes(FALLBACK_CHARSET));
        }
        return outStream;
    }

    public void send(OutStream outStream, SolrRequest<?> req, String collection) throws IOException {
        SolrParams params;
        assert (outStream.belongToThisStream(req, collection));
        this.requestWriter.write(req, outStream.content.getOutputStream());
        if (outStream.isXml && (params = req.getParams()) != null) {
            String fmt = null;
            if (params.getBool("optimize", false)) {
                fmt = "<optimize waitSearcher=\"%s\" />";
            } else if (params.getBool("commit", false)) {
                fmt = "<commit waitSearcher=\"%s\" />";
            }
            if (fmt != null) {
                byte[] content = String.format(Locale.ROOT, fmt, "" + params.getBool("waitSearcher", false)).getBytes(FALLBACK_CHARSET);
                outStream.write(content);
            }
        }
        outStream.flush();
    }

    @Override
    public Cancellable asyncRequest(SolrRequest<?> solrReq, String collection, AsyncListener<NamedList<Object>> asyncListener) {
        asyncListener.onStart();
        CompletionStage cf = this.requestAsync(solrReq, collection).whenComplete((nl, t) -> {
            if (t != null) {
                asyncListener.onFailure((Throwable)t);
            } else {
                asyncListener.onSuccess((NamedList<Object>)nl);
            }
        });
        return () -> Http2SolrClient.lambda$asyncRequest$1((CompletableFuture)cf);
    }

    @Override
    public CompletableFuture<NamedList<Object>> requestAsync(final SolrRequest<?> solrRequest, String collection) {
        MakeRequestReturnValue mrrv;
        String url;
        if (ClientUtils.shouldApplyDefaultCollection(collection, solrRequest)) {
            collection = this.defaultCollection;
        }
        final CompletableFuture<NamedList<Object>> future = new CompletableFuture<NamedList<Object>>();
        try {
            url = this.getRequestUrl(solrRequest, collection);
            mrrv = this.makeRequest(solrRequest, url, true);
        }
        catch (IOException | SolrServerException e) {
            future.completeExceptionally(e);
            return future;
        }
        mrrv.request.onRequestQueued(this.asyncTracker.queuedListener).onComplete(this.asyncTracker.completeListener).send((Response.CompleteListener)new InputStreamResponseListener(){
            MDCCopyHelper mdcCopyHelper = new MDCCopyHelper();

            public void onHeaders(Response response) {
                super.onHeaders(response);
                1 listener = this;
                Http2SolrClient.this.executor.execute(() -> {
                    InputStream is = listener.getInputStream();
                    try {
                        NamedList<Object> body = Http2SolrClient.this.processErrorsAndResponse(solrRequest, response, is, url);
                        this.mdcCopyHelper.onBegin(null);
                        log.debug("response processing success");
                        future.complete(body);
                    }
                    catch (CancellationException e) {
                        this.mdcCopyHelper.onBegin(null);
                        log.debug("response processing cancelled", (Throwable)e);
                        if (!future.isDone()) {
                            future.cancel(true);
                        }
                    }
                    catch (Throwable e) {
                        this.mdcCopyHelper.onBegin(null);
                        log.debug("response processing failed", e);
                        future.completeExceptionally(e);
                    }
                    finally {
                        log.debug("response processing completed");
                        this.mdcCopyHelper.onComplete(null);
                    }
                });
            }

            public void onFailure(Response response, Throwable failure) {
                super.onFailure(response, failure);
                future.completeExceptionally(new SolrServerException(failure.getMessage(), failure));
            }
        });
        if (mrrv.contentWriter != null) {
            try (OutputStream output = mrrv.requestContent.getOutputStream();){
                mrrv.contentWriter.write(output);
            }
            catch (IOException ioe) {
                future.completeExceptionally(ioe);
            }
        }
        return future;
    }

    @Override
    public NamedList<Object> request(SolrRequest<?> solrRequest, String collection) throws SolrServerException, IOException {
        if (ClientUtils.shouldApplyDefaultCollection(collection, solrRequest = this.unwrapV2Request(solrRequest))) {
            collection = this.defaultCollection;
        }
        String url = this.getRequestUrl(solrRequest, collection);
        Throwable abortCause = null;
        Request req = null;
        try {
            InputStreamReleaseTrackingResponseListener listener = new InputStreamReleaseTrackingResponseListener();
            req = this.sendRequest(this.makeRequest(solrRequest, url, false), listener);
            Response response = listener.get(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
            url = req.getURI().toString();
            InputStream is = listener.getInputStream();
            NamedList<Object> namedList = this.processErrorsAndResponse(solrRequest, response, is, url);
            return namedList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            abortCause = e;
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new SolrServerException("Timeout occurred while waiting response from server at: " + url, e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            abortCause = cause;
            if (cause instanceof ConnectException) {
                throw new SolrServerException("Server refused connection at: " + url, cause);
            }
            if (cause instanceof SolrServerException) {
                throw (SolrServerException)cause;
            }
            if (cause instanceof IOException) {
                throw new SolrServerException("IOException occurred when talking to server at: " + url, cause);
            }
            throw new SolrServerException(cause.getMessage(), cause);
        }
        catch (RuntimeException | SolrServerException sse) {
            abortCause = sse;
            throw sse;
        }
        finally {
            if (abortCause != null && req != null) {
                req.abort(abortCause);
            }
        }
    }

    public final <R extends SolrResponse> R requestWithBaseUrl(String baseUrl, String collection, SolrRequest<R> req) throws SolrServerException, IOException {
        return (R)this.requestWithBaseUrl(baseUrl, c -> req.process(c, collection));
    }

    public <R> R requestWithBaseUrl(String baseUrl, SolrClientFunction<Http2SolrClient, R> clientFunction) throws SolrServerException, IOException {
        try (NoCloseHttp2SolrClient derivedClient = new NoCloseHttp2SolrClient(baseUrl, this);){
            R r = clientFunction.apply(derivedClient);
            return r;
        }
    }

    private NamedList<Object> processErrorsAndResponse(SolrRequest<?> solrRequest, Response response, InputStream is, String urlExceptionMessage) throws SolrServerException {
        ResponseParser parser = solrRequest.getResponseParser() == null ? this.parser : solrRequest.getResponseParser();
        String contentType = response.getHeaders().get(HttpHeader.CONTENT_TYPE);
        String mimeType = null;
        String encoding = null;
        if (contentType != null) {
            mimeType = MimeTypes.getContentTypeWithoutCharset((String)contentType);
            encoding = MimeTypes.getCharsetFromContentType((String)contentType);
        }
        String responseMethod = response.getRequest() == null ? "" : response.getRequest().getMethod();
        return this.processErrorsAndResponse(response.getStatus(), response.getReason(), responseMethod, parser, is, mimeType, encoding, this.isV2ApiRequest(solrRequest), urlExceptionMessage);
    }

    private void setBasicAuthHeader(SolrRequest<?> solrRequest, Request req) {
        if (solrRequest.getBasicAuthUser() != null && solrRequest.getBasicAuthPassword() != null) {
            String encoded = Http2SolrClient.basicAuthCredentialsToAuthorizationString(solrRequest.getBasicAuthUser(), solrRequest.getBasicAuthPassword());
            req.headers(headers -> headers.put("Authorization", encoded));
        } else if (this.basicAuthAuthorizationStr != null) {
            req.headers(headers -> headers.put("Authorization", this.basicAuthAuthorizationStr));
        }
    }

    private void decorateRequest(Request req, SolrRequest<?> solrRequest, boolean isAsync) {
        Map<String, String> headers2;
        req.headers(headers -> headers.remove(HttpHeader.ACCEPT_ENCODING));
        req.idleTimeout(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
        req.timeout(this.requestTimeoutMillis, TimeUnit.MILLISECONDS);
        if (solrRequest.getUserPrincipal() != null) {
            req.attribute(REQ_PRINCIPAL_KEY, (Object)solrRequest.getUserPrincipal());
        }
        this.setBasicAuthHeader(solrRequest, req);
        for (HttpListenerFactory factory : this.listenerFactory) {
            HttpListenerFactory.RequestResponseListener listener = factory.get();
            listener.onQueued(req);
            req.onRequestBegin((Request.BeginListener)listener);
            req.onComplete((Response.CompleteListener)listener);
        }
        if (isAsync) {
            req.onRequestQueued(this.asyncTracker.queuedListener);
            req.onComplete(this.asyncTracker.completeListener);
        }
        if ((headers2 = solrRequest.getHeaders()) != null) {
            req.headers(h -> headers2.forEach((arg_0, arg_1) -> ((HttpFields.Mutable)h).add(arg_0, arg_1)));
        }
    }

    private SolrRequest<?> unwrapV2Request(SolrRequest<?> solrRequest) {
        if (solrRequest.getBasePath() == null && this.serverBaseUrl == null) {
            throw new IllegalArgumentException("Destination node is not provided!");
        }
        if (solrRequest instanceof V2RequestSupport) {
            return ((V2RequestSupport)((Object)solrRequest)).getV2Request();
        }
        return solrRequest;
    }

    private MakeRequestReturnValue makeRequest(SolrRequest<?> solrRequest, String url, boolean isAsync) throws IOException, SolrServerException {
        ModifiableSolrParams wparams = this.initializeSolrParams(solrRequest, this.responseParser(solrRequest));
        if (SolrRequest.METHOD.GET == solrRequest.getMethod()) {
            this.validateGetRequest(solrRequest);
            Request r = this.httpClient.newRequest(url + wparams.toQueryString()).method(HttpMethod.GET);
            this.decorateRequest(r, solrRequest, isAsync);
            return new MakeRequestReturnValue(r);
        }
        if (SolrRequest.METHOD.DELETE == solrRequest.getMethod()) {
            Request r = this.httpClient.newRequest(url + wparams.toQueryString()).method(HttpMethod.DELETE);
            this.decorateRequest(r, solrRequest, isAsync);
            return new MakeRequestReturnValue(r);
        }
        if (SolrRequest.METHOD.POST == solrRequest.getMethod() || SolrRequest.METHOD.PUT == solrRequest.getMethod()) {
            HttpMethod method;
            RequestWriter.ContentWriter contentWriter = this.requestWriter.getContentWriter(solrRequest);
            Collection<ContentStream> streams = contentWriter == null ? this.requestWriter.getContentStreams(solrRequest) : null;
            boolean isMultipart = this.isMultipart(streams);
            HttpMethod httpMethod = method = SolrRequest.METHOD.POST == solrRequest.getMethod() ? HttpMethod.POST : HttpMethod.PUT;
            if (contentWriter != null) {
                OutputStreamRequestContent content = new OutputStreamRequestContent(contentWriter.getContentType());
                Request r = this.httpClient.newRequest(url + wparams.toQueryString()).method(method).body((Request.Content)content);
                this.decorateRequest(r, solrRequest, isAsync);
                return new MakeRequestReturnValue(r, contentWriter, content);
            }
            if (streams == null || isMultipart) {
                ModifiableSolrParams queryParams = this.calculateQueryParams(this.urlParamNames, wparams);
                queryParams.add(this.calculateQueryParams(solrRequest.getQueryParams(), wparams));
                Request req = this.httpClient.newRequest(url + queryParams.toQueryString()).method(method);
                Request r = this.fillContentStream(req, streams, wparams, isMultipart);
                this.decorateRequest(r, solrRequest, isAsync);
                return new MakeRequestReturnValue(r);
            }
            ContentStream contentStream = streams.iterator().next();
            InputStreamRequestContent content = new InputStreamRequestContent(contentStream.getContentType(), contentStream.getStream());
            Request r = this.httpClient.newRequest(url + wparams.toQueryString()).method(method).body((Request.Content)content);
            this.decorateRequest(r, solrRequest, isAsync);
            return new MakeRequestReturnValue(r);
        }
        throw new SolrServerException("Unsupported method: " + solrRequest.getMethod());
    }

    private Request sendRequest(MakeRequestReturnValue mrrv, InputStreamResponseListener listener) throws IOException, SolrServerException {
        mrrv.request.send((Response.CompleteListener)listener);
        if (mrrv.contentWriter != null) {
            try (OutputStream output = mrrv.requestContent.getOutputStream();){
                mrrv.contentWriter.write(output);
            }
        }
        return mrrv.request;
    }

    private Request fillContentStream(Request req, Collection<ContentStream> streams, ModifiableSolrParams wparams, boolean isMultipart) throws IOException {
        if (isMultipart) {
            try (MultiPartRequestContent content = new MultiPartRequestContent();){
                Iterator<String> iter = wparams.getParameterNamesIterator();
                while (iter.hasNext()) {
                    String key = iter.next();
                    String[] vals = wparams.getParams(key);
                    if (vals == null) continue;
                    for (String val : vals) {
                        content.addFieldPart(key, (Request.Content)new StringRequestContent(val), null);
                    }
                }
                if (streams != null) {
                    for (ContentStream contentStream : streams) {
                        String name;
                        String contentType = contentStream.getContentType();
                        if (contentType == null) {
                            contentType = "multipart/form-data";
                        }
                        if ((name = contentStream.getName()) == null) {
                            name = "";
                        }
                        HttpFields.Mutable fields = HttpFields.build((int)1);
                        fields.add(HttpHeader.CONTENT_TYPE, contentType);
                        content.addFilePart(name, contentStream.getName(), (Request.Content)new InputStreamRequestContent(contentStream.getStream()), (HttpFields)fields);
                    }
                }
                req.body((Request.Content)content);
            }
        } else {
            String queryString = wparams.toQueryString();
            queryString = queryString.startsWith("?") ? queryString.substring(1) : queryString;
            req.body((Request.Content)new StringRequestContent("application/x-www-form-urlencoded", queryString, FALLBACK_CHARSET));
        }
        return req;
    }

    @Override
    protected boolean isFollowRedirects() {
        return this.httpClient.isFollowRedirects();
    }

    @Override
    protected boolean processorAcceptsMimeType(Collection<String> processorSupportedContentTypes, String mimeType) {
        return processorSupportedContentTypes.stream().map(ct -> MimeTypes.getContentTypeWithoutCharset((String)ct).trim()).anyMatch(mimeType::equalsIgnoreCase);
    }

    @Override
    protected String allProcessorSupportedContentTypesCommaDelimited(Collection<String> processorSupportedContentTypes) {
        return processorSupportedContentTypes.stream().map(ct -> MimeTypes.getContentTypeWithoutCharset((String)ct).trim().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", "));
    }

    @Deprecated
    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    protected RequestWriter getRequestWriter() {
        return this.requestWriter;
    }

    @Deprecated
    public void setFollowRedirects(boolean follow) {
        this.httpClient.setFollowRedirects(follow);
    }

    @Override
    public String getBaseURL() {
        return this.serverBaseUrl;
    }

    @Deprecated
    public Set<String> getQueryParams() {
        return this.getUrlParamNames();
    }

    @Deprecated
    public void setUrlParamNames(Set<String> urlParamNames) {
    }

    @Override
    protected void updateDefaultMimeTypeForParser() {
        this.defaultParserMimeTypes = this.parser.getContentTypes().stream().map(ct -> MimeTypes.getContentTypeWithoutCharset((String)ct).trim().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    }

    public static void setDefaultSSLConfig(SSLConfig sslConfig) {
        defaultSSLConfig = sslConfig;
    }

    public static void resetSslContextFactory() {
        defaultSSLConfig = null;
    }

    static SslContextFactory.Client getDefaultSslContextFactory() {
        String checkPeerNameStr = System.getProperty("solr.ssl.checkPeerName");
        boolean sslCheckPeerName = !"false".equalsIgnoreCase(checkPeerNameStr);
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(!sslCheckPeerName);
        if (null != System.getProperty("javax.net.ssl.keyStore")) {
            sslContextFactory.setKeyStorePath(System.getProperty("javax.net.ssl.keyStore"));
        }
        if (null != System.getProperty("javax.net.ssl.keyStorePassword")) {
            sslContextFactory.setKeyStorePassword(System.getProperty("javax.net.ssl.keyStorePassword"));
        }
        if (null != System.getProperty("javax.net.ssl.keyStoreType")) {
            sslContextFactory.setKeyStoreType(System.getProperty("javax.net.ssl.keyStoreType"));
        }
        if (null != System.getProperty("javax.net.ssl.trustStore")) {
            sslContextFactory.setTrustStorePath(System.getProperty("javax.net.ssl.trustStore"));
        }
        if (null != System.getProperty("javax.net.ssl.trustStorePassword")) {
            sslContextFactory.setTrustStorePassword(System.getProperty("javax.net.ssl.trustStorePassword"));
        }
        if (null != System.getProperty("javax.net.ssl.trustStoreType")) {
            sslContextFactory.setTrustStoreType(System.getProperty("javax.net.ssl.trustStoreType"));
        }
        return sslContextFactory;
    }

    private static /* synthetic */ void lambda$asyncRequest$1(CompletableFuture cf) {
        cf.cancel(true);
    }

    private static class InputStreamReleaseTrackingResponseListener
    extends InputStreamResponseListener {
        private InputStreamReleaseTrackingResponseListener() {
        }

        public InputStream getInputStream() {
            return new ObjectReleaseTrackedInputStream(super.getInputStream());
        }

        private static final class ObjectReleaseTrackedInputStream
        extends FilterInputStream {
            public ObjectReleaseTrackedInputStream(InputStream in) {
                super(in);
                assert (ObjectReleaseTracker.track(in));
            }

            @Override
            public void close() throws IOException {
                assert (ObjectReleaseTracker.release(this.in));
                super.close();
            }
        }
    }

    private static class MDCCopyHelper
    extends HttpListenerFactory.RequestResponseListener {
        private final Map<String, String> submitterContext = MDC.getCopyOfContextMap();
        private Map<String, String> threadContext;

        private MDCCopyHelper() {
        }

        @Override
        public void onBegin(Request request) {
            this.threadContext = MDC.getCopyOfContextMap();
            MDCCopyHelper.updateContextMap(this.submitterContext);
        }

        @Override
        public void onComplete(Result result) {
            MDCCopyHelper.updateContextMap(this.threadContext);
        }

        private static void updateContextMap(Map<String, String> context) {
            if (context != null && !context.isEmpty()) {
                MDC.setContextMap(context);
            } else {
                MDC.clear();
            }
        }
    }

    public static class Builder
    extends HttpSolrClientBuilderBase<Builder, Http2SolrClient> {
        private HttpClient httpClient;
        protected CookieStore cookieStore;
        private SSLConfig sslConfig;
        protected Long keyStoreReloadIntervalSecs;
        private List<HttpListenerFactory> listenerFactory;

        public Builder() {
        }

        public Builder(String baseSolrUrl) {
            this.baseSolrUrl = baseSolrUrl;
        }

        public Builder withListenerFactory(List<HttpListenerFactory> listenerFactory) {
            this.listenerFactory = listenerFactory;
            return this;
        }

        public HttpSolrClientBuilderBase<Builder, Http2SolrClient> withSSLConfig(SSLConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder maxConnectionsPerHost(int max) {
            this.withMaxConnectionsPerHost(max);
            return this;
        }

        public Builder withKeyStoreReloadInterval(long interval, TimeUnit unit) {
            this.keyStoreReloadIntervalSecs = unit.toSeconds(interval);
            if (this.keyStoreReloadIntervalSecs == 0L && interval > 0L) {
                this.keyStoreReloadIntervalSecs = 1L;
            }
            return this;
        }

        @Deprecated(since="9.2")
        public Builder idleTimeout(int idleConnectionTimeout) {
            this.withIdleTimeout(idleConnectionTimeout, TimeUnit.MILLISECONDS);
            return this;
        }

        @Deprecated(since="9.2")
        public Builder connectionTimeout(int connectionTimeout) {
            this.withConnectionTimeout(connectionTimeout, TimeUnit.MILLISECONDS);
            return this;
        }

        @Deprecated(since="9.2")
        public Builder requestTimeout(int requestTimeout) {
            this.withRequestTimeout(requestTimeout, TimeUnit.MILLISECONDS);
            return this;
        }

        private CookieStore getCookieStore() {
            if (this.cookieStore == null) {
                return this.cookieStore;
            }
            if (Boolean.getBoolean("solr.http.disableCookies")) {
                return new HttpCookieStore.Empty();
            }
            return null;
        }

        protected <B extends HttpSolrClientBase> B build(Class<B> type) {
            return (B)((HttpSolrClientBase)type.cast(this.build()));
        }

        @Override
        public Http2SolrClient build() {
            return new Http2SolrClient(this.baseSolrUrl, this);
        }

        public Builder withHttpClient(Http2SolrClient http2SolrClient) {
            this.httpClient = http2SolrClient.httpClient;
            if (this.basicAuthAuthorizationStr == null) {
                this.basicAuthAuthorizationStr = http2SolrClient.basicAuthAuthorizationStr;
            }
            if (this.idleTimeoutMillis == null) {
                this.idleTimeoutMillis = http2SolrClient.idleTimeoutMillis;
            }
            if (this.requestTimeoutMillis == null) {
                this.requestTimeoutMillis = http2SolrClient.requestTimeoutMillis;
            }
            if (this.requestWriter == null) {
                this.requestWriter = http2SolrClient.requestWriter;
            }
            if (this.responseParser == null) {
                this.responseParser = http2SolrClient.parser;
            }
            if (this.urlParamNames == null) {
                this.urlParamNames = http2SolrClient.urlParamNames;
            }
            if (this.defaultCollection == null) {
                this.defaultCollection = http2SolrClient.defaultCollection;
            }
            if (this.listenerFactory == null) {
                this.listenerFactory = new ArrayList<HttpListenerFactory>(http2SolrClient.listenerFactory);
            }
            if (this.executor == null) {
                this.executor = http2SolrClient.executor;
            }
            return this;
        }

        public Builder withCookieStore(CookieStore cookieStore) {
            this.cookieStore = cookieStore;
            return this;
        }
    }

    private static class AsyncTracker {
        private static final int MAX_OUTSTANDING_REQUESTS = 1000;
        private final Phaser phaser = new Phaser(1);
        private final Semaphore available = new Semaphore(1000, false);
        private final Request.QueuedListener queuedListener = request -> {
            this.phaser.register();
            try {
                this.available.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        private final Response.CompleteListener completeListener = result -> {
            this.phaser.arriveAndDeregister();
            this.available.release();
        };

        AsyncTracker() {
        }

        int getMaxRequestsQueuedPerDestination() {
            return 3000;
        }

        public void waitForComplete() {
            this.phaser.arriveAndAwaitAdvance();
            this.phaser.arriveAndDeregister();
        }
    }

    private static class NoCloseHttp2SolrClient
    extends Http2SolrClient {
        public NoCloseHttp2SolrClient(String baseUrl, Http2SolrClient parentClient) {
            super(baseUrl, new Builder(baseUrl).withHttpClient(parentClient));
            this.asyncTracker = parentClient.asyncTracker;
        }

        @Override
        public void close() {
            ObjectReleaseTracker.release(this);
        }
    }

    private static class MakeRequestReturnValue {
        final Request request;
        final RequestWriter.ContentWriter contentWriter;
        final OutputStreamRequestContent requestContent;

        MakeRequestReturnValue(Request request, RequestWriter.ContentWriter contentWriter, OutputStreamRequestContent requestContent) {
            this.request = request;
            this.contentWriter = contentWriter;
            this.requestContent = requestContent;
        }

        MakeRequestReturnValue(Request request) {
            this.request = request;
            this.contentWriter = null;
            this.requestContent = null;
        }
    }

    public static class OutStream
    implements Closeable {
        private final String origCollection;
        private final ModifiableSolrParams origParams;
        private final OutputStreamRequestContent content;
        private final InputStreamResponseListener responseListener;
        private final boolean isXml;

        public OutStream(String origCollection, ModifiableSolrParams origParams, OutputStreamRequestContent content, InputStreamResponseListener responseListener, boolean isXml) {
            this.origCollection = origCollection;
            this.origParams = origParams;
            this.content = content;
            this.responseListener = responseListener;
            this.isXml = isXml;
        }

        boolean belongToThisStream(SolrRequest<?> solrRequest, String collection) {
            ModifiableSolrParams solrParams = new ModifiableSolrParams(solrRequest.getParams());
            return this.origParams.toNamedList().equals(solrParams.toNamedList()) && Objects.equals(this.origCollection, collection);
        }

        public void write(byte[] b) throws IOException {
            this.content.getOutputStream().write(b);
        }

        public void flush() throws IOException {
            this.content.getOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
            if (this.isXml) {
                this.write("</stream>".getBytes(HttpSolrClientBase.FALLBACK_CHARSET));
            }
            this.content.getOutputStream().close();
        }

        public InputStreamResponseListener getResponseListener() {
            return this.responseListener;
        }
    }
}

