/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.text.ParseException;
import org.apache.solr.common.SolrException;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class SpatialUtils {
    private SpatialUtils() {
    }

    public static Shape parseGeomSolrException(String geomStr, SpatialContext ctx) {
        if (geomStr.length() == 0) {
            throw new IllegalArgumentException("0-length geometry string");
        }
        char c = geomStr.charAt(0);
        if (c == '[' || c == '{') {
            return SpatialUtils.parseRectangeSolrException(geomStr, ctx);
        }
        try {
            return ctx.readShapeFromWkt(geomStr);
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expecting WKT or '[minPoint TO maxPoint]': " + e, (Throwable)e);
        }
    }

    public static Point parsePoint(String str, SpatialContext ctx) throws InvalidShapeException {
        try {
            double y;
            double x;
            str = str.trim();
            int commaIdx = str.indexOf(44);
            if (commaIdx == -1) {
                int spaceIdx = str.indexOf(32);
                if (spaceIdx == -1) {
                    throw new InvalidShapeException("Point must be in 'lat, lon' or 'x y' format: " + str);
                }
                int middleEndIdx = SpatialUtils.findIndexNotSpace(str, spaceIdx + 1, 1);
                x = Double.parseDouble(str.substring(0, spaceIdx));
                y = Double.parseDouble(str.substring(middleEndIdx));
            } else {
                int middleStartIdx = SpatialUtils.findIndexNotSpace(str, commaIdx - 1, -1);
                int middleEndIdx = SpatialUtils.findIndexNotSpace(str, commaIdx + 1, 1);
                y = Double.parseDouble(str.substring(0, middleStartIdx + 1));
                x = Double.parseDouble(str.substring(middleEndIdx));
            }
            x = ctx.normX(x);
            y = ctx.normY(y);
            return ctx.makePoint(x, y);
        }
        catch (InvalidShapeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidShapeException(e.toString(), (Throwable)e);
        }
    }

    private static int findIndexNotSpace(String str, int startIdx, int inc) {
        int idx;
        assert (inc == 1 || inc == -1);
        for (idx = startIdx; idx >= 0 && idx < str.length() && str.charAt(idx) == ' '; idx += inc) {
        }
        return idx;
    }

    public static Point parsePointSolrException(String externalVal, SpatialContext ctx) throws SolrException {
        try {
            return SpatialUtils.parsePoint(externalVal, ctx);
        }
        catch (InvalidShapeException e) {
            Object message = e.getMessage();
            if (!((String)message).contains(externalVal)) {
                message = "Can't parse point '" + externalVal + "' because: " + (String)message;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (String)message, (Throwable)e);
        }
    }

    public static Rectangle parseRectangle(String str, SpatialContext ctx) throws InvalidShapeException {
        try {
            int toIdx = str.indexOf(" TO ");
            if (toIdx == -1 || str.charAt(0) != '[' || str.charAt(str.length() - 1) != ']') {
                throw new InvalidShapeException("expecting '[bottomLeft TO topRight]'");
            }
            String leftPart = SpatialUtils.unwrapQuotes(str.substring(1, toIdx).trim());
            String rightPart = SpatialUtils.unwrapQuotes(str.substring(toIdx + " TO ".length(), str.length() - 1).trim());
            return ctx.makeRectangle(SpatialUtils.parsePoint(leftPart, ctx), SpatialUtils.parsePoint(rightPart, ctx));
        }
        catch (InvalidShapeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidShapeException(e.toString(), (Throwable)e);
        }
    }

    public static Rectangle parseRectangeSolrException(String externalVal, SpatialContext ctx) throws SolrException {
        try {
            return SpatialUtils.parseRectangle(externalVal, ctx);
        }
        catch (InvalidShapeException e) {
            Object message = e.getMessage();
            if (!((String)message).contains(externalVal)) {
                message = "Can't parse rectangle '" + externalVal + "' because: " + (String)message;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (String)message, (Throwable)e);
        }
    }

    private static String unwrapQuotes(String str) {
        if (str.length() >= 2 && str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

