/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.JoinQParserPlugin;
import org.apache.solr.search.QueryContext;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.WrappedQuery;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetParser;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.join.GraphQuery;
import org.apache.solr.search.join.GraphQueryParser;
import org.apache.solr.util.RTimer;

public abstract class FacetRequest {
    protected Map<String, AggValueSource> facetStats = new LinkedHashMap<String, AggValueSource>();
    protected Map<String, FacetRequest> subFacets = new LinkedHashMap<String, FacetRequest>();
    protected boolean processEmpty;
    protected Domain domain;

    public static FacetRequest parse(SolrQueryRequest req, Map<String, Object> params) {
        FacetParser.FacetTopParser parser = new FacetParser.FacetTopParser(req);
        try {
            return ((FacetParser)parser).parse(params);
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
        }
    }

    public static FacetRequest parseOneFacetReq(SolrQueryRequest req, Map<String, Object> params) {
        FacetParser.FacetTopParser parser = new FacetParser.FacetTopParser(req);
        try {
            return (FacetRequest)parser.parseFacetOrStat("", params);
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
        }
    }

    public Map<String, AggValueSource> getFacetStats() {
        return this.facetStats;
    }

    public Map<String, FacetRequest> getSubFacets() {
        return this.subFacets;
    }

    public RefineMethod getRefineMethod() {
        return null;
    }

    public boolean doRefine() {
        return this.getRefineMethod() != null && this.getRefineMethod() != RefineMethod.NONE;
    }

    public boolean returnsPartial() {
        return false;
    }

    public boolean canProduceFromEmpty() {
        if (this.domain != null && this.domain.canBecomeNonEmpty()) {
            return true;
        }
        for (FacetRequest freq : this.subFacets.values()) {
            if (!freq.canProduceFromEmpty()) continue;
            return true;
        }
        return false;
    }

    public void addStat(String key, AggValueSource stat) {
        this.facetStats.put(key, stat);
    }

    public void addSubFacet(String key, FacetRequest facetRequest) {
        this.subFacets.put(key, facetRequest);
    }

    public String toString() {
        Map<String, Object> descr = this.getFacetDescription();
        StringBuilder s = new StringBuilder("facet request: { ");
        for (Map.Entry<String, Object> entry : descr.entrySet()) {
            s.append(entry.getKey()).append(':').append(entry.getValue()).append(',');
        }
        s.append('}');
        return s.toString();
    }

    public final Object process(SolrQueryRequest req, DocSet domain) throws IOException {
        FacetContext fcontext = new FacetContext();
        fcontext.base = domain;
        fcontext.req = req;
        fcontext.searcher = req.getSearcher();
        fcontext.qcontext = QueryContext.newContext(fcontext.searcher);
        return this.process(fcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object process(FacetContext fcontext) throws IOException {
        FacetProcessor<? extends FacetRequest> facetProcessor = this.createFacetProcessor(fcontext);
        FacetDebugInfo debugInfo = fcontext.getDebugInfo();
        if (debugInfo == null) {
            facetProcessor.process();
        } else {
            if (fcontext.filter != null) {
                debugInfo.setFilter(fcontext.filter.toString());
            }
            debugInfo.setReqDescription(this.getFacetDescription());
            debugInfo.setProcessor(facetProcessor.getClass().getSimpleName());
            debugInfo.putInfoItem("domainSize", fcontext.base.size());
            RTimer timer = new RTimer();
            try {
                facetProcessor.process();
            }
            finally {
                debugInfo.setElapse((long)timer.getTime());
            }
        }
        return facetProcessor.getResponse();
    }

    public abstract FacetProcessor<? extends FacetRequest> createFacetProcessor(FacetContext var1);

    public abstract FacetMerger createFacetMerger(Object var1);

    public abstract Map<String, Object> getFacetDescription();

    public static class Domain {
        public List<Object> explicitQueries;
        public List<String> excludeTags;
        public JoinField joinField;
        public GraphField graphField;
        public boolean toParent;
        public boolean toChildren;
        public String parents;
        public List<Object> filters;

        public boolean canTransformDomain() {
            return this.toParent || this.toChildren || this.explicitQueries != null || this.excludeTags != null || this.joinField != null;
        }

        public boolean canBecomeNonEmpty() {
            return this.explicitQueries != null || this.excludeTags != null;
        }

        public static class GraphField {
            public final SolrParams localParams;

            private GraphField(SolrParams localParams) {
                assert (null != localParams);
                this.localParams = localParams;
            }

            public static void createGraphField(Domain domain, Map<String, Object> domainMap) {
                assert (null != domain);
                assert (null != domainMap);
                Object queryGraph = domainMap.get("graph");
                if (null != queryGraph) {
                    if (!(queryGraph instanceof Map)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'graph' domain change requires a map containing the 'from' and 'to' fields");
                    }
                    Map graph = (Map)queryGraph;
                    if (!graph.containsKey("from") || !graph.containsKey("to") || null == graph.get("from") || null == graph.get("to")) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'graph' domain change requires non-null 'from' and 'to' field names");
                    }
                    domain.graphField = new GraphField(FacetParser.jsonToSolrParams(graph));
                }
            }

            public Query createDomainQuery(FacetContext fcontext) {
                Query fromQuery = fcontext.base.makeQuery();
                WrappedQuery wrappedFromQuery = new WrappedQuery(fromQuery);
                wrappedFromQuery.setCache(false);
                GraphQueryParser graphParser = new GraphQueryParser(null, this.localParams, null, fcontext.req);
                try {
                    GraphQuery graphQuery = (GraphQuery)graphParser.parse();
                    graphQuery.setQ(wrappedFromQuery);
                    return graphQuery;
                }
                catch (SyntaxError syntaxError) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)syntaxError);
                }
            }
        }

        public static class JoinField {
            private static final String FROM_PARAM = "from";
            private static final String TO_PARAM = "to";
            private static final String METHOD_PARAM = "method";
            private static final Set<String> SUPPORTED_JOIN_PROPERTIES = Set.of("from", "to", "method");
            public final String from;
            public final String to;
            public final String method;

            private JoinField(String from, String to, String method) {
                assert (null != from);
                assert (null != to);
                assert (null != method);
                this.from = from;
                this.to = to;
                this.method = method;
            }

            public static void createJoinField(Domain domain, Map<String, Object> domainMap) {
                assert (null != domain);
                assert (null != domainMap);
                Object queryJoin = domainMap.get("join");
                if (null != queryJoin) {
                    if (!(queryJoin instanceof Map)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'join' domain change requires a map containing the 'from' and 'to' fields");
                    }
                    Map join = (Map)queryJoin;
                    if (!join.containsKey(FROM_PARAM) || !join.containsKey(TO_PARAM) || null == join.get(FROM_PARAM) || null == join.get(TO_PARAM)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'join' domain change requires non-null 'from' and 'to' field names");
                    }
                    for (String providedKey : join.keySet()) {
                        if (SUPPORTED_JOIN_PROPERTIES.contains(providedKey)) continue;
                        String supportedPropsStr = String.join((CharSequence)", ", SUPPORTED_JOIN_PROPERTIES);
                        String message = String.format(Locale.ROOT, "'join' domain change contains unexpected key [%s], only %s supported", providedKey, supportedPropsStr);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                    }
                    String method = join.containsKey(METHOD_PARAM) ? (String)join.get(METHOD_PARAM) : "index";
                    domain.joinField = new JoinField((String)join.get(FROM_PARAM), (String)join.get(TO_PARAM), method);
                }
            }

            public Query createDomainQuery(FacetContext fcontext) {
                Query fromQuery = fcontext.base.makeQuery();
                WrappedQuery wrappedFromQuery = new WrappedQuery(fromQuery);
                wrappedFromQuery.setCache(false);
                return JoinQParserPlugin.createJoinQuery(wrappedFromQuery, this.from, this.to, this.method);
            }
        }
    }

    public static enum RefineMethod {
        NONE,
        SIMPLE;


        public static RefineMethod fromObj(Object method) {
            if (method == null) {
                return null;
            }
            if (method instanceof Boolean) {
                return (Boolean)method != false ? SIMPLE : NONE;
            }
            if ("simple".equals(method)) {
                return SIMPLE;
            }
            if ("none".equals(method)) {
                return NONE;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown RefineMethod method " + method);
        }
    }

    public static enum SortDirection {
        asc(-1),
        desc(1);

        private final int multiplier;

        private SortDirection(int multiplier) {
            this.multiplier = multiplier;
        }

        public static SortDirection fromObj(Object direction) {
            if (direction == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing Sort direction");
            }
            switch (direction.toString()) {
                case "asc": {
                    return asc;
                }
                case "desc": {
                    return desc;
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Sort direction '" + direction + "'");
        }

        public int getMultiplier() {
            return this.multiplier;
        }
    }

    public static final class FacetSort {
        final String sortVariable;
        final SortDirection sortDirection;
        public static final FacetSort COUNT_DESC = new FacetSort("count", SortDirection.desc);
        public static final FacetSort INDEX_ASC = new FacetSort("index", SortDirection.asc);

        public FacetSort(String sortVariable, SortDirection sortDirection) {
            assert (null != sortVariable);
            assert (null != sortDirection);
            this.sortVariable = sortVariable;
            this.sortDirection = sortDirection;
        }

        public boolean equals(Object other) {
            if (other instanceof FacetSort) {
                FacetSort that = (FacetSort)other;
                return this.sortVariable.equals(that.sortVariable) && this.sortDirection.equals((Object)that.sortDirection);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sortVariable, this.sortDirection});
        }

        public String toString() {
            return this.sortVariable + " " + this.sortDirection;
        }
    }
}

