/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.highlight.DefaultSolrHighlighter;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.highlight.UnifiedSolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryLimits;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.SolrResponseUtil;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;

public class HighlightComponent
extends SearchComponent
implements PluginInfoInitialized,
SolrCoreAware {
    public static final String COMPONENT_NAME = "highlight";
    protected PluginInfo info = PluginInfo.EMPTY_INFO;
    protected SolrHighlighter solrConfigHighlighter;

    @Override
    public void init(PluginInfo info) {
        this.info = info;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        rb.doHighlights = this.solrConfigHighlighter.isHighlightingEnabled(params);
        if (rb.doHighlights) {
            rb.setNeedDocList(true);
            String hlq = params.get("hl.q");
            String hlparser = Objects.requireNonNullElse(params.get("hl.qparser"), params.get("defType", "lucene"));
            if (hlq != null) {
                try {
                    QParser parser = QParser.getParser(hlq, hlparser, rb.req);
                    rb.setHighlightQuery(parser.getHighlightQuery());
                }
                catch (SyntaxError e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void inform(SolrCore core) {
        List<PluginInfo> children = this.info.getChildren("highlighting");
        if (children.isEmpty()) {
            DefaultSolrHighlighter defHighlighter = new DefaultSolrHighlighter(core);
            defHighlighter.init(PluginInfo.EMPTY_INFO);
            this.solrConfigHighlighter = defHighlighter;
        } else {
            this.solrConfigHighlighter = core.createInitInstance(children.get(0), SolrHighlighter.class, null, DefaultSolrHighlighter.class.getName());
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (rb.doHighlights) {
            SolrQueryRequest req = rb.req;
            SolrParams params = req.getParams();
            SolrHighlighter highlighter = this.getHighlighter(params);
            String[] defaultHighlightFields = rb.getQparser() != null ? rb.getQparser().getDefaultHighlightFields() : null;
            Query highlightQuery = rb.getHighlightQuery();
            if (highlightQuery == null) {
                if (rb.getQparser() != null) {
                    try {
                        highlightQuery = rb.getQparser().getHighlightQuery();
                        rb.setHighlightQuery(highlightQuery);
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                } else {
                    highlightQuery = rb.getQuery();
                    rb.setHighlightQuery(highlightQuery);
                }
            }
            if (highlightQuery != null) {
                NamedList<Object> sumData = highlighter.doHighlighting(rb.getResults().docList, highlightQuery, req, defaultHighlightFields);
                if (sumData != null) {
                    rb.rsp.add(this.highlightingResponseField(), this.convertHighlights(sumData));
                }
                QueryLimits queryLimits = QueryLimits.getCurrentLimits();
                queryLimits.maybeExitWithPartialResults("Highlighting process");
            }
        }
    }

    public SolrHighlighter getHighlighter(SolrParams params) {
        HighlightMethod method = HighlightMethod.parse(params.get("hl.method", "unified"));
        switch (method) {
            case UNIFIED: {
                if (this.solrConfigHighlighter instanceof UnifiedSolrHighlighter) {
                    return this.solrConfigHighlighter;
                }
                return new UnifiedSolrHighlighter();
            }
            case FAST_VECTOR: 
            case ORIGINAL: {
                return this.solrConfigHighlighter;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.doHighlights) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            sreq.purpose |= 0x80;
            sreq.params.set("hl", new String[]{"true"});
        } else {
            sreq.params.set("hl", new String[]{"false"});
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.doHighlights && rb.stage == 3000) {
            Object[] objArr = this.newHighlightsArray(rb.resultIds.size());
            String highlightingResponseField = this.highlightingResponseField();
            for (ShardRequest sreq : rb.finished) {
                if ((sreq.purpose & 0x80) == 0) continue;
                for (ShardResponse srsp : sreq.responses) {
                    Object hl;
                    if (srsp.getException() != null || (hl = SolrResponseUtil.getSubsectionFromShardResponse(rb, srsp, highlightingResponseField, false)) == null) continue;
                    this.addHighlights(objArr, hl, rb.resultIds);
                }
            }
            rb.rsp.add(highlightingResponseField, this.getAllHighlights(objArr));
        }
    }

    @Override
    public String getDescription() {
        return "Highlighting";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.HIGHLIGHTER;
    }

    protected String highlightingResponseField() {
        return "highlighting";
    }

    protected Object convertHighlights(NamedList<Object> hl) {
        return hl;
    }

    protected Object[] newHighlightsArray(int size) {
        return (Object[])Array.newInstance(NamedList.NamedListEntry.class, size);
    }

    protected void addHighlights(Object[] objArr, Object obj, Map<Object, ShardDoc> resultIds) {
        Map.Entry[] arr = (Map.Entry[])objArr;
        NamedList hl = (NamedList)obj;
        SolrPluginUtils.copyNamedListIntoArrayByDocPosInResponse((NamedList<Object>)hl, resultIds, arr);
    }

    protected Object getAllHighlights(Object[] objArr) {
        Map.Entry[] arr = (Map.Entry[])objArr;
        return SolrPluginUtils.removeNulls(arr, new SimpleOrderedMap());
    }

    public static enum HighlightMethod {
        UNIFIED("unified"),
        FAST_VECTOR("fastVector"),
        ORIGINAL("original");

        private static final Map<String, HighlightMethod> METHODS;
        private final String methodName;

        private HighlightMethod(String method) {
            this.methodName = method;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public static HighlightMethod parse(String method) {
            return METHODS.get(method);
        }

        static {
            METHODS = Stream.of(HighlightMethod.values()).collect(Collectors.toUnmodifiableMap(HighlightMethod::getMethodName, Function.identity()));
        }
    }
}

