/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.ucore;

import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.engine.satlab.ResolutionTrace;
import kodkod.engine.ucore.StrategyUtils;
import kodkod.util.ints.IntCollection;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

public final class SCEStrategy
implements ReductionStrategy {
    private final IntCollection varsToTry;

    public SCEStrategy(TranslationLog translationLog) {
        this.varsToTry = StrategyUtils.rootVars(translationLog);
    }

    @Override
    public IntSet next(ResolutionTrace resolutionTrace) {
        if (this.varsToTry.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        IntSet intSet = StrategyUtils.coreTailUnits(resolutionTrace);
        IntIterator intIterator = this.varsToTry.iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            intIterator.remove();
            if (!intSet.remove(n)) continue;
            if (intSet.isEmpty()) break;
            IntSet intSet2 = StrategyUtils.clausesFor(resolutionTrace, intSet);
            assert (!intSet2.isEmpty() && !intSet2.contains(resolutionTrace.size() - 1));
            return intSet2;
        }
        this.varsToTry.clear();
        return Ints.EMPTY_SET;
    }
}

