/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.ucore;

import java.util.Arrays;
import java.util.Iterator;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.satlab.Clause;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.engine.satlab.ResolutionTrace;
import kodkod.engine.ucore.StrategyUtils;
import kodkod.util.ints.IntBitSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;
import kodkod.util.ints.SparseSequence;
import kodkod.util.ints.TreeSequence;

public final class DynamicRCEStrategy
implements ReductionStrategy {
    private final double noRecycleRatio;
    private final double recycleLimit;
    private final double hardnessCutOff;
    private static final boolean DBG = true;
    private final SparseSequence<IntSet> hits;

    public DynamicRCEStrategy(TranslationLog translationLog) {
        this(translationLog, 0.03, 2.0, 1.2);
    }

    public DynamicRCEStrategy(TranslationLog translationLog, double d, double d2, double d3) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("noRecycleRatio must be in [0..1]: " + d);
        }
        if (d2 < 1.0) {
            throw new IllegalArgumentException("hardnessCutOff must be >=1: " + d2);
        }
        if (d3 < 1.0) {
            throw new IllegalArgumentException("recycleLimit must be >=1: " + d3);
        }
        this.noRecycleRatio = d;
        this.hardnessCutOff = d2;
        this.recycleLimit = d3;
        this.hits = new TreeSequence<IntSet>();
        IntIterator intIterator = StrategyUtils.rootVars(translationLog).iterator();
        while (intIterator.hasNext()) {
            this.hits.put(intIterator.next(), null);
        }
    }

    @Override
    public IntSet next(ResolutionTrace resolutionTrace) {
        if (this.hits.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        IntSet intSet = StrategyUtils.coreTailUnits(resolutionTrace);
        long[] lArray = this.sortByRelevance(resolutionTrace, intSet);
        this.printRelevant(lArray);
        for (int i = lArray.length - 1; i >= 0; --i) {
            int n = (int)lArray[i];
            if (this.hits.remove(n) == null) continue;
            intSet.remove(n);
            if (intSet.isEmpty()) break;
            IntSet intSet2 = this.clausesFor(resolutionTrace, intSet);
            assert (!intSet2.isEmpty() && !intSet2.contains(resolutionTrace.size() - 1));
            System.out.println("relevant clauses: " + intSet2.size() + ", removed " + n);
            return intSet2;
        }
        this.hits.clear();
        return Ints.EMPTY_SET;
    }

    private final void printRelevant(long[] lArray) {
        System.out.print("\nsorted by relevance: ");
        for (long l : lArray) {
            System.out.print((int)(l >>> 32) + ":" + (int)l + " ");
        }
        System.out.println();
    }

    private long[] sortByRelevance(ResolutionTrace resolutionTrace, IntSet intSet) {
        Iterator<Clause> iterator;
        this.hits.indices().retainAll(intSet);
        if (this.hits.get(this.hits.indices().min()) == null) {
            iterator = intSet.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                IntBitSet intBitSet = new IntBitSet(n + 1);
                intBitSet.add(n);
                this.hits.put(n, intBitSet);
            }
            iterator = resolutionTrace.reverseIterator(resolutionTrace.axioms());
            while (iterator.hasNext()) {
                Clause clause = iterator.next();
                int n = clause.maxVariable();
                for (IntSet intSet2 : this.hits.values()) {
                    if (!intSet2.contains(n)) continue;
                    IntIterator intIterator = clause.literals();
                    while (intIterator.hasNext()) {
                        intSet2.add(StrictMath.abs(intIterator.next()));
                    }
                }
            }
        }
        iterator = (Iterator<Clause>)new long[this.hits.size()];
        Iterator<Clause> iterator2 = resolutionTrace.iterator(resolutionTrace.core());
        while (iterator2.hasNext()) {
            Clause clause = iterator2.next();
            int n = clause.maxVariable();
            int n2 = 0;
            for (IntSet intSet3 : this.hits.values()) {
                if (intSet3.contains(n)) {
                    Iterator<Clause> iterator3 = iterator;
                    int n3 = n2;
                    iterator3[n3] = iterator3[n3] + 1L;
                }
                ++n2;
            }
        }
        int n = 0;
        IntIterator intIterator = this.hits.indices().iterator();
        while (intIterator.hasNext()) {
            int n4 = intIterator.next();
            iterator[n] = iterator[n] << 32 | (long)n4;
            ++n;
        }
        Arrays.sort(iterator);
        return iterator;
    }

    private IntSet clausesFor(ResolutionTrace resolutionTrace, IntSet intSet) {
        IntSet intSet2;
        double d = (double)resolutionTrace.size() / (double)resolutionTrace.axioms().size();
        double d2 = (double)resolutionTrace.core().size() / (double)resolutionTrace.axioms().size();
        System.out.println("trace size: " + resolutionTrace.size() + ", axioms: " + resolutionTrace.axioms().size() + ", core: " + resolutionTrace.core().size() + ", resolvents: " + resolutionTrace.resolvents().size());
        System.out.println("hardness: " + d + ", coreRatio: " + d2);
        IntSet intSet3 = StrategyUtils.clausesFor(resolutionTrace, intSet);
        System.out.println("relevant axioms:  " + intSet3.size());
        if (d2 < this.noRecycleRatio) {
            return intSet3;
        }
        if (d < this.hardnessCutOff) {
            return resolutionTrace.learnable(intSet3);
        }
        IntSet intSet4 = intSet3;
        int n = (int)Math.rint((double)intSet3.size() * this.recycleLimit);
        do {
            intSet2 = intSet4;
            intSet4 = resolutionTrace.directlyLearnable(intSet4);
        } while (intSet2.size() < intSet4.size() && intSet4.size() < n);
        System.out.println("last: " + intSet2.size() + ", current: " + intSet4.size() + ", maxRelevant: " + n);
        return intSet4.size() < n ? intSet4 : intSet2;
    }
}

