/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.satlab;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import kodkod.engine.satlab.CryptoMiniSat;
import kodkod.engine.satlab.ExternalSolver;
import kodkod.engine.satlab.Lingeling;
import kodkod.engine.satlab.MiniSat;
import kodkod.engine.satlab.MiniSatProver;
import kodkod.engine.satlab.SAT4J;
import kodkod.engine.satlab.SATAbortedException;
import kodkod.engine.satlab.SATSolver;
import kodkod.engine.satlab.ZChaffMincost;
import org.sat4j.minisat.SolverFactory;

public abstract class SATFactory {
    public static final SATFactory DefaultSAT4J = new SATFactory(){

        @Override
        public SATSolver instance() {
            return new SAT4J(SolverFactory.instance().defaultSolver());
        }

        public String toString() {
            return "DefaultSAT4J";
        }
    };
    public static final SATFactory LightSAT4J = new SATFactory(){

        @Override
        public SATSolver instance() {
            return new SAT4J(SolverFactory.instance().lightSolver());
        }

        public String toString() {
            return "LightSAT4J";
        }
    };
    public static final SATFactory ZChaffMincost = new SATFactory(){

        @Override
        public SATSolver instance() {
            return new ZChaffMincost();
        }

        @Override
        public boolean minimizer() {
            return true;
        }

        @Override
        public boolean incremental() {
            return false;
        }

        public String toString() {
            return "ZChaffMincost";
        }
    };
    public static final SATFactory MiniSatProver = new SATFactory(){

        @Override
        public SATSolver instance() {
            return new MiniSatProver();
        }

        @Override
        public boolean prover() {
            return true;
        }

        public String toString() {
            return "MiniSatProver";
        }
    };
    public static final SATFactory MiniSat = new SATFactory(){

        @Override
        public SATSolver instance() {
            return new MiniSat();
        }

        public String toString() {
            return "MiniSat";
        }
    };
    public static final SATFactory CryptoMiniSat = new SATFactory(){

        @Override
        public SATSolver instance() {
            return new CryptoMiniSat();
        }

        public String toString() {
            return "CryptoMiniSat";
        }
    };
    public static final SATFactory Lingeling = new SATFactory(){

        @Override
        public SATSolver instance() {
            return new Lingeling();
        }

        public String toString() {
            return "Lingeling";
        }
    };

    protected SATFactory() {
    }

    public static final SATFactory plingeling() {
        return SATFactory.plingeling(null, null);
    }

    public static final SATFactory plingeling(Integer n, Boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (n != null) {
            if (n < 1) {
                throw new IllegalArgumentException("Number of threads must be at least 1: numberOfThreads=" + n);
            }
            arrayList.add("-t");
            arrayList.add(n.toString());
        }
        if (bl != null && bl.booleanValue()) {
            arrayList.add("-p");
        }
        return SATFactory.externalFactory(SATFactory.findStaticLibrary("plingeling"), null, arrayList.toArray(new String[arrayList.size()]));
    }

    private static String findStaticLibrary(String string) {
        String[] stringArray = System.getProperty("java.library.path").split(System.getProperty("path.separator"));
        for (int i = stringArray.length - 1; i >= 0; --i) {
            File file = new File(stringArray[i] + File.separator + string);
            if (!file.canExecute()) continue;
            return file.getAbsolutePath();
        }
        throw new SATAbortedException("Could not find an executable named " + string + " on the java.library.path: " + System.getProperty("java.library.path"));
    }

    public static final SATFactory sat4jFactory(final String string) {
        return new SATFactory(){

            @Override
            public SATSolver instance() {
                return new SAT4J(SolverFactory.instance().createSolverByName(string));
            }

            public String toString() {
                return string;
            }
        };
    }

    public static final SATFactory externalFactory(final String string, final String string2, final String ... stringArray) {
        return new SATFactory(){

            @Override
            public SATSolver instance() {
                if (string2 != null) {
                    return new ExternalSolver(string, string2, false, stringArray);
                }
                try {
                    return new ExternalSolver(string, File.createTempFile("kodkod", String.valueOf(string.hashCode())).getAbsolutePath(), true, stringArray);
                }
                catch (IOException iOException) {
                    throw new SATAbortedException("Could not create a temporary file.", iOException);
                }
            }

            @Override
            public boolean incremental() {
                return false;
            }
        };
    }

    public abstract SATSolver instance();

    public boolean prover() {
        return false;
    }

    public boolean minimizer() {
        return false;
    }

    public boolean incremental() {
        return true;
    }
}

