/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.Node;
import kodkod.ast.Variable;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.fol2sat.Environment;
import kodkod.engine.fol2sat.FreeVariableCollector;
import kodkod.util.nodes.AnnotatedNode;

final class FOL2BoolCache {
    private final Map<Node, Record> cache;

    FOL2BoolCache(AnnotatedNode<? extends Node> annotatedNode) {
        CacheCollector cacheCollector = new CacheCollector(annotatedNode.sharedNodes());
        annotatedNode.node().accept(cacheCollector);
        this.cache = new IdentityHashMap<Node, Record>(cacheCollector.cache().size());
        for (Map.Entry<Node, Set<Variable>> entry : cacheCollector.cache().entrySet()) {
            Set<Variable> set = entry.getValue();
            if (set.isEmpty()) {
                this.cache.put(entry.getKey(), new NoVarRecord());
                continue;
            }
            this.cache.put(entry.getKey(), new MultiVarRecord(set));
        }
    }

    <T> T lookup(Node node, Environment<BooleanMatrix> environment) {
        Record record = this.cache.get(node);
        return (T)(record == null ? null : record.get(environment));
    }

    final <T> T cache(Node node, T t, Environment<BooleanMatrix> environment) {
        Record record = this.cache.get(node);
        if (record != null) {
            record.set(t, environment);
        }
        return t;
    }

    private static final class NoVarRecord
    extends Record {
        private NoVarRecord() {
        }

        @Override
        Object get(Environment<BooleanMatrix> environment) {
            return this.translation;
        }

        @Override
        void set(Object object, Environment<BooleanMatrix> environment) {
            this.translation = object;
        }

        public String toString() {
            return "{" + this.translation + "}";
        }
    }

    private static final class MultiVarRecord
    extends Record {
        final Variable[] vars;
        final int[] tuples;

        MultiVarRecord(Set<Variable> set) {
            this.vars = set.toArray(new Variable[set.size()]);
            this.tuples = new int[set.size()];
        }

        @Override
        Object get(Environment<BooleanMatrix> environment) {
            if (this.translation == null) {
                return null;
            }
            for (int i = 0; i < this.vars.length; ++i) {
                if (environment.lookup(this.vars[i]).get(this.tuples[i]) == BooleanConstant.TRUE) continue;
                return null;
            }
            return this.translation;
        }

        @Override
        void set(Object object, Environment<BooleanMatrix> environment) {
            this.translation = object;
            for (int i = 0; i < this.vars.length; ++i) {
                BooleanMatrix booleanMatrix = environment.lookup(this.vars[i]);
                this.tuples[i] = booleanMatrix.iterator().next().index();
                if (object != booleanMatrix) continue;
                this.translation = booleanMatrix.clone();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{");
            stringBuilder.append(String.valueOf(this.translation));
            for (int i = 0; i < this.vars.length; ++i) {
                stringBuilder.append(" (");
                stringBuilder.append(this.vars[i]);
                stringBuilder.append(", ");
                stringBuilder.append(this.tuples[i]);
                stringBuilder.append(")");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    private static abstract class Record {
        Object translation;

        private Record() {
        }

        abstract Object get(Environment<BooleanMatrix> var1);

        abstract void set(Object var1, Environment<BooleanMatrix> var2);
    }

    private static final class CacheCollector
    extends FreeVariableCollector {
        protected CacheCollector(Set<Node> set) {
            super(set);
        }

        final Map<Node, Set<Variable>> cache() {
            return this.cache;
        }

        @Override
        protected final Set<Variable> cache(Node node, Set<Variable> set) {
            if (this.cached.contains(node) || !this.varsInScope.empty() && !set.contains(this.varsInScope.peek())) {
                this.cache.put(node, this.reduce(set));
            }
            return set;
        }
    }
}

