/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import java.util.LinkedList;
import kodkod.engine.bool.BinaryGate;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.BooleanVariable;
import kodkod.engine.bool.ITEGate;
import kodkod.engine.bool.Operator;
import kodkod.util.collections.CacheSet;

final class RBCFactory {
    private final BooleanVariable[] vars;
    private final CacheSet<BooleanFormula>[] cache;
    private int label;
    private int cmpMax;

    RBCFactory(int n, int n2) {
        assert (n2 > 0 && n >= 0);
        this.cmpMax = n2;
        this.label = n + 1;
        this.vars = new BooleanVariable[n];
        for (int i = 0; i < n; ++i) {
            this.vars[i] = new BooleanVariable(i + 1);
        }
        this.cache = new CacheSet[]{new CacheSet(), new CacheSet(), new CacheSet()};
    }

    private CacheSet<BooleanFormula> opCache(Operator operator) {
        return this.cache[operator.ordinal];
    }

    void setCmpMax(int n) {
        assert (n > 0);
        this.cmpMax = n;
    }

    int cmpMax() {
        return this.cmpMax;
    }

    void clear() {
        this.label = this.vars.length + 1;
        this.cache[0].clear();
        this.cache[1].clear();
        this.cache[2].clear();
    }

    boolean canAssemble(BooleanValue booleanValue) {
        int n;
        if (booleanValue.op() == Operator.CONST) {
            return true;
        }
        if (booleanValue.label() < 0) {
            booleanValue = booleanValue.negation();
        }
        if ((n = booleanValue.label()) <= this.vars.length) {
            return booleanValue == this.vars[n - 1];
        }
        BooleanFormula booleanFormula = (BooleanFormula)booleanValue;
        Iterator<BooleanFormula> iterator = this.opCache(booleanFormula.op()).get(booleanFormula.hashCode());
        while (iterator.hasNext()) {
            if (iterator.next() != booleanFormula) continue;
            return true;
        }
        return false;
    }

    int numVars() {
        return this.vars.length;
    }

    BooleanVariable variable(int n) {
        return this.vars[n - 1];
    }

    BooleanValue assemble(BooleanValue booleanValue, BooleanValue booleanValue2, BooleanValue booleanValue3) {
        if (booleanValue == BooleanConstant.TRUE || booleanValue2 == booleanValue3) {
            return booleanValue2;
        }
        if (booleanValue == BooleanConstant.FALSE) {
            return booleanValue3;
        }
        if (booleanValue2 == BooleanConstant.TRUE || booleanValue == booleanValue2) {
            return this.assemble(Operator.OR, booleanValue, booleanValue3);
        }
        if (booleanValue2 == BooleanConstant.FALSE || booleanValue.negation() == booleanValue2) {
            return this.assemble(Operator.AND, booleanValue.negation(), booleanValue3);
        }
        if (booleanValue3 == BooleanConstant.TRUE || booleanValue.negation() == booleanValue3) {
            return this.assemble(Operator.OR, booleanValue.negation(), booleanValue2);
        }
        if (booleanValue3 == BooleanConstant.FALSE || booleanValue == booleanValue3) {
            return this.assemble(Operator.AND, booleanValue, booleanValue2);
        }
        int n = booleanValue.label();
        int n2 = booleanValue2.label();
        int n3 = booleanValue3.label();
        boolean bl = false;
        BooleanFormula booleanFormula = (BooleanFormula)booleanValue;
        BooleanFormula booleanFormula2 = (BooleanFormula)booleanValue2;
        BooleanFormula booleanFormula3 = (BooleanFormula)booleanValue3;
        if (Math.abs(n2) == Math.abs(n3)) {
            if (n > 0 && n2 < 0 && n3 > 0) {
                bl = true;
                booleanFormula2 = booleanFormula2.negation();
                booleanFormula3 = booleanFormula3.negation();
            } else if (n < 0 && n2 > 0 && n3 < 0) {
                bl = true;
                booleanFormula = booleanFormula.negation();
            } else if (n < 0 && n2 < 0 && n3 > 0) {
                booleanFormula = booleanFormula.negation();
                booleanFormula2 = booleanFormula2.negation();
                booleanFormula3 = booleanFormula3.negation();
            }
        }
        int n4 = Operator.ITE.hash(booleanFormula, booleanFormula2, booleanFormula3);
        Object object = this.opCache(Operator.ITE).get(n4);
        while (object.hasNext()) {
            BooleanFormula booleanFormula4 = object.next();
            if (booleanFormula4.input(0) != booleanValue || booleanFormula4.input(1) != booleanValue2 || booleanFormula4.input(2) != booleanValue3) continue;
            return booleanFormula4;
        }
        object = new ITEGate(this.label++, n4, booleanFormula, booleanFormula2, booleanFormula3);
        this.opCache(Operator.ITE).add((BooleanFormula)object);
        return bl ? ((BooleanFormula)object).negation() : object;
    }

    BooleanValue assemble(Operator.Nary nary, BooleanValue booleanValue, BooleanValue booleanValue2) {
        if (nary == Operator.OR) {
            return this.assemble(Operator.AND, booleanValue.negation(), booleanValue2.negation()).negation();
        }
        if (booleanValue == booleanValue2) {
            return booleanValue;
        }
        if (booleanValue.label() == -booleanValue2.label()) {
            return BooleanConstant.FALSE;
        }
        if (booleanValue == BooleanConstant.TRUE) {
            return booleanValue2;
        }
        if (booleanValue2 == BooleanConstant.TRUE) {
            return booleanValue;
        }
        if (booleanValue == BooleanConstant.FALSE) {
            return BooleanConstant.FALSE;
        }
        if (booleanValue2 == BooleanConstant.FALSE) {
            return BooleanConstant.FALSE;
        }
        return this.cache(nary, (BooleanFormula)booleanValue, (BooleanFormula)booleanValue2);
    }

    BooleanValue assemble(BooleanAccumulator booleanAccumulator) {
        int n = booleanAccumulator.size();
        Operator.Nary nary = booleanAccumulator.op;
        switch (n) {
            case 0: {
                return nary.identity();
            }
            case 1: {
                return booleanAccumulator.iterator().next();
            }
            case 2: {
                Iterator<BooleanValue> iterator = booleanAccumulator.iterator();
                return this.assemble(nary, iterator.next(), iterator.next());
            }
        }
        LinkedList<BooleanValue> linkedList = new LinkedList<BooleanValue>();
        for (BooleanValue booleanValue : booleanAccumulator) {
            linkedList.add(booleanValue);
        }
        while (linkedList.size() > 1) {
            Iterator<BooleanValue> iterator = linkedList.listIterator();
            int n2 = linkedList.size() - 1;
            for (int i = 0; i < n2; i += 2) {
                BooleanValue booleanValue = (BooleanValue)iterator.next();
                iterator.remove();
                BooleanValue booleanValue2 = (BooleanValue)iterator.next();
                BooleanValue booleanValue3 = this.assemble(nary, booleanValue, booleanValue2);
                if (booleanValue3 == nary.shortCircuit()) {
                    return nary.shortCircuit();
                }
                if (booleanValue3 == nary.identity()) {
                    iterator.remove();
                    continue;
                }
                iterator.set(booleanValue3);
            }
        }
        return (BooleanValue)linkedList.get(0);
    }

    private BooleanFormula cache(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
        BooleanFormula booleanFormula3;
        BooleanFormula booleanFormula4;
        if (booleanFormula.label() < booleanFormula2.label()) {
            booleanFormula4 = booleanFormula;
            booleanFormula3 = booleanFormula2;
        } else {
            booleanFormula4 = booleanFormula2;
            booleanFormula3 = booleanFormula;
        }
        int n = nary.hash(booleanFormula4, booleanFormula3);
        Object object = this.opCache(nary).get(n);
        while (object.hasNext()) {
            BooleanFormula booleanFormula5 = object.next();
            if (booleanFormula5.size() != 2 || booleanFormula5.input(0) != booleanFormula4 || booleanFormula5.input(1) != booleanFormula3) continue;
            return booleanFormula5;
        }
        object = new BinaryGate(nary, this.label++, n, booleanFormula4, booleanFormula3);
        this.opCache(nary).add((BooleanFormula)object);
        return object;
    }
}

