/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import kodkod.engine.CapacityExceededException;
import kodkod.util.ints.Ints;

public abstract class Dimensions {
    private final int capacity;

    private Dimensions(int n) {
        this.capacity = n;
    }

    public static Dimensions square(int n, int n2) {
        if (n2 < 1 || n < 1) {
            throw new IllegalArgumentException("n < 1 || size < 1");
        }
        return new Square(n2, n);
    }

    public static Dimensions rectangular(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("n=0.");
        }
        long l = 1L;
        int n = nArray[0];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 1) {
                throw new IllegalArgumentException("Invalid dimension: " + nArray[i]);
            }
            l *= (long)nArray[i];
            if (n == nArray[i]) continue;
            n = 0;
        }
        if (n > 0) {
            return new Square(nArray.length, n);
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return new Rectangle(nArray2, l);
    }

    public final int capacity() {
        return this.capacity;
    }

    public abstract int dimension(int var1);

    public abstract int numDimensions();

    public abstract boolean isSquare();

    abstract boolean isSquare(int var1, int var2);

    abstract void copy(int var1, int[] var2, int var3, int var4);

    public final Dimensions dot(Dimensions dimensions) {
        int n = this.numDimensions();
        int n2 = dimensions.numDimensions();
        int n3 = n + n2 - 2;
        int n4 = dimensions.dimension(0);
        if (n3 == 0 || this.dimension(n - 1) != n4) {
            throw new IllegalArgumentException();
        }
        if (this.isSquare(0, n - 1) && dimensions.isSquare(1, n2) && (n == 1 || n2 == 1 || this.dimension(0) == dimensions.dimension(1))) {
            return new Square(n3, this.dimension(0));
        }
        int[] nArray = new int[n3];
        this.copy(0, nArray, 0, n - 1);
        dimensions.copy(1, nArray, n - 1, n2 - 1);
        return new Rectangle(nArray, this.capacity * dimensions.capacity / (n4 * n4));
    }

    public final Dimensions cross(Dimensions dimensions) {
        int n = this.numDimensions();
        int n2 = dimensions.numDimensions();
        if (this.isSquare() && dimensions.isSquare() && this.dimension(0) == dimensions.dimension(0)) {
            return new Square(n + n2, this.dimension(0));
        }
        int[] nArray = new int[n + n2];
        this.copy(0, nArray, 0, n);
        dimensions.copy(0, nArray, n, n2);
        return new Rectangle(nArray, (long)this.capacity * (long)dimensions.capacity);
    }

    public abstract Dimensions transpose();

    private static boolean positiveBounded(int n, int n2) {
        return 0 <= n && n < n2;
    }

    public final boolean validate(int n) {
        return Dimensions.positiveBounded(n, this.capacity);
    }

    public final boolean validate(int[] nArray) {
        int n = this.numDimensions();
        if (nArray.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Dimensions.positiveBounded(nArray[i], this.dimension(i))) continue;
            return false;
        }
        return true;
    }

    public final int[] convert(int n) {
        int[] nArray = new int[this.numDimensions()];
        this.convert(n, nArray);
        return nArray;
    }

    public final void convert(int n, int[] nArray) {
        int n2 = this.numDimensions();
        if (nArray.length < n2) {
            throw new IllegalArgumentException("arrayIndex.length<this.numDimensions");
        }
        if (!this.validate(n)) {
            throw new IndexOutOfBoundsException("index");
        }
        int n3 = this.capacity;
        int n4 = n;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n4 / (n3 /= this.dimension(i));
            n4 %= n3;
        }
    }

    public final int convert(int[] nArray) {
        int n = this.numDimensions();
        if (nArray.length < n) {
            throw new IllegalArgumentException("index.length < this.n");
        }
        int n2 = 0;
        int n3 = this.capacity;
        for (int i = 0; i < n; ++i) {
            int n4 = this.dimension(i);
            if (!Dimensions.positiveBounded(nArray[i], n4)) {
                throw new IndexOutOfBoundsException("index[" + i + "]");
            }
            n2 += (n3 /= n4) * nArray[i];
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[ ");
        for (int i = 0; i < this.numDimensions(); ++i) {
            stringBuilder.append(this.dimension(i));
            stringBuilder.append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static final class Rectangle
    extends Dimensions {
        private final int[] dimensions;

        Rectangle(int[] nArray, long l) {
            super((int)l);
            if (l > Integer.MAX_VALUE || l <= 0L) {
                throw new CapacityExceededException("Matrix too large: requested capacity of " + l, Ints.asIntVector(nArray));
            }
            this.dimensions = nArray;
        }

        @Override
        void copy(int n, int[] nArray, int n2, int n3) {
            System.arraycopy(this.dimensions, n, nArray, n2, n3);
        }

        @Override
        boolean isSquare(int n, int n2) {
            for (int i = n + 1; i < n2; ++i) {
                if (this.dimensions[i - 1] == this.dimensions[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isSquare() {
            return false;
        }

        @Override
        public int dimension(int n) {
            return this.dimensions[n];
        }

        @Override
        public int numDimensions() {
            return this.dimensions.length;
        }

        @Override
        public Dimensions transpose() {
            if (this.numDimensions() != 2) {
                throw new UnsupportedOperationException("n!=2");
            }
            int[] nArray = new int[]{this.dimensions[1], this.dimensions[0]};
            return new Rectangle(nArray, this.capacity());
        }

        public boolean equals(Object object) {
            if (object instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)object;
                if (this.dimensions.length != rectangle.dimensions.length || this.capacity() != rectangle.capacity()) {
                    return false;
                }
                for (int i = 0; i < this.dimensions.length; ++i) {
                    if (this.dimensions[i] == rectangle.dimensions[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.dimensions.length ^ this.capacity();
        }
    }

    private static final class Square
    extends Dimensions {
        private final int n;
        private final int size;

        Square(int n, int n2) {
            super(Square.capacity(n, n2));
            this.size = n2;
            this.n = n;
        }

        static int capacity(int n, int n2) {
            long l = Math.round(Math.pow(n2, n));
            if (l > Integer.MAX_VALUE || l <= 0L) {
                throw new CapacityExceededException("Matrix too large: requested capacity of " + l, Ints.nCopies(n, n2));
            }
            return (int)l;
        }

        @Override
        void copy(int n, int[] nArray, int n2, int n3) {
            if (n < 0 || n3 < 0 || n + n3 > this.n) {
                throw new ArrayIndexOutOfBoundsException();
            }
            while (n++ < n3) {
                nArray[n2++] = this.size;
            }
        }

        @Override
        boolean isSquare(int n, int n2) {
            if (n <= n2 && n >= 0 && n2 <= this.n) {
                return true;
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        @Override
        public int numDimensions() {
            return this.n;
        }

        @Override
        public int dimension(int n) {
            if (!Dimensions.positiveBounded(n, this.n)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.size;
        }

        @Override
        public boolean isSquare() {
            return true;
        }

        @Override
        public Dimensions transpose() {
            if (this.numDimensions() != 2) {
                throw new UnsupportedOperationException("n!=2");
            }
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof Square) {
                Square square = (Square)object;
                return this.n == square.n && this.size == square.size;
            }
            return false;
        }

        public int hashCode() {
            return this.n ^ this.size;
        }
    }
}

