/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.MultiGate;
import kodkod.engine.bool.Operator;

final class BinaryGate
extends MultiGate {
    private final BooleanFormula low;
    private final BooleanFormula high;

    BinaryGate(Operator.Nary nary, int n, int n2, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
        super(nary, n, n2);
        assert (booleanFormula.label() < booleanFormula2.label());
        this.low = booleanFormula;
        this.high = booleanFormula2;
    }

    @Override
    int contains(Operator operator, int n, int n2) {
        assert (n2 > 0);
        if (n == this.label()) {
            return 1;
        }
        if (this.op != operator || n2 < 2 || n > this.label() || -n > this.label()) {
            return -1;
        }
        int n3 = this.low.contains(operator, n, n2 - 1);
        if (n3 > 0) {
            return n3;
        }
        int n4 = this.high.contains(operator, n, n2 - n3);
        return n4 > 0 ? n4 - n3 : n4 + n3;
    }

    @Override
    void flatten(Operator operator, Set<BooleanFormula> set, int n) {
        assert (n > 0);
        if (this.op == operator && n > 1) {
            int n2 = set.size();
            this.low.flatten(operator, set, n - 1);
            this.high.flatten(operator, set, n - (set.size() - n2));
        } else {
            set.add(this);
        }
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public Iterator<BooleanFormula> iterator() {
        return new Iterator<BooleanFormula>(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < 2;
            }

            @Override
            public BooleanFormula next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.next++ == 0 ? BinaryGate.this.low : BinaryGate.this.high;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public BooleanFormula input(int n) {
        switch (n) {
            case 0: {
                return this.low;
            }
            case 1: {
                return this.high;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

