/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Expression;
import kodkod.ast.operator.ExprOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class UnaryExpression
extends Expression {
    private final Expression expression;
    private final ExprOperator op;
    private final int arity;

    UnaryExpression(ExprOperator exprOperator, Expression expression) {
        if (!exprOperator.unary()) {
            throw new IllegalArgumentException("Not a unary operator: " + (Object)((Object)exprOperator));
        }
        if (expression.arity() != 2) {
            throw new IllegalArgumentException("Invalid arity: " + expression + "::" + expression.arity());
        }
        this.expression = expression;
        this.op = exprOperator;
        this.arity = 2;
    }

    @Override
    public int arity() {
        return this.arity;
    }

    public Expression expression() {
        return this.expression;
    }

    public ExprOperator op() {
        return this.op;
    }

    @Override
    public <E, F, D, I> E accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return this.op.toString() + this.expression.toString();
    }
}

