/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.Relation;
import kodkod.ast.Variable;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public abstract class RelationPredicate
extends Formula {
    private final Relation relation;

    private RelationPredicate(Relation relation) {
        if (relation.arity() != 2) {
            throw new IllegalArgumentException("invalid arity: " + relation.arity());
        }
        this.relation = relation;
    }

    public Relation relation() {
        return this.relation;
    }

    public abstract Name name();

    public abstract Formula toConstraints();

    @Override
    public <E, F, D, I> F accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    public static final class TotalOrdering
    extends RelationPredicate {
        private final Relation first;
        private final Relation last;
        private final Relation ordered;

        TotalOrdering(Relation relation, Relation relation2, Relation relation3, Relation relation4) {
            super(relation);
            if (relation3.arity() != 1 || relation4.arity() != 1 || relation2.arity() != 1) {
                throw new IllegalArgumentException("invalid arity: " + relation3 + " or " + relation4 + " or " + relation2);
            }
            this.first = relation3;
            this.last = relation4;
            this.ordered = relation2;
        }

        @Override
        public Name name() {
            return Name.TOTAL_ORDERING;
        }

        public Relation first() {
            return this.first;
        }

        public Relation last() {
            return this.last;
        }

        public Relation ordered() {
            return this.ordered;
        }

        @Override
        public Formula toConstraints() {
            Formula formula = this.first.one().and(this.last.one()).and(this.last.in(this.ordered));
            Formula formula2 = this.ordered.eq(this.first.join(this.relation().reflexiveClosure()));
            Formula formula3 = this.relation().join(this.first).no().and(this.last.join(this.relation()).no());
            Variable variable = Variable.unary("e" + this.relation().name());
            Formula formula4 = variable.join(this.relation()).one().forAll(variable.oneOf(this.ordered.difference(this.last)));
            return TotalOrdering.and(formula, formula2, formula3, formula4);
        }

        @Override
        public String toString() {
            return (Object)((Object)this.name()) + "(" + this.relation() + ", " + this.ordered + ", " + this.first + ", " + this.last + ")";
        }
    }

    public static final class Function
    extends RelationPredicate {
        private final Expression domain;
        private final Expression range;
        private final Multiplicity targetMult;

        Function(Relation relation, Expression expression, Multiplicity multiplicity, Expression expression2) {
            super(relation);
            if (multiplicity != Multiplicity.ONE && multiplicity != Multiplicity.LONE) {
                throw new IllegalArgumentException("invalid target multiplicity for a function: " + (Object)((Object)multiplicity));
            }
            if (expression.arity() != 1 || expression2.arity() != 1) {
                throw new IllegalArgumentException("invalid arity: " + expression + " or " + expression2);
            }
            this.targetMult = multiplicity;
            this.domain = expression;
            this.range = expression2;
        }

        @Override
        public Name name() {
            return Name.FUNCTION;
        }

        public Multiplicity targetMult() {
            return this.targetMult;
        }

        public Expression domain() {
            return this.domain;
        }

        public Expression range() {
            return this.range;
        }

        @Override
        public Formula toConstraints() {
            Formula formula = this.relation().in(this.domain.product(this.range));
            Variable variable = Variable.unary("v" + this.relation().name());
            Formula formula2 = variable.join(this.relation()).apply(this.targetMult).forAll(variable.oneOf(this.domain));
            return formula.and(formula2);
        }

        @Override
        public String toString() {
            return (Object)((Object)this.name()) + "(" + this.relation() + ", " + this.domain + " ->" + (Object)((Object)this.targetMult) + " " + this.range + ")";
        }
    }

    public static final class Acyclic
    extends RelationPredicate {
        Acyclic(Relation relation) {
            super(relation);
        }

        @Override
        public Name name() {
            return Name.ACYCLIC;
        }

        @Override
        public Formula toConstraints() {
            return this.relation().closure().intersection(Expression.IDEN).no();
        }

        @Override
        public String toString() {
            return (Object)((Object)this.name()) + "(" + this.relation() + ")";
        }
    }

    public static enum Name {
        FUNCTION,
        ACYCLIC,
        TOTAL_ORDERING;

    }
}

