/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kodkod.ast.BinaryFormula;
import kodkod.ast.Comprehension;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Decls;
import kodkod.ast.Expression;
import kodkod.ast.IfExpression;
import kodkod.ast.IfIntExpression;
import kodkod.ast.IntExpression;
import kodkod.ast.NaryFormula;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.operator.FormulaOperator;
import kodkod.ast.operator.Quantifier;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.util.collections.Containers;

public abstract class Formula
extends Node {
    public static final Formula TRUE = new ConstantFormula(true){};
    public static final Formula FALSE = new ConstantFormula(false){};

    Formula() {
    }

    public static Formula constant(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public final Formula and(Formula formula) {
        return this.compose(FormulaOperator.AND, formula);
    }

    public final Formula or(Formula formula) {
        return this.compose(FormulaOperator.OR, formula);
    }

    public final Formula iff(Formula formula) {
        return this.compose(FormulaOperator.IFF, formula);
    }

    public final Formula implies(Formula formula) {
        return this.compose(FormulaOperator.IMPLIES, formula);
    }

    public final Formula compose(FormulaOperator formulaOperator, Formula formula) {
        return new BinaryFormula(this, formulaOperator, formula);
    }

    public static Formula and(Formula ... formulaArray) {
        return Formula.compose(FormulaOperator.AND, formulaArray);
    }

    public static Formula and(Collection<? extends Formula> collection) {
        return Formula.compose(FormulaOperator.AND, collection);
    }

    public static Formula or(Formula ... formulaArray) {
        return Formula.compose(FormulaOperator.OR, formulaArray);
    }

    public static Formula or(Collection<? extends Formula> collection) {
        return Formula.compose(FormulaOperator.OR, collection);
    }

    public static Formula compose(FormulaOperator formulaOperator, Formula ... formulaArray) {
        switch (formulaArray.length) {
            case 0: {
                switch (formulaOperator) {
                    case AND: {
                        return TRUE;
                    }
                    case OR: {
                        return FALSE;
                    }
                }
                throw new IllegalArgumentException("Expected at least one argument: " + Arrays.toString(formulaArray));
            }
            case 1: {
                return formulaArray[0];
            }
            case 2: {
                return new BinaryFormula(formulaArray[0], formulaOperator, formulaArray[1]);
            }
        }
        return new NaryFormula(formulaOperator, Containers.copy(formulaArray, new Formula[formulaArray.length]));
    }

    public static Formula compose(FormulaOperator formulaOperator, Collection<? extends Formula> collection) {
        switch (collection.size()) {
            case 0: {
                switch (formulaOperator) {
                    case AND: {
                        return TRUE;
                    }
                    case OR: {
                        return FALSE;
                    }
                }
                throw new IllegalArgumentException("Expected at least one argument: " + collection);
            }
            case 1: {
                return collection.iterator().next();
            }
            case 2: {
                Iterator<? extends Formula> iterator = collection.iterator();
                return new BinaryFormula(iterator.next(), formulaOperator, iterator.next());
            }
        }
        return new NaryFormula(formulaOperator, collection.toArray(new Formula[collection.size()]));
    }

    public final Formula forAll(Decls decls) {
        return this.quantify(Quantifier.ALL, decls);
    }

    public final Formula forSome(Decls decls) {
        return this.quantify(Quantifier.SOME, decls);
    }

    public final Formula quantify(Quantifier quantifier, Decls decls) {
        return new QuantifiedFormula(quantifier, decls, this);
    }

    public final Expression comprehension(Decls decls) {
        return new Comprehension(decls, this);
    }

    public final Expression thenElse(Expression expression, Expression expression2) {
        return new IfExpression(this, expression, expression2);
    }

    public final IntExpression thenElse(IntExpression intExpression, IntExpression intExpression2) {
        return new IfIntExpression(this, intExpression, intExpression2);
    }

    public final Formula not() {
        return new NotFormula(this);
    }

    public abstract <E, F, D, I> F accept(ReturnVisitor<E, F, D, I> var1);
}

