/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight.hypersearch;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.hypersearch.HighlightPosition;
import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.gjt.sp.jedit.search.SearchMatcher;

public class HyperSearchResultValue {
    private String originalText;
    private String str;

    public HyperSearchResultValue(String originalText) {
        this.originalText = originalText;
    }

    public String toString() {
        if (this.str == null) {
            this.str = HyperSearchResultValue.getHighlightedString(this.originalText);
            this.originalText = null;
        }
        return this.str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHighlightedString(String s) {
        HighlightManager manager = HighlightManagerTableModel.getManager();
        LinkedList<HighlightPosition> highlights = new LinkedList<HighlightPosition>();
        try {
            manager.getReadLock();
            int highlightCount = manager.countHighlights();
            for (int hi = 0; hi < highlightCount; ++hi) {
                Highlight highlight = manager.getHighlight(hi);
                HyperSearchResultValue.addHighlight(highlights, s, highlight);
            }
        }
        finally {
            manager.releaseLock();
        }
        if (manager.isHighlightWordAtCaret()) {
            HyperSearchResultValue.addHighlight(highlights, s, HighlightManagerTableModel.currentWordHighlight);
        }
        if (manager.isHighlightSelection()) {
            HyperSearchResultValue.addHighlight(highlights, s, HighlightManagerTableModel.selectionHighlight);
        }
        highlights.sort(Comparator.comparingInt(HighlightPosition::getPos));
        StringBuilder sb = new StringBuilder("<html><body>");
        int i = 0;
        for (HighlightPosition hlPos : highlights) {
            HyperSearchResultValue.appendString2html(sb, s.substring(i, hlPos.getPos()));
            if (hlPos.isStart()) {
                sb.append("<font style bgcolor=\"#");
                Color c = hlPos.getHighlight().getColor();
                sb.append(Integer.toHexString(c.getRGB()).substring(2));
                sb.append("\">");
            } else {
                sb.append("</font>");
            }
            i = hlPos.getPos();
        }
        HyperSearchResultValue.appendString2html(sb, s.substring(i));
        sb.append("</body></html>");
        return sb.toString();
    }

    private static void addHighlight(Collection<? super HighlightPosition> highlights, String s, Highlight highlight) {
        SearchMatcher matcher = highlight.getSearchMatcher();
        try {
            SearchMatcher.Match m;
            int i = 0;
            while ((m = matcher.nextMatch((CharSequence)s.substring(i), true, true, true, false)) != null) {
                highlights.add(new HighlightPosition(i + m.start, highlight, true));
                highlights.add(new HighlightPosition(i + m.end, highlight, false));
                i += m.end;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void appendString2html(StringBuilder sb, CharSequence s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            String r;
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    r = "&quot;";
                    break;
                }
                case '&': {
                    r = "&amp;";
                    break;
                }
                case '<': {
                    r = "&lt;";
                    break;
                }
                case '>': {
                    r = "&gt;";
                    break;
                }
                default: {
                    r = String.valueOf(c);
                }
            }
            sb.append(r);
        }
    }
}

