/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.ButtonCellEditor;
import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightCellEditor;
import gatchan.highlight.HighlightCellRenderer;
import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.HighlightManagerTableModel;
import gatchan.highlight.HighlightPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.util.GenericGUIUtilities;

public class HighlightList
extends JPanel
implements HighlightChangeListener {
    private JPopupMenu popupMenu;
    private JMenuItem remove;
    private final JTable table;
    private final HighlightManagerTableModel tableModel;
    private RemoveAction removeAction;
    private final JCheckBox enableHighlights = new JCheckBox("enable");
    private JCheckBoxMenuItem permanentScope;
    private JCheckBoxMenuItem sessionScope;
    private JCheckBoxMenuItem bufferScope;
    private final MyActionListener actionListener;

    public HighlightList() {
        super(new BorderLayout());
        this.tableModel = HighlightManagerTableModel.getInstance();
        this.table = new JTable(this.tableModel);
        this.table.setDragEnabled(false);
        HighlightCellRenderer renderer = new HighlightCellRenderer();
        this.table.setRowHeight(renderer.getPreferredSize().height);
        this.table.setDefaultRenderer(Highlight.class, renderer);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(2).setCellEditor(new ButtonCellEditor(this.tableModel));
        columnModel.getColumn(3).setCellEditor(new ButtonCellEditor(this.tableModel));
        this.table.setSelectionMode(0);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        TableColumn col1 = columnModel.getColumn(0);
        col1.setPreferredWidth(26);
        col1.setMinWidth(26);
        col1.setMaxWidth(26);
        col1.setResizable(false);
        TableColumn col3 = columnModel.getColumn(2);
        col3.setPreferredWidth(26);
        col3.setMinWidth(26);
        col3.setMaxWidth(26);
        col3.setResizable(false);
        TableColumn col4 = columnModel.getColumn(3);
        col4.setPreferredWidth(26);
        col4.setMinWidth(26);
        col4.setMaxWidth(26);
        col4.setResizable(false);
        this.table.setDefaultEditor(Highlight.class, new HighlightCellEditor());
        this.table.setDefaultEditor(Boolean.class, this.table.getDefaultEditor(Boolean.class));
        this.table.setTableHeader(null);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = HighlightList.this.table.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                if (TextAreaMouseHandler.isRightButton((MouseEvent)e)) {
                    HighlightList.this.showPopupMenu(e, row);
                }
            }
        });
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        JButton newButton = new JButton(GUIUtilities.loadIcon((String)"New.png"));
        newButton.setToolTipText("Add an highlight");
        JButton clear = new JButton(GUIUtilities.loadIcon((String)"Clear.png"));
        clear.setToolTipText("Remove all highlights");
        this.enableHighlights.setSelected(true);
        this.enableHighlights.setToolTipText("Enable / disable highlights");
        this.actionListener = new MyActionListener(newButton, clear);
        newButton.addActionListener(this.actionListener);
        clear.addActionListener(this.actionListener);
        this.enableHighlights.addActionListener(this.actionListener);
        toolBar.add(newButton);
        toolBar.add(clear);
        toolBar.add(this.enableHighlights);
        this.add((Component)toolBar, "North");
        JScrollPane scroll = new JScrollPane(this.table);
        this.add(scroll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPopupMenu(MouseEvent e, int row) {
        Highlight highlight;
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.removeAction = new RemoveAction(this.tableModel);
            this.remove = this.popupMenu.add(this.removeAction);
            this.permanentScope = new JCheckBoxMenuItem("permanent");
            this.sessionScope = new JCheckBoxMenuItem("session");
            this.bufferScope = new JCheckBoxMenuItem("buffer");
            this.popupMenu.add(this.permanentScope);
            this.popupMenu.add(this.sessionScope);
            this.popupMenu.add(this.bufferScope);
            this.permanentScope.addActionListener(this.actionListener);
            this.sessionScope.addActionListener(this.actionListener);
            this.bufferScope.addActionListener(this.actionListener);
        }
        try {
            this.tableModel.getReadLock();
            highlight = this.tableModel.getHighlight(row);
        }
        finally {
            this.tableModel.releaseLock();
        }
        this.actionListener.setHighlight(highlight, row);
        int scope = highlight.getScope();
        this.permanentScope.setSelected(scope == 0);
        this.sessionScope.setSelected(scope == 1);
        this.bufferScope.setSelected(scope == 2);
        this.remove.setEnabled(this.tableModel.getRowCount() > 0);
        this.removeAction.setRow(row);
        GenericGUIUtilities.showPopupMenu((JPopupMenu)this.popupMenu, (Component)e.getComponent(), (int)e.getX(), (int)e.getY());
        e.consume();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        HighlightManagerTableModel.getManager().addHighlightChangeListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        HighlightManager highlightManager = HighlightManagerTableModel.getManager();
        if (highlightManager != null) {
            highlightManager.removeHighlightChangeListener(this);
        }
    }

    @Override
    public void highlightUpdated(boolean highlightEnable) {
        this.enableHighlights.setSelected(highlightEnable);
    }

    private class MyActionListener
    implements ActionListener {
        private final JButton newButton;
        private final JButton clear;
        private Highlight highlight;
        private int row;

        MyActionListener(JButton newButton, JButton clear) {
            this.newButton = newButton;
            this.clear = clear;
        }

        private void setHighlight(Highlight highlight, int row) {
            this.highlight = highlight;
            this.row = row;
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.clear == source) {
                HighlightList.this.tableModel.removeAll();
            } else if (this.newButton == source) {
                View activeView = jEdit.getActiveView();
                HighlightPlugin.highlightDialog(activeView, (TextArea)activeView.getTextArea());
            } else if (HighlightList.this.enableHighlights == source) {
                HighlightList.this.tableModel.setHighlightEnable(HighlightList.this.enableHighlights.isSelected());
            } else if (source == HighlightList.this.permanentScope) {
                this.highlight.setScope(0);
                this.highlight.setBuffer(null);
                HighlightList.this.tableModel.fireTableRowsUpdated(this.row, this.row);
            } else if (source == HighlightList.this.sessionScope) {
                this.highlight.setScope(1);
                this.highlight.setBuffer(null);
                HighlightList.this.tableModel.fireTableRowsUpdated(this.row, this.row);
            } else if (source == HighlightList.this.bufferScope) {
                this.highlight.setScope(2);
                this.highlight.setBuffer((JEditBuffer)jEdit.getActiveView().getBuffer());
                HighlightList.this.tableModel.fireTableRowsUpdated(this.row, this.row);
            }
        }
    }

    private static class RemoveAction
    extends AbstractAction {
        private int row;
        private final HighlightManagerTableModel tableModel;

        RemoveAction(HighlightManagerTableModel tableModel) {
            super("remove");
            this.tableModel = tableModel;
        }

        private void setRow(int row) {
            this.row = row;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tableModel.removeRow(this.row);
        }
    }
}

