/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorHashSet;
import errorlist.ErrorList;
import errorlist.ErrorListPlugin;
import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;
import org.jedit.core.FileOpenerService;

public class ErrorListPanel
extends JPanel
implements DefaultFocusComponent {
    public static final ImageIcon ERROR_ICON = new ImageIcon(ErrorList.class.getResource("error.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon(ErrorList.class.getResource("warning.png"));
    public static final Integer[] allTypes = new Integer[]{0, 1};
    private final View view;
    private final JLabel status;
    private final DefaultMutableTreeNode errorRoot;
    private final DefaultTreeModel errorModel;
    private final JTree errorTree;
    private final Set<ErrorSource.Error> errors;
    private final List<Integer> filteredTypes;
    private final Map<Integer, JToggleButton> toggleButtons;
    private final JButton multi;
    private final PopupMenu popupMenu;
    private boolean isActive = false;
    private boolean multiStatus = jEdit.getBooleanProperty((String)"error-list-multi.selected", (boolean)false);
    private ErrorSource currentSource = null;

    public ErrorListPanel(View view) {
        this.view = view;
        this.setLayout(new BorderLayout());
        this.errors = new ErrorHashSet();
        this.filteredTypes = new ArrayList<Integer>();
        this.initFilteredTypes();
        Box toolBar = new Box(0);
        this.status = new JLabel();
        toolBar.add(this.status);
        toolBar.add(Box.createHorizontalStrut(30));
        this.toggleButtons = new HashMap<Integer, JToggleButton>();
        JToggleButton toggleBtn = new JToggleButton(ERROR_ICON, true);
        toggleBtn.setSelected(!this.filteredTypes.contains(0));
        toggleBtn.setToolTipText(jEdit.getProperty((String)"error-list-toggle-errors.label"));
        toggleBtn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-toggle-errors"));
        toolBar.add(toggleBtn);
        this.toggleButtons.put(0, toggleBtn);
        toolBar.add(Box.createHorizontalStrut(3));
        toggleBtn = new JToggleButton(WARNING_ICON, true);
        toggleBtn.setSelected(!this.filteredTypes.contains(1));
        toggleBtn.setToolTipText(jEdit.getProperty((String)"error-list-toggle-warnings.label"));
        toggleBtn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-toggle-warnings"));
        toolBar.add(toggleBtn);
        this.toggleButtons.put(1, toggleBtn);
        toolBar.add(Box.createGlue());
        RolloverButton btn = new RolloverButton(GUIUtilities.loadIcon((String)"PreviousFile.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-previous-error-file.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-previous-error-file"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"NextFile.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-next-error-file.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-next-error-file"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowL.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-previous-error.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-previous-error"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"ArrowR.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-next-error.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-next-error"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-expand-all.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-expand-all"));
        toolBar.add((Component)btn);
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-collapse-all.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-collapse-all"));
        toolBar.add((Component)btn);
        toolBar.add(Box.createHorizontalStrut(6));
        btn = new RolloverButton(GUIUtilities.loadIcon((String)"Clear.png"));
        btn.setToolTipText(jEdit.getProperty((String)"error-list-clear.label"));
        btn.addActionListener((ActionListener)new EditAction.Wrapper(jEdit.getActionContext(), "error-list-clear"));
        btn.addActionListener(ae -> {
            this.errors.clear();
            this.updateList();
        });
        toolBar.add((Component)btn);
        this.multi = new RolloverButton();
        this.multi.addActionListener(ae -> {
            this.multiStatus = !this.multiStatus;
            this.updateMultiStatus();
        });
        this.multi.setSelected(this.multiStatus);
        toolBar.add(this.multi);
        toolBar.add(Box.createHorizontalStrut(6));
        this.add("North", toolBar);
        this.errorRoot = new DefaultMutableTreeNode(new Root(), true);
        this.errorModel = new DefaultTreeModel(this.errorRoot, true);
        this.errorTree = new JTree(this.errorModel);
        if (!OperatingSystem.isMacOSLF()) {
            this.errorTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.errorTree.addMouseListener(new MouseHandler());
        this.errorTree.addKeyListener(new KeyHandler());
        this.errorTree.setCellRenderer((TreeCellRenderer)((Object)new ErrorCellRenderer()));
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        Object[] expandPath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            expandPath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(expandPath));
        }
        JScrollPane scroller = new JScrollPane(this.errorTree);
        scroller.setPreferredSize(new Dimension(640, 200));
        this.add("Center", scroller);
        this.updateMultiStatus();
        this.updateStatus();
        this.popupMenu = new PopupMenu(new ActionHandler(this));
        this.load();
    }

    private void updateMultiStatus() {
        if (this.multiStatus) {
            this.multi.setIcon(GUIUtilities.loadIcon((String)jEdit.getProperty((String)"hypersearch-results.multi.multiple.icon")));
            this.multi.setToolTipText(jEdit.getProperty((String)"error-list-multi-on.label"));
        } else {
            this.multi.setIcon(GUIUtilities.loadIcon((String)jEdit.getProperty((String)"hypersearch-results.multi.single.icon")));
            this.multi.setToolTipText(jEdit.getProperty((String)"error-list-multi-off.label"));
            this.removeAllButLast();
        }
        jEdit.setBooleanProperty((String)"error-list-multi.selected", (boolean)this.multiStatus);
    }

    public void load() {
        EditBus.addToBus((Object)this);
    }

    public void unload() {
        EditBus.removeFromBus((Object)this);
    }

    public void focusOnDefaultComponent() {
        if (jEdit.getBooleanProperty((String)"error-list.autoRefocusTextArea")) {
            this.view.getTextArea().requestFocusInWindow();
        } else {
            this.errorTree.requestFocusInWindow();
        }
    }

    public void focus() {
        this.errorTree.requestFocusInWindow();
    }

    public void expandAll() {
        this.expandAll(new TreePath(new TreeNode[]{this.errorRoot}));
    }

    public void expandAll(TreePath parent) {
        this.errorTree.expandPath(parent);
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode n = e.nextElement();
            TreePath path = parent.pathByAddingChild(n);
            this.expandAll(path);
        }
    }

    public void collapseAll() {
        Object[] collapsePath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            collapsePath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.collapsePath(new TreePath(collapsePath));
        }
    }

    public void removeSelection() {
        TreePath[] selected = this.errorTree.getSelectionPaths();
        if (selected == null) {
            return;
        }
        for (TreePath path : selected) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = selectedNode.getUserObject();
            if (userObject instanceof String) {
                Enumeration<TreeNode> children = selectedNode.children();
                while (children.hasMoreElements()) {
                    DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)children.nextElement();
                    ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                    this.errors.remove(error);
                }
                continue;
            }
            if (!(userObject instanceof ErrorSource.Error)) continue;
            this.errors.remove(userObject);
        }
        this.updateList();
    }

    private void removeAllButLast() {
        DefaultMutableTreeNode fileNode;
        if (this.errorRoot.getChildCount() == 0) {
            return;
        }
        if (this.currentSource != null) {
            HashSet<ErrorSource.Error> toRemove = new HashSet<ErrorSource.Error>();
            for (ErrorSource.Error error : this.errors) {
                if (this.currentSource.equals(error.getErrorSource())) continue;
                toRemove.add(error);
            }
            for (ErrorSource.Error error : toRemove) {
                this.errors.remove(error);
            }
            this.updateList();
            return;
        }
        DefaultMutableTreeNode lastFileNode = (DefaultMutableTreeNode)this.errorRoot.getLastChild();
        if (lastFileNode == null) {
            return;
        }
        Enumeration<TreeNode> fileNodes = this.errorRoot.children();
        while (fileNodes.hasMoreElements() && !(fileNode = (DefaultMutableTreeNode)fileNodes.nextElement()).equals(lastFileNode)) {
            Object userObject = fileNode.getUserObject();
            if (userObject instanceof String) {
                Enumeration<TreeNode> errorNodes = fileNode.children();
                while (errorNodes.hasMoreElements()) {
                    DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)errorNodes.nextElement();
                    ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                    this.errors.remove(error);
                }
                continue;
            }
            if (!(userObject instanceof ErrorSource.Error)) continue;
            this.errors.remove(userObject);
        }
        this.updateList();
    }

    private void initFilteredTypes() {
        for (Integer type : allTypes) {
            if (!jEdit.getBooleanProperty((String)("error-list-filtered-types." + type), (boolean)false)) continue;
            this.filteredTypes.add(type);
        }
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate vu) {
        if (vu.getWhat() == ViewUpdate.CLOSED && vu.getView() == this.view) {
            this.unload();
        }
    }

    public void nextErrorFile() {
        DefaultMutableTreeNode next;
        if (this.errorRoot.getChildCount() == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            next = (DefaultMutableTreeNode)this.errorRoot.getChildAt(0);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof ErrorSource.Error) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                int index = this.errorRoot.getIndex(node);
                if (index == this.errorRoot.getChildCount() - 1) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    return;
                }
                next = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index + 1);
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, next});
        this.errorTree.setSelectionPath(path);
        this.errorTree.scrollPathToVisible(path);
        this._openFile((String)next.getUserObject());
    }

    public void prevErrorFile() {
        DefaultMutableTreeNode prev;
        if (this.errorRoot.getChildCount() == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            prev = (DefaultMutableTreeNode)this.errorRoot.getChildAt(this.errorRoot.getChildCount() - 1);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof ErrorSource.Error) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                int index = this.errorRoot.getIndex(node);
                if (index == 0) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    return;
                }
                prev = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index - 1);
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, prev});
        this.errorTree.setSelectionPath(path);
        this.errorTree.scrollPathToVisible(path);
        this._openFile((String)prev.getUserObject());
    }

    public void nextError() {
        DefaultMutableTreeNode next;
        DefaultMutableTreeNode parent;
        if (this.errorRoot.getChildCount() == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(0);
            next = (DefaultMutableTreeNode)parent.getChildAt(0);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                parent = node;
                next = (DefaultMutableTreeNode)node.getChildAt(0);
            } else if (node.getUserObject() instanceof ErrorSource.Error) {
                parent = (DefaultMutableTreeNode)node.getParent();
                int index = parent.getIndex(node);
                if (index == parent.getChildCount() - 1) {
                    index = this.errorRoot.getIndex(parent);
                    if (index == this.errorRoot.getChildCount() - 1) {
                        UIManager.getLookAndFeel().provideErrorFeedback(null);
                        return;
                    }
                    parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index + 1);
                    next = (DefaultMutableTreeNode)parent.getChildAt(0);
                } else {
                    next = (DefaultMutableTreeNode)parent.getChildAt(index + 1);
                }
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, parent, next});
        this.selectPath(path);
        this.openError((ErrorSource.Error)next.getUserObject());
    }

    public void previousError() {
        DefaultMutableTreeNode prev;
        DefaultMutableTreeNode parent;
        if (this.errorRoot.getChildCount() == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected == null) {
            parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(this.errorRoot.getChildCount() - 1);
            prev = (DefaultMutableTreeNode)parent.getChildAt(parent.getChildCount() - 1);
        } else {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
            if (node.getUserObject() instanceof Extra) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            if (node.getUserObject() instanceof String) {
                int index = this.errorRoot.getIndex(node);
                if (index == 0) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    return;
                }
                parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index - 1);
                prev = (DefaultMutableTreeNode)parent.getChildAt(parent.getChildCount() - 1);
            } else if (node.getUserObject() instanceof ErrorSource.Error) {
                parent = (DefaultMutableTreeNode)node.getParent();
                int index = parent.getIndex(node);
                if (index == 0) {
                    index = this.errorRoot.getIndex(parent);
                    if (index == 0) {
                        UIManager.getLookAndFeel().provideErrorFeedback(null);
                        return;
                    }
                    parent = (DefaultMutableTreeNode)this.errorRoot.getChildAt(index - 1);
                    prev = (DefaultMutableTreeNode)parent.getChildAt(parent.getChildCount() - 1);
                } else {
                    prev = (DefaultMutableTreeNode)parent.getChildAt(index - 1);
                }
            } else {
                return;
            }
        }
        TreePath path = new TreePath(new TreeNode[]{this.errorRoot, parent, prev});
        this.selectPath(path);
        this.openError((ErrorSource.Error)prev.getUserObject());
    }

    public void toggleErrors() {
        this.toggleType(0);
    }

    public void toggleWarnings() {
        this.toggleType(1);
    }

    public void setIsActive(boolean b) {
        this.isActive = b;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    @EditBus.EBHandler
    public void handleErrorSourceMessage(ErrorSourceUpdate message) {
        if (!this.getIsActive()) {
            return;
        }
        Object what = message.getWhat();
        ErrorSource es = message.getErrorSource();
        View v = es.getView();
        if (v != null && v != this.view) {
            return;
        }
        if (what == ErrorSourceUpdate.ERROR_SOURCE_ADDED) {
            this.addErrorSource(message.getErrorSource(), message.getErrors());
            this.updateList();
        }
        if (what == ErrorSourceUpdate.ERROR_ADDED) {
            ErrorSource errorSource = message.getErrorSource();
            if (errorSource != null && !errorSource.equals(this.currentSource) && !this.multiStatus) {
                this.errors.clear();
            }
            this.currentSource = errorSource;
            this.addError(message.getError(), false);
            this.updateList();
        } else if (what == ErrorSourceUpdate.ERROR_REMOVED) {
            this.removeError(message.getError());
            this.updateList();
        } else if (what == ErrorSourceUpdate.ERRORS_CLEARED || what == ErrorSourceUpdate.ERROR_SOURCE_REMOVED) {
            if (!this.multiStatus) {
                this.removeErrorSource(message.getErrorSource());
            }
            this.updateList();
        }
    }

    private void addErrorSource(ErrorSource source, ErrorSource.Error[] errors) {
        if (errors == null || errors.length == 0) {
            return;
        }
        if (!this.multiStatus) {
            this.errors.clear();
        }
        this.currentSource = source;
        Arrays.stream(errors).forEach(error -> this.addError((ErrorSource.Error)error, true));
        this.errorModel.reload(this.errorRoot);
        Object[] expandPath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            expandPath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(expandPath));
        }
    }

    private void updateList() {
        this.errorRoot.removeAllChildren();
        this.errorModel.reload(this.errorRoot);
        for (ErrorSource.Error error : this.errors) {
            if (this.isFiltered(error)) continue;
            this.addErrorToTree(error, false);
        }
        this.updateStatus();
    }

    private void toggleType(int errType) {
        Integer type = errType;
        boolean filtered = this.filteredTypes.contains(type);
        JToggleButton toggleBtn = this.toggleButtons.get(type);
        toggleBtn.setSelected(filtered);
        if (filtered) {
            this.filteredTypes.remove(type);
        } else {
            this.filteredTypes.add(type);
        }
        jEdit.setBooleanProperty((String)("error-list-filtered-types." + type), (boolean)this.filteredTypes.contains(type));
        this.updateList();
    }

    private void updateStatus() {
        int warningCount = 0;
        int errorCount = 0;
        for (ErrorSource.Error error : this.errors) {
            if (error.getErrorType() == 0) {
                ++errorCount;
                continue;
            }
            ++warningCount;
        }
        int shownWarningCount = 0;
        int shownErrorCount = 0;
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(j);
                ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                if (error.getErrorType() == 0) {
                    ++shownErrorCount;
                    continue;
                }
                ++shownWarningCount;
            }
        }
        StringBuilder errorStr = new StringBuilder(String.valueOf(shownErrorCount));
        if (shownErrorCount != errorCount) {
            errorStr.append("(").append(errorCount).append(")");
        }
        StringBuilder warningStr = new StringBuilder(String.valueOf(shownWarningCount));
        if (shownWarningCount != warningCount) {
            warningStr.append("(").append(warningCount).append(")");
        }
        Object[] args = new StringBuilder[]{errorStr, warningStr};
        this.status.setText(jEdit.getProperty((String)ErrorListPanel.getStatusProperty(errorCount, warningCount), (Object[])args));
    }

    private void removeErrorSource(ErrorSource source) {
        DockableWindowManager dwm;
        this.errors.removeIf(error -> error.getErrorSource() == source);
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(j);
                if (((ErrorSource.Error)errorNode.getUserObject()).getErrorSource() != source) continue;
                node.remove(errorNode);
                if (node.getChildCount() == 0) {
                    this.errorRoot.remove(node);
                    --i;
                }
                --j;
            }
        }
        this.errorModel.reload(this.errorRoot);
        Object[] expandPath = new TreeNode[]{this.errorRoot, null};
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            expandPath[1] = this.errorRoot.getChildAt(i);
            this.errorTree.expandPath(new TreePath(expandPath));
        }
        if (this.errorRoot.getChildCount() == 0 && jEdit.getBooleanProperty((String)"error-list.autoCloseOnNoErrors") && (dwm = this.view.getDockableWindowManager()).isDockableWindowDocked("error-list") && dwm.isDockableWindowVisible("error-list")) {
            dwm.toggleDockableWindow("error-list");
        }
    }

    private boolean isFiltered(ErrorSource.Error error) {
        String path;
        boolean match;
        if (this.filteredTypes.contains(error.getErrorType())) {
            return true;
        }
        Pattern filter = ErrorListPlugin.getFilenameFilter();
        return filter != null && (match = filter.matcher(path = error.getFilePath()).matches()) != ErrorListPlugin.isInclusionFilter();
    }

    private void addError(ErrorSource.Error error, boolean init) {
        int c = this.errors.size();
        this.errors.add(error);
        if (this.errors.size() > c && !this.isFiltered(error)) {
            this.addErrorToTree(error, init);
        }
    }

    private void addErrorToTree(ErrorSource.Error error, boolean init) {
        Log.log((int)1, ErrorList.class, (Object)("Adding Error Line#" + (error.getLineNumber() + 1) + " Start#" + (error.getStartOffset() + 1) + " Error Message:" + error.getErrorMessage()));
        String[] extras = error.getExtraMessages();
        DefaultMutableTreeNode errorNode = new DefaultMutableTreeNode(error, extras.length > 0);
        for (String extra : extras) {
            errorNode.add(new DefaultMutableTreeNode(new Extra(extra), false));
        }
        String path = error.getFilePath();
        for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode fileNode = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            String nodePath = (String)fileNode.getUserObject();
            if (!nodePath.equals(path)) continue;
            if (!this.contains(fileNode, errorNode)) {
                fileNode.add(errorNode);
            }
            if (!init) {
                this.errorModel.reload(fileNode);
                this.errorTree.expandPath(new TreePath(new TreeNode[]{this.errorRoot, fileNode, errorNode}));
            }
            return;
        }
        DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(path, true);
        fileNode.add(errorNode);
        this.errorRoot.add(fileNode);
        this.errorModel.reload(this.errorRoot);
        if (!init) {
            Object[] expandPath = new TreeNode[]{this.errorRoot, null};
            for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
                expandPath[1] = this.errorRoot.getChildAt(i);
                this.errorTree.expandPath(new TreePath(expandPath));
            }
        }
    }

    private boolean contains(DefaultMutableTreeNode fileNode, DefaultMutableTreeNode errorNode) {
        Enumeration<TreeNode> children = fileNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            String childErrorMessage = ((ErrorSource.Error)child.getUserObject()).getErrorMessage();
            String errorNodeMessage = ((ErrorSource.Error)errorNode.getUserObject()).getErrorMessage();
            if (childErrorMessage == null || !childErrorMessage.equalsIgnoreCase(errorNodeMessage)) continue;
            return true;
        }
        return false;
    }

    private void removeError(ErrorSource.Error error) {
        this.errors.remove(error);
        this.removeErrorFromTree(error);
    }

    private void removeErrorFromTree(ErrorSource.Error error) {
        DockableWindowManager dwm;
        block0: for (int i = 0; i < this.errorRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.errorRoot.getChildAt(i);
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(j);
                if (errorNode.getUserObject() != error) continue;
                node.remove(errorNode);
                if (node.getChildCount() != 0) continue block0;
                this.errorRoot.remove(node);
                continue block0;
            }
        }
        this.errorModel.reload(this.errorRoot);
        if (this.errorRoot.getChildCount() == 0 && jEdit.getBooleanProperty((String)"error-list.autoCloseOnNoErrors") && (dwm = this.view.getDockableWindowManager()).isDockableWindowDocked("error-list") && dwm.isDockableWindowVisible("error-list")) {
            dwm.toggleDockableWindow("error-list");
        }
    }

    private void _openFile(String vfsPath) {
        try {
            if (MiscUtilities.isURL((String)vfsPath) && vfsPath.startsWith("http")) {
                jEdit.openFile((View)this.view, (String)vfsPath);
                return;
            }
            VFS vfs = VFSManager.getVFSForPath((String)vfsPath);
            VFSFile file = vfs._getFile(null, vfsPath, null);
            if (file == null || file.getLength() == 0L) {
                FileOpenerService.open((String)MiscUtilities.getFileName((String)vfsPath), (View)this.view);
            } else {
                jEdit.openFile((View)this.view, (String)vfsPath);
            }
        }
        catch (IOException ioe) {
            Log.log((int)9, (Object)this, (Object)ioe);
        }
    }

    private void openError(ErrorSource.Error error) {
        Buffer buffer;
        this._openFile(error.getFilePath());
        Buffer buffer2 = buffer = error.getBuffer() != null ? error.getBuffer() : this.view.getEditPane().getBuffer();
        if (buffer.isNewFile() || !buffer.getName().equals(error.getFileName())) {
            return;
        }
        ThreadUtilities.runInDispatchThread(() -> {
            this.view.goToBuffer(buffer);
            int start = error.getStartOffset();
            int end = error.getEndOffset();
            int lineNo = error.getLineNumber();
            if (lineNo >= 0 && lineNo < buffer.getLineCount()) {
                start += buffer.getLineStartOffset(lineNo);
                end = end == 0 ? buffer.getLineEndOffset(lineNo) - 1 : (end += buffer.getLineStartOffset(lineNo));
            }
            this.view.getTextArea().setSelection((Selection)new Selection.Range(start, end));
            this.view.getTextArea().moveCaretPosition(end);
        });
    }

    private void selectPath(TreePath path) {
        this.errorTree.setSelectionPath(path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node.getChildCount() > 0) {
            this.errorTree.expandPath(path);
            this.errorTree.scrollPathToVisible(path.pathByAddingChild(node.getChildAt(node.getChildCount() - 1)));
        } else {
            this.errorTree.scrollPathToVisible(path);
        }
    }

    private void openNode(DefaultMutableTreeNode node) {
        Object object = node.getUserObject();
        if (!(object instanceof Root)) {
            if (object instanceof String) {
                this._openFile((String)object);
            } else if (object instanceof Extra) {
                this.openNode((DefaultMutableTreeNode)node.getParent());
            } else if (object instanceof ErrorSource.Error) {
                this.openError((ErrorSource.Error)object);
            }
        }
    }

    private void openSelectedNode() {
        TreePath selected = this.errorTree.getSelectionPath();
        if (selected != null) {
            this.openNode((DefaultMutableTreeNode)selected.getLastPathComponent());
        }
    }

    private void setClipboardContents(String errorMessage) {
        StringSelection stringSelection = new StringSelection(errorMessage);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public void copySelectedNodeToClipboard() {
        TreePath[] allSelected = this.errorTree.getSelectionPaths();
        StringBuilder allErrors = new StringBuilder();
        HashSet<String> selectedFiles = new HashSet<String>();
        if (allSelected != null) {
            for (TreePath selected : allSelected) {
                this.copyNode(selected, allErrors, "", selectedFiles);
            }
            this.setClipboardContents(allErrors.toString());
        }
    }

    public void copyAllNodesToClipboard() {
        StringBuilder allErrors = new StringBuilder();
        HashSet<String> selectedFiles = new HashSet<String>();
        this.copyNode(new TreePath(new TreeNode[]{this.errorRoot}), allErrors, "", selectedFiles);
        this.setClipboardContents(allErrors.toString());
    }

    private void copyNode(TreePath parent, StringBuilder allErrors, String lastPath, Set<String> selectedFiles) {
        String fileName;
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof ErrorSource.Error) {
            ErrorSource.Error error = (ErrorSource.Error)selectedNode.getUserObject();
            if (!lastPath.equals(error.getFilePath()) && !selectedFiles.contains(error.getFilePath())) {
                if (!lastPath.isEmpty()) {
                    allErrors.append('\n');
                }
                allErrors.append(error.getFilePath());
                allErrors.append('\n');
                lastPath = error.getFilePath();
                selectedFiles.add(error.getFilePath());
            }
            allErrors.append(ErrorListPanel.formatErrorDisplay(error));
            allErrors.append('\n');
        } else if (selectedNode.getUserObject() instanceof Extra) {
            Extra extra = (Extra)selectedNode.getUserObject();
            allErrors.append(extra.toString().replaceAll("\n", ""));
            allErrors.append('\n');
        } else if (selectedNode.getUserObject() instanceof String && !selectedFiles.contains(fileName = (String)selectedNode.getUserObject())) {
            allErrors.append(fileName);
            allErrors.append('\n');
            selectedFiles.add(fileName);
        }
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode n = e.nextElement();
            TreePath path = parent.pathByAddingChild(n);
            this.copyNode(path, allErrors, lastPath, selectedFiles);
        }
    }

    protected static String getStatusProperty(int errorCount, int warningCount) {
        StringBuilder statusProp = new StringBuilder("error-list.status.");
        statusProp.append(errorCount == 1 ? "one" : "many");
        statusProp.append("-error-");
        statusProp.append(warningCount == 1 ? "one" : "many");
        statusProp.append("-warning");
        return statusProp.toString();
    }

    protected static String formatErrorDisplay(ErrorSource.Error error) {
        Log.log((int)1, ErrorList.class, (Object)("Formatted Error Line#" + (error.getLineNumber() + 1) + " Error Message: " + error.getErrorMessage()));
        StringBuilder errorFormat = new StringBuilder();
        errorFormat.append(error.getLineNumber() + 1);
        errorFormat.append(':');
        errorFormat.append(error.getErrorMessage() == null ? "" : error.getErrorMessage().replace('\t', ' '));
        return errorFormat.toString();
    }

    class PopupMenu
    extends JPopupMenu {
        JMenuItem selectOne = new JMenuItem(jEdit.getProperty((String)"hypersearch-results.copy-to-clipboard"));
        JMenuItem selectAll;
        JMenuItem expandAll;
        JMenuItem collapseAll;
        JMenuItem remove;

        PopupMenu(ActionListener listener) {
            this.selectOne.addActionListener(listener);
            this.selectAll = new JMenuItem(jEdit.getProperty((String)"error-list.copy-all-to-clipboard"));
            this.selectAll.addActionListener(listener);
            this.expandAll = new JMenuItem(jEdit.getProperty((String)"error-list.expand-all"));
            this.expandAll.addActionListener(listener);
            this.collapseAll = new JMenuItem(jEdit.getProperty((String)"error-list.collapse-all"));
            this.collapseAll.addActionListener(listener);
            this.remove = new JMenuItem(jEdit.getProperty((String)"error-list.remove"));
            this.remove.addActionListener(listener);
            this.add(this.selectOne);
            this.add(this.selectAll);
            this.addSeparator();
            this.add(this.expandAll);
            this.add(this.collapseAll);
            this.add(this.remove);
        }

        public void enableSelectOne(boolean enabled) {
            this.selectOne.setEnabled(enabled);
        }
    }

    class ActionHandler
    implements ActionListener {
        public ErrorListPanel errorListPanel;

        ActionHandler(ErrorListPanel errorListPanel) {
            this.errorListPanel = errorListPanel;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JMenuItem item = (JMenuItem)evt.getSource();
            if (jEdit.getProperty((String)"hypersearch-results.copy-to-clipboard").equals(item.getText())) {
                ErrorListPanel.this.copySelectedNodeToClipboard();
            } else if (jEdit.getProperty((String)"error-list.copy-all-to-clipboard").equals(item.getText())) {
                ErrorListPanel.this.copyAllNodesToClipboard();
            } else if (jEdit.getProperty((String)"error-list.expand-all").equals(item.getText())) {
                ErrorListPanel.this.expandAll();
            } else if (jEdit.getProperty((String)"error-list.collapse-all").equals(item.getText())) {
                ErrorListPanel.this.collapseAll();
            } else if (jEdit.getProperty((String)"error-list.remove").equals(item.getText())) {
                ErrorListPanel.this.removeSelection();
            } else {
                JOptionPane.showMessageDialog(null, "Invalid Menu option.");
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            switch (evt.getKeyCode()) {
                case 32: {
                    ErrorListPanel.this.openSelectedNode();
                    SwingUtilities.invokeLater(ErrorListPanel.this.errorTree::requestFocusInWindow);
                    evt.consume();
                    break;
                }
                case 10: {
                    ErrorListPanel.this.openSelectedNode();
                    evt.consume();
                    break;
                }
                case 127: {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    evt.consume();
                    break;
                }
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int shiftMask = 1088;
            int controlMask = 128;
            int modifiers = evt.getModifiersEx();
            if (modifiers <= 0 || (modifiers & (shiftMask | controlMask)) != modifiers) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    ErrorListPanel.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                    ErrorListPanel.this.popupMenu.enableSelectOne(!ErrorListPanel.this.errorTree.isSelectionEmpty());
                } else {
                    TreePath path = ErrorListPanel.this.errorTree.getPathForLocation(evt.getX(), evt.getY());
                    if (path == null) {
                        return;
                    }
                    ErrorListPanel.this.errorTree.setSelectionPath(path);
                    ErrorListPanel.this.openNode((DefaultMutableTreeNode)path.getLastPathComponent());
                }
            }
        }
    }

    static class ErrorCellRenderer
    extends EnhancedTreeCellRenderer {
        private static Font plainFont = UIManager.getFont("Tree.font");
        private static final Font boldFont;

        ErrorCellRenderer() {
        }

        protected TreeCellRenderer newInstance() {
            return new ErrorCellRenderer();
        }

        protected void configureTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeValue = node.getUserObject();
            if (nodeValue == null) {
                this.setIcon(null);
                this.setText(null);
            } else if (nodeValue instanceof String) {
                this.setFont(boldFont);
                int errorCount = 0;
                int warningCount = 0;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode errorNode = (DefaultMutableTreeNode)node.getChildAt(i);
                    ErrorSource.Error error = (ErrorSource.Error)errorNode.getUserObject();
                    if (error.getErrorType() == 0) {
                        ++errorCount;
                        continue;
                    }
                    ++warningCount;
                }
                this.setText(nodeValue + " (" + jEdit.getProperty((String)ErrorListPanel.getStatusProperty(errorCount, warningCount), (Object[])new Object[]{errorCount, warningCount}) + ")");
                this.setIcon(null);
            } else if (nodeValue instanceof ErrorSource.Error) {
                this.setFont(plainFont);
                ErrorSource.Error error = (ErrorSource.Error)nodeValue;
                this.setText(ErrorListPanel.formatErrorDisplay(error));
                this.setIcon(error.getErrorType() == 1 ? WARNING_ICON : ERROR_ICON);
            } else if (nodeValue instanceof Extra) {
                this.setFont(plainFont);
                this.setText(nodeValue.toString());
                this.setIcon(null);
            } else if (nodeValue instanceof Root) {
                this.setText(null);
                this.setIcon(null);
            }
        }

        static {
            if (plainFont == null) {
                plainFont = jEdit.getFontProperty((String)"metal.secondary.font");
            }
            boldFont = plainFont.deriveFont(1);
        }
    }

    static class Extra {
        String message;

        Extra(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }

    static class Root {
        Root() {
        }
    }
}

