/*
 * Decompiled with CFR 0.152.
 */
package ise.java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class KappaLayout
implements LayoutManager2,
Serializable {
    protected int _preferred_width = 0;
    protected int _preferred_height = 0;
    protected boolean _size_unknown = true;
    protected int _col_count = 0;
    protected int _row_count = 0;
    protected Hashtable _constraints = new Hashtable();
    protected Hashtable _table = null;
    protected Dimension _0dim = new Dimension(0, 0);
    protected Hashtable _components = null;
    protected int[] _col_widths;
    protected int[] _row_heights;
    protected Vector _same_width_cols;
    protected Vector _same_height_rows;
    protected boolean _stretch = false;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int E = 3;
    public static final int SE = 4;
    public static final int S = 5;
    public static final int SW = 6;
    public static final int W = 7;
    public static final int NW = 8;
    public static final int R = Integer.MAX_VALUE;

    public KappaLayout() {
        this(false);
    }

    public KappaLayout(boolean s) {
        this._stretch = s;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("-------------------------------\n");
        sb.append(this.getClass().getName() + ":\n");
        sb.append("columns=" + this._col_count);
        sb.append(", rows=" + this._row_count);
        sb.append(", cells=" + this._col_count * this._row_count + "\n");
        sb.append("preferred width=" + this._preferred_width);
        sb.append(", preferred height=" + this._preferred_height + "\n");
        if (this._col_widths != null) {
            sb.append("column widths (left to right):");
            for (i = 0; i < this._col_widths.length; ++i) {
                sb.append(this._col_widths[i] + ",");
            }
        }
        if (this._row_heights != null) {
            sb.append("\nrow heights (top to bottom):");
            for (i = 0; i < this._row_heights.length; ++i) {
                sb.append(this._row_heights[i] + ",");
            }
        }
        if (this._constraints != null) {
            sb.append("\ncomponent count=" + this._constraints.size());
            sb.append("\ncomponents (no order):\n");
            Enumeration en = this._constraints.keys();
            while (en.hasMoreElements()) {
                sb.append(en.nextElement() + "\n");
            }
        }
        sb.append("-------------------------------\n");
        return sb.toString();
    }

    public void addLayoutComponent(String n, Component c) {
        this.addLayoutComponent(c, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component c) {
        if (c == null) {
            return;
        }
        Object object = c.getTreeLock();
        synchronized (object) {
            if (this._constraints != null) {
                Object value;
                Object key;
                this._constraints.remove(c);
                if (this._components == null) {
                    return;
                }
                Enumeration keys = this._components.keys();
                while (keys.hasMoreElements()) {
                    key = keys.nextElement();
                    value = this._constraints.get(key);
                    if (value == null || !value.equals(c)) continue;
                    this._components.remove(key);
                    break;
                }
                keys = this._table.keys();
                while (keys.hasMoreElements()) {
                    key = keys.nextElement();
                    value = this._constraints.get(key);
                    if (value == null || !value.equals(c)) continue;
                    this._table.remove(key);
                    break;
                }
                this._size_unknown = true;
                this.calculateDimensions();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            this._size_unknown = true;
            this.calculateDimensions();
            Insets insets = parent.getInsets();
            dim.width = this._preferred_width + insets.left + insets.right;
            dim.height = this._preferred_height + insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.preferredLayoutSize(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int max_width = parent.getSize().width - (insets.left + insets.right);
            int max_height = parent.getSize().height - (insets.top + insets.bottom);
            int x = insets.left;
            int y = insets.top;
            int xfill = 0;
            int yfill = 0;
            this.calculateDimensions();
            if (this._stretch) {
                if (max_width > this._preferred_width && this._col_count > 1) {
                    xfill = (max_width - this._preferred_width) / (this._col_count - 1);
                }
                if (max_height > this._preferred_height && this._row_count > 1) {
                    yfill = (max_height - this._preferred_height) / (this._row_count - 1);
                }
            }
            Point cell = new Point();
            for (int i = 0; i < this._col_count; ++i) {
                cell.x = i;
                y = insets.top;
                if (i > 0) {
                    x += Math.abs(this._col_widths[i - 1]);
                    if (this._stretch && i < this._col_count) {
                        x += xfill;
                    }
                }
                block14: for (int j = 0; j < this._row_count; ++j) {
                    int n;
                    int n2;
                    Component c;
                    cell.y = j;
                    if (j > 0) {
                        y += Math.abs(this._row_heights[j - 1]);
                        if (this._stretch && j < this._row_count) {
                            y += yfill;
                        }
                    }
                    if ((c = (Component)this._components.get(cell)) == null || !c.isVisible()) continue;
                    Dimension d = c.getPreferredSize();
                    Constraints q = (Constraints)this._constraints.get(c);
                    int sum_cols = 0;
                    if (q.w == Integer.MAX_VALUE) {
                        for (n2 = i; n2 < this._col_count; ++n2) {
                            sum_cols += Math.abs(this._col_widths[n2]);
                        }
                    } else {
                        for (n2 = i; n2 < i + q.w; ++n2) {
                            sum_cols += Math.abs(this._col_widths[n2]);
                        }
                    }
                    int sum_rows = 0;
                    if (q.h == Integer.MAX_VALUE) {
                        for (n = i; n < this._row_count; ++n) {
                            sum_rows += Math.abs(this._row_heights[n]);
                        }
                    } else {
                        for (n = j; n < j + q.h; ++n) {
                            sum_rows += Math.abs(this._row_heights[n]);
                        }
                    }
                    if (q.s.indexOf("w") != -1) {
                        d.width = sum_cols - q.p * 2;
                    }
                    if (q.s.indexOf("h") != -1) {
                        d.height = sum_rows - q.p * 2;
                    }
                    int x_adj = sum_cols - d.width;
                    int y_adj = sum_rows - d.height;
                    switch (q.a) {
                        case 1: {
                            c.setBounds(x += x_adj / 2, y += q.p, d.width, d.height);
                            x -= x_adj / 2;
                            y -= q.p;
                            continue block14;
                        }
                        case 2: {
                            c.setBounds(x += x_adj - q.p, y += q.p, d.width, d.height);
                            x -= x_adj - q.p;
                            y -= q.p;
                            continue block14;
                        }
                        case 3: {
                            c.setBounds(x += x_adj - q.p, y += y_adj / 2, d.width, d.height);
                            x -= x_adj - q.p;
                            y -= y_adj / 2;
                            continue block14;
                        }
                        case 4: {
                            c.setBounds(x += x_adj - q.p, y += y_adj - q.p, d.width, d.height);
                            x -= x_adj - q.p;
                            y -= y_adj - q.p;
                            continue block14;
                        }
                        case 5: {
                            c.setBounds(x += x_adj / 2, y += y_adj - q.p, d.width, d.height);
                            x -= x_adj / 2;
                            y -= y_adj - q.p;
                            continue block14;
                        }
                        case 6: {
                            c.setBounds(x += q.p, y += y_adj - q.p, d.width, d.height);
                            x -= q.p;
                            y -= y_adj - q.p;
                            continue block14;
                        }
                        case 7: {
                            c.setBounds(x += q.p, y += y_adj / 2, d.width, d.height);
                            x -= q.p;
                            y -= y_adj / 2;
                            continue block14;
                        }
                        case 8: {
                            c.setBounds(x += q.p, y += q.p, d.width, d.height);
                            x -= q.p;
                            y -= q.p;
                            continue block14;
                        }
                        default: {
                            c.setBounds(x += x_adj / 2, y += y_adj / 2, d.width, d.height);
                            x -= x_adj / 2;
                            y -= y_adj / 2;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component comp, Object constraint) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            Strut strut;
            String token;
            if (comp == null) {
                throw new IllegalArgumentException("No component.");
            }
            if (constraint == null) {
                throw new IllegalArgumentException("No constraint.");
            }
            if (constraint instanceof Constraints) {
                Strut strut2;
                Constraints q = (Constraints)constraint;
                this._constraints.put(comp, q.clone());
                if (comp instanceof Strut && (strut2 = (Strut)comp).isRigid()) {
                    Dimension d = strut2.getSize();
                    if (d.width > 0) {
                        this.setColumnWidth(q.x, d.width);
                    }
                    if (d.height > 0) {
                        this.setRowHeight(q.y, d.height);
                    }
                }
                this._size_unknown = true;
                return;
            }
            if (!(constraint instanceof String)) {
                throw new IllegalArgumentException("Illegal constraint object.");
            }
            Vector<String> tokens = new Vector<String>();
            String c = constraint.toString();
            while (c.length() > 0) {
                int comma = c.indexOf(44);
                if (comma != -1) {
                    token = c.substring(0, comma);
                    c = c.substring(comma + 1);
                } else {
                    token = c;
                    c = "";
                }
                if (token != null) {
                    token = token.trim();
                }
                if (token != null && token.length() > 0) {
                    tokens.addElement(token);
                    continue;
                }
                tokens.addElement("-1");
            }
            Constraints q = new Constraints();
            Enumeration en = tokens.elements();
            if (en.hasMoreElements()) {
                token = en.nextElement().toString();
                try {
                    q.x = Integer.parseInt(token);
                    if (q.x < 0) {
                        q.x = 0;
                    }
                }
                catch (Exception e) {
                    q.x = 0;
                }
            }
            if (en.hasMoreElements()) {
                token = en.nextElement().toString();
                try {
                    q.y = Integer.parseInt(token);
                    if (q.y < 0) {
                        q.y = 0;
                    }
                }
                catch (Exception e) {
                    q.y = 0;
                }
            }
            if (en.hasMoreElements()) {
                token = en.nextElement().toString();
                if (token.equalsIgnoreCase("R")) {
                    q.w = Integer.MAX_VALUE;
                } else {
                    try {
                        q.w = Integer.parseInt(token);
                        if (q.w < 1) {
                            q.w = 1;
                        }
                    }
                    catch (Exception e) {
                        q.w = 1;
                    }
                }
            }
            if (en.hasMoreElements()) {
                token = en.nextElement().toString();
                if (token.equalsIgnoreCase("R")) {
                    q.h = Integer.MAX_VALUE;
                } else {
                    try {
                        q.h = Integer.parseInt(token);
                        if (q.h < 1) {
                            q.h = 1;
                        }
                    }
                    catch (Exception e) {
                        q.h = 1;
                    }
                }
            }
            if (en.hasMoreElements()) {
                token = en.nextElement().toString().trim();
                q.a = token.equalsIgnoreCase("N") || token.equals("1") ? 1 : (token.equalsIgnoreCase("NE") || token.equals("2") ? 2 : (token.equalsIgnoreCase("E") || token.equals("3") ? 3 : (token.equalsIgnoreCase("SE") || token.equals("4") ? 4 : (token.equalsIgnoreCase("S") || token.equals("5") ? 5 : (token.equalsIgnoreCase("SW") || token.equals("6") ? 6 : (token.equalsIgnoreCase("W") || token.equals("7") ? 7 : (token.equalsIgnoreCase("NW") || token.equals("8") ? 8 : 0)))))));
            }
            if (en.hasMoreElements()) {
                token = en.nextElement().toString().trim().toLowerCase();
                q.s = token.equals("w") || token.equals("h") || token.equals("wh") || token.equals("hw") ? token : "0";
            }
            if (en.hasMoreElements()) {
                token = en.nextElement().toString();
                try {
                    q.p = Integer.parseInt(token);
                    if (q.p < 0) {
                        q.p = 0;
                    }
                }
                catch (Exception e) {
                    q.p = 0;
                }
            }
            this._constraints.put(comp, q);
            if (comp instanceof Strut && (strut = (Strut)comp).isRigid()) {
                Dimension d = strut.getSize();
                if (d.width > 0) {
                    this.setColumnWidth(q.x, d.width);
                }
                if (d.height > 0) {
                    this.setRowHeight(q.y, d.height);
                }
            }
            this._size_unknown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension maximumLayoutSize(Container c) {
        Object object = c.getTreeLock();
        synchronized (object) {
            return this.preferredLayoutSize(c);
        }
    }

    public float getLayoutAlignmentX(Container c) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container c) {
        return 0.5f;
    }

    public void invalidateLayout(Container c) {
    }

    protected void calculateDimensions() {
        int i;
        int j;
        int[] temp;
        if (!this._size_unknown) {
            return;
        }
        this._preferred_width = 0;
        this._preferred_height = 0;
        Dimension dim = null;
        this.countColumns();
        this.countRows();
        if (this._table == null) {
            this._table = new Hashtable(23, 0.75f);
        } else {
            this._table.clear();
        }
        if (this._components == null) {
            this._components = new Hashtable(23, 0.75f);
        } else {
            this._components.clear();
        }
        if (this._col_widths != null) {
            temp = new int[this._col_widths.length];
            System.arraycopy(this._col_widths, 0, temp, 0, this._col_widths.length);
            this._col_widths = new int[this._col_count];
            System.arraycopy(temp, 0, this._col_widths, 0, Math.min(temp.length, this._col_widths.length));
        } else {
            this._col_widths = new int[this._col_count];
        }
        if (this._row_heights != null) {
            temp = new int[this._row_heights.length];
            System.arraycopy(this._row_heights, 0, temp, 0, this._row_heights.length);
            this._row_heights = new int[this._row_count];
            System.arraycopy(temp, 0, this._row_heights, 0, Math.min(temp.length, this._row_heights.length));
        } else {
            this._row_heights = new int[this._row_count];
        }
        Enumeration<Object> en = this._constraints.keys();
        while (en.hasMoreElements()) {
            Component c = (Component)en.nextElement();
            Constraints q = (Constraints)this._constraints.get(c);
            if (q.w == Integer.MAX_VALUE) {
                q.w = this._col_count - q.x;
            }
            if (q.h == Integer.MAX_VALUE) {
                q.h = this._row_count - q.y;
            }
            this._components.put(new Point(q.x, q.y), c);
            dim = new Dimension(c.getPreferredSize().width, c.getPreferredSize().height);
            dim.width += q.p * 2;
            dim.height += q.p * 2;
            dim.width /= q.w;
            dim.height /= q.h;
            for (int i2 = q.x; i2 < q.x + q.w; ++i2) {
                for (int j2 = q.y; j2 < q.y + q.h; ++j2) {
                    this._table.put(new Point(i2, j2), dim);
                }
            }
        }
        int col_width = 0;
        for (int i3 = 0; i3 < this._col_count; ++i3) {
            for (j = 0; j < this._row_count; ++j) {
                Dimension p = (Dimension)this._table.get(new Point(i3, j));
                if (p == null) {
                    p = this._0dim;
                }
                col_width = Math.max(p.width, col_width);
            }
            if (this._col_widths[i3] >= 0) {
                this._col_widths[i3] = col_width;
                this._preferred_width += col_width;
            } else {
                this._preferred_width += Math.abs(this._col_widths[i3]);
            }
            col_width = 0;
        }
        if (this._same_width_cols != null) {
            en = this._same_width_cols.elements();
            while (en.hasMoreElements()) {
                int[] same = (int[])en.nextElement();
                int widest = same[0];
                for (i = 0; i < same.length; ++i) {
                    if (same[i] >= this._col_widths.length) continue;
                    widest = Math.max(widest, this._col_widths[same[i]]);
                }
                for (i = 0; i < same.length; ++i) {
                    if (same[i] >= this._col_widths.length) continue;
                    this._preferred_width += widest - this._col_widths[same[i]];
                    this._col_widths[same[i]] = widest;
                }
            }
        }
        int row_height = 0;
        for (j = 0; j < this._row_count; ++j) {
            for (i = 0; i < this._col_count; ++i) {
                Dimension p = (Dimension)this._table.get(new Point(i, j));
                if (p == null) {
                    p = this._0dim;
                }
                row_height = Math.max(p.height, row_height);
            }
            if (this._row_heights[j] >= 0) {
                this._row_heights[j] = row_height;
                this._preferred_height += row_height;
            } else {
                this._preferred_height += Math.abs(this._row_heights[j]);
            }
            row_height = 0;
        }
        if (this._same_height_rows != null) {
            en = this._same_height_rows.elements();
            while (en.hasMoreElements()) {
                int i4;
                int[] same = (int[])en.nextElement();
                int tallest = same[0];
                for (i4 = 0; i4 < same.length; ++i4) {
                    if (same[i4] >= this._row_heights.length) continue;
                    tallest = Math.max(tallest, this._row_heights[same[i4]]);
                }
                for (i4 = 0; i4 < same.length; ++i4) {
                    if (same[i4] >= this._row_heights.length) continue;
                    this._preferred_height += tallest - this._row_heights[same[i4]];
                    this._row_heights[same[i4]] = tallest;
                }
            }
        }
        this._size_unknown = false;
    }

    private void countColumns() {
        this._col_count = 0;
        Hashtable<String, BitSet> rows = new Hashtable<String, BitSet>();
        Enumeration en = this._constraints.elements();
        while (en.hasMoreElements()) {
            Constraints q = (Constraints)en.nextElement();
            BitSet row = null;
            String y = String.valueOf(q.y);
            if (!rows.containsKey(y)) {
                row = new BitSet();
                rows.put(y, row);
            }
            row = (BitSet)rows.get(y);
            int last_col = q.w == Integer.MAX_VALUE ? q.x + 1 : q.x + q.w;
            for (int i = q.x; i < last_col; ++i) {
                row.set(i);
            }
        }
        en = rows.elements();
        while (en.hasMoreElements()) {
            BitSet row = (BitSet)en.nextElement();
            for (int i = 0; i < row.size(); ++i) {
                if (!row.get(i)) continue;
                this._col_count = Math.max(this._col_count, i + 1);
            }
        }
    }

    private void countRows() {
        this._row_count = 0;
        Hashtable<String, BitSet> cols = new Hashtable<String, BitSet>();
        Enumeration en = this._constraints.elements();
        while (en.hasMoreElements()) {
            Constraints q = (Constraints)en.nextElement();
            BitSet col = null;
            String x = String.valueOf(q.x);
            if (!cols.containsKey(x)) {
                col = new BitSet();
                cols.put(x, col);
            }
            col = (BitSet)cols.get(x);
            int last_row = q.h == Integer.MAX_VALUE ? q.y + 1 : q.y + q.h;
            for (int i = q.y; i < last_row; ++i) {
                col.set(i);
            }
        }
        en = cols.elements();
        while (en.hasMoreElements()) {
            BitSet col = (BitSet)en.nextElement();
            for (int i = 0; i < col.size(); ++i) {
                if (!col.get(i)) continue;
                this._row_count = Math.max(this._row_count, i + 1);
            }
        }
    }

    public void makeColumnsSameWidth(int column1, int column2) {
        this.makeColumnsSameWidth(new int[]{column1, column2});
    }

    public void makeColumnsSameWidth(int[] columns) {
        if (columns.length <= 1) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] >= 0) continue;
            throw new IllegalArgumentException("Column parameter must be greater than 0.");
        }
        if (this._same_width_cols == null) {
            this._same_width_cols = new Vector();
        }
        this._same_width_cols.addElement(columns);
        this._size_unknown = true;
    }

    public void makeColumnsSameWidth() {
        this.countColumns();
        int[] columns = new int[this._col_count];
        for (int i = 0; i < this._col_count; ++i) {
            columns[i] = i;
        }
        this.makeColumnsSameWidth(columns);
    }

    public void makeRowsSameHeight(int row1, int row2) {
        this.makeRowsSameHeight(new int[]{row1, row2});
    }

    public void makeRowsSameHeight(int[] rows) {
        if (rows.length <= 1) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] >= 0) continue;
            throw new IllegalArgumentException("Row parameter must be greater than 0.");
        }
        if (this._same_height_rows == null) {
            this._same_height_rows = new Vector();
        }
        this._same_height_rows.addElement(rows);
        this._size_unknown = true;
    }

    public void makeRowsSameHeight() {
        this.countRows();
        int[] rows = new int[this._row_count];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        this.makeRowsSameHeight(rows);
    }

    public void setColumnWidth(int column, int width) {
        if (column < 0) {
            throw new IllegalArgumentException("Column must be >= 0.");
        }
        if (this._col_widths == null) {
            this._col_widths = new int[column + 1];
        }
        if (this._col_widths.length <= column) {
            int[] tmp = new int[this._col_widths.length];
            System.arraycopy(this._col_widths, 0, tmp, 0, this._col_widths.length);
            this._col_widths = new int[column + 1];
            System.arraycopy(tmp, 0, this._col_widths, 0, tmp.length);
        }
        this._col_widths[column] = -1 * width;
        this._size_unknown = true;
    }

    public void setRowHeight(int row, int height) {
        if (row < 0) {
            throw new IllegalArgumentException("Row must be >= 0.");
        }
        if (this._row_heights == null) {
            this._row_heights = new int[row + 1];
        }
        if (this._row_heights.length <= row) {
            int[] tmp = new int[this._row_heights.length];
            System.arraycopy(this._row_heights, 0, tmp, 0, this._row_heights.length);
            this._row_heights = new int[row + 1];
            System.arraycopy(tmp, 0, this._row_heights, 0, tmp.length);
        }
        this._row_heights[row] = -1 * height;
        this._size_unknown = true;
    }

    public static Constraints createConstraint() {
        return new Constraints();
    }

    public static Component createHorizontalStrut(int width) {
        return new Strut(width, 0);
    }

    public static Component createHorizontalStrut(int width, boolean rigid) {
        return new Strut(width, 0, rigid);
    }

    public static Component createVerticalStrut(int height) {
        return new Strut(0, height);
    }

    public static Component createVerticalStrut(int height, boolean rigid) {
        return new Strut(0, height, rigid);
    }

    public static Component createStrut(int width, int height) {
        return new Strut(width, height);
    }

    public static Component createStrut(int width, int height, boolean rigid) {
        return new Strut(width, height, rigid);
    }

    public static class Constraints
    implements Cloneable,
    Serializable {
        public int x = 0;
        public int y = 0;
        public int w = 1;
        public int h = 1;
        public int a = 0;
        public String s = "0";
        public int p = 0;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(this.x) + ",").append(String.valueOf(this.y) + ",").append(String.valueOf(this.w) + ",");
            if (this.w == Integer.MAX_VALUE) {
                sb.append("R,");
            } else {
                sb.append(String.valueOf(this.w) + ",");
            }
            if (this.h == Integer.MAX_VALUE) {
                sb.append("R,");
            } else {
                sb.append(String.valueOf(this.h) + ",");
            }
            sb.append(String.valueOf(this.a) + ",").append(String.valueOf(this.s) + ",").append(String.valueOf(this.p)).toString();
            return sb.toString();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class Strut
    extends Component
    implements Serializable {
        private Dimension _dim;
        private boolean _rigid;

        public Strut(int w, int h) {
            this(w, h, false);
        }

        public Strut(int w, int h, boolean rigid) {
            this._dim = new Dimension(w, h);
            this._rigid = rigid;
        }

        public Dimension getPreferredSize() {
            return this._dim;
        }

        public Dimension getSize() {
            return this._dim;
        }

        public boolean isRigid() {
            return this._rigid;
        }

        public void setRigid(boolean rigid) {
            this._rigid = rigid;
        }
    }
}

