/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import common.gui.ListItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.View;
import org.gjt.sp.util.Log;

public class PopupList
implements FocusListener,
WindowListener {
    private static final int DEFAULT_VISIBLE_ROW_COUNT = 5;
    private boolean requestTextAreaFocusOnCancel;
    private JPanel panel = new JPanel(new BorderLayout(0, 0));
    private JList list;
    private ListModel model = new ListModel();
    private List listeners;
    private JWindow window;

    public PopupList() {
        this(5);
        this.requestTextAreaFocusOnCancel = true;
    }

    public PopupList(int visibleRowCount) {
        this.list = new JList(this.model);
        this.list.addFocusListener(this);
        this.list.setVisibleRowCount(visibleRowCount);
        this.list.setCellRenderer(new ListItemListCellRenderer());
        this.panel.add(new JScrollPane(this.list, 21, 31));
        this.listeners = new LinkedList();
        this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "selectItem");
        this.list.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "selectItem");
        this.list.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.list.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "nextItem");
        this.list.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "previousItem");
        this.list.getActionMap().put("selectItem", new SelectItemAction());
        this.list.getActionMap().put("cancel", new CancelAction());
        this.list.getActionMap().put("nextItem", new SelectNextItemAction());
        this.list.getActionMap().put("previousItem", new SelectPreviousItemAction());
    }

    public void enableKeyStrokeCycling(String anActionName) {
    }

    public void disableKeyStrokeCycling() {
    }

    public void setItems(List theItems) {
        this.model.setItems(theItems);
    }

    public ListItem getSelectedItem() {
        return (ListItem)this.list.getSelectedValue();
    }

    public Object getSelectedActualItem() {
        return this.getSelectedItem().getActualItem();
    }

    public void setSelectedActualItem(Object actualItem) {
        int itemIndex = this.model.indexOfActualItem(actualItem);
        this.list.setSelectedIndex(itemIndex);
    }

    public void setRequestTextAreaFocusOnCancel(boolean b) {
        this.requestTextAreaFocusOnCancel = b;
    }

    public void show(View view) {
        if (this.window != null) {
            Log.log((int)7, (Object)this, (Object)"Popup already shown");
            return;
        }
        this.window = new JWindow((Frame)view);
        this.window.setContentPane(this.panel);
        this.window.pack();
        Point viewLoc = view.getLocation();
        Dimension viewSize = view.getSize();
        Dimension popupSize = this.window.getSize();
        Point popLoc = new Point(viewLoc.x + (viewSize.width - popupSize.width) / 2, viewLoc.y + (viewSize.height - popupSize.height) / 2);
        this.window.addWindowListener(this);
        this.window.setLocation(popLoc);
        this.window.setVisible(true);
        this.list.requestFocus();
    }

    public void cancel() {
        if (this.window != null) {
            this.window.dispose();
            if (this.requestTextAreaFocusOnCancel) {
                View view = (View)this.window.getOwner();
                view.getEditPane().getTextArea().requestFocus();
            }
            this.window = null;
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public static PopupList show(View view, List items, Object selectedActualItem, ActionListener listener) {
        PopupList popupList = new PopupList();
        popupList.addActionListener(listener);
        popupList.setItems(items);
        popupList.setSelectedActualItem(selectedActualItem);
        popupList.show(view);
        return popupList;
    }

    public static PopupList show(View view, List items, ActionListener listener) {
        return PopupList.show(view, items, null, listener);
    }

    public final void focusGained(FocusEvent evt) {
    }

    public final void focusLost(FocusEvent evt) {
        this.cancel();
    }

    public final void windowClosing(WindowEvent evt) {
    }

    public final void windowClosed(WindowEvent evt) {
    }

    public final void windowOpened(WindowEvent evt) {
    }

    public final void windowActivated(WindowEvent evt) {
    }

    public final void windowDeactivated(WindowEvent evt) {
        this.cancel();
    }

    public final void windowIconified(WindowEvent evt) {
    }

    public final void windowDeiconified(WindowEvent evt) {
        this.cancel();
    }

    private void fireActionPerformed() {
        ActionEvent evt = new ActionEvent(this, 1001, null);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ActionListener)i.next()).actionPerformed(evt);
        }
    }

    private class SelectNextItemAction
    extends AbstractAction {
        private SelectNextItemAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            int idx = PopupList.this.list.getSelectedIndex();
            idx = idx < 0 ? 0 : (idx == PopupList.this.model.getSize() - 1 ? 0 : ++idx);
            PopupList.this.list.setSelectedIndex(idx);
            PopupList.this.list.ensureIndexIsVisible(idx);
        }
    }

    private class SelectPreviousItemAction
    extends AbstractAction {
        private SelectPreviousItemAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            int idx = PopupList.this.list.getSelectedIndex();
            idx = idx < 0 ? 0 : (idx == 0 ? PopupList.this.model.getSize() - 1 : --idx);
            PopupList.this.list.setSelectedIndex(idx);
            PopupList.this.list.ensureIndexIsVisible(idx);
        }
    }

    private class SelectItemAction
    extends AbstractAction {
        private SelectItemAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            PopupList.this.window.dispose();
            PopupList.this.window = null;
            PopupList.this.fireActionPerformed();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            PopupList.this.cancel();
        }
    }

    private class ListItemListCellRenderer
    extends DefaultListCellRenderer {
        private ListItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListItem item = (ListItem)value;
            value = item.getLabel();
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(item.getIcon());
            return c;
        }
    }

    private class ListModel
    extends AbstractListModel {
        private List items = new ArrayList();

        public void setItems(List theItems) {
            if (!this.items.isEmpty()) {
                int lastIdx = this.items.size() - 1;
                this.items.clear();
                this.fireIntervalRemoved(this, 0, lastIdx);
            }
            this.items = theItems;
            if (!this.items.isEmpty()) {
                this.fireIntervalAdded(this, 0, this.items.size() - 1);
            }
        }

        public int indexOfActualItem(Object actualItem) {
            int i = 0;
            for (ListItem each : this.items) {
                if (actualItem == null && each.getActualItem() == null) {
                    return i;
                }
                if (actualItem != null && actualItem.equals(each.getActualItem())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        public int getSize() {
            return this.items.size();
        }
    }
}

