/*
 * Decompiled with CFR 0.152.
 */
package common.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.util.Log;

public class HelpfulJTable
extends JTable {
    public static final int SORT_OFF = -1;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    private boolean autoResizeColumns = true;
    private boolean autoResizeWithHeaders = false;
    private int sortColumn = -1;
    private int sortOrder = -1;
    private static Icon SORT_UP;
    private static Icon SORT_DOWN;

    public HelpfulJTable() {
        super.setAutoResizeMode(0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke shifttab = KeyStroke.getKeyStroke(9, 1);
        this.unregisterKeyboardAction(enter);
        this.unregisterKeyboardAction(tab);
        KeyHandler kh = new KeyHandler();
        this.registerKeyboardAction(kh, "enter-pressed", enter, 0);
        this.registerKeyboardAction(kh, "tab-pressed", tab, 0);
        this.registerKeyboardAction(kh, "shift-tab-pressed", shifttab, 0);
        this.addMouseListener(new TooltipMouseHandler());
        if (this.getTableHeader() != null) {
            this.getTableHeader().setResizingAllowed(false);
        }
    }

    public void setAutoResizeColumns(boolean state) {
        this.autoResizeColumns = state;
    }

    public boolean getAutoResizeColumns() {
        return this.autoResizeColumns;
    }

    public void setAutoResizeWithHeaders(boolean state) {
        this.autoResizeWithHeaders = state;
    }

    public boolean getAutoResizeWithHeaders() {
        return this.autoResizeWithHeaders;
    }

    public void setSortColumn(int sortColumn) {
        int oldSortColumn = this.sortColumn;
        this.sortColumn = sortColumn;
        if (oldSortColumn != this.sortColumn) {
            this.firePropertyChange("sortColumn", new Integer(oldSortColumn), new Integer(this.sortColumn));
        }
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortOrder(int order) {
        if (order != 1 && order != 2 && order != -1) {
            throw new IllegalArgumentException("sortOrder must be one of: SORT_ASCENDING, SORT_DESCENDING, SORT_OFF");
        }
        int oldSortOrder = this.sortOrder;
        this.sortOrder = order;
        if (oldSortOrder != this.sortOrder) {
            this.firePropertyChange("sortOrder", new Integer(oldSortOrder), new Integer(this.sortOrder));
        }
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setAutoResizeMode(int mode) {
        if (this.autoResizeColumns) {
            return;
        }
        super.setAutoResizeMode(mode);
    }

    public void setTableHeader(JTableHeader th) {
        super.setTableHeader(th);
        if (th != null) {
            th.addMouseListener(new TableHeaderMouseHandler());
        }
        super.configureEnclosingScrollPane();
    }

    public void setColumnModel(TableColumnModel tcm) {
        super.setColumnModel(tcm);
        int cc = this.columnModel.getColumnCount();
        for (int i = 0; i < cc; ++i) {
            this.columnModel.getColumn(i).setHeaderRenderer(new SortTableHeaderRenderer(i));
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public final String getToolTipText(MouseEvent evt) {
        if (this.getToolTipLocation(evt) == null) {
            return null;
        }
        return super.getToolTipText(evt);
    }

    public final Point getToolTipLocation(MouseEvent evt) {
        JLabel label;
        int col = this.columnAtPoint(evt.getPoint());
        int row = this.rowAtPoint(evt.getPoint());
        if (col < 0 || row < 0) {
            return null;
        }
        Rectangle rect = this.getCellRect(row, col, true);
        if (this.cellTextIsFullyVisible(rect, row, col)) {
            return null;
        }
        Component comp = this.getCellRendererComponent(row, col);
        int iconwidth = 0;
        if (comp instanceof JLabel && (label = (JLabel)comp).getIcon() != null) {
            iconwidth = label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        return new Point(rect.x + iconwidth, rect.y);
    }

    public void autosizeColumn(int col) {
        int width = this.getLongestCellTextWidth(col);
        if (width >= 0) {
            TableColumn tc = this.columnModel.getColumn(col);
            tc.setPreferredWidth(width);
            this.resizeAndRepaint();
            if (this.tableHeader != null) {
                this.tableHeader.resizeAndRepaint();
            }
        }
    }

    public void tableChanged(TableModelEvent e) {
        int cc;
        super.tableChanged(e);
        if (!this.autoResizeColumns) {
            return;
        }
        for (int col = cc = this.columnModel.getColumnCount() - 1; col >= 0; --col) {
            int width = this.getLongestCellTextWidth(col);
            if (width <= 0) continue;
            TableColumn tc = this.columnModel.getColumn(col);
            tc.setPreferredWidth(width);
        }
        this.resizeAndRepaint();
        if (this.tableHeader != null) {
            this.tableHeader.resizeAndRepaint();
        }
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        Rectangle cellRect;
        if (this.getAutoscrolls() && (cellRect = this.getCellRect(rowIndex, columnIndex, false)) != null) {
            cellRect.width = 0;
            this.scrollRectToVisible(cellRect);
        }
        ListSelectionModel csm = this.getColumnModel().getSelectionModel();
        if (extend) {
            if (toggle) {
                csm.setAnchorSelectionIndex(columnIndex);
            } else {
                csm.setLeadSelectionIndex(columnIndex);
            }
        } else if (toggle) {
            if (csm.isSelectedIndex(columnIndex)) {
                csm.removeSelectionInterval(columnIndex, columnIndex);
            } else {
                csm.addSelectionInterval(columnIndex, columnIndex);
            }
        } else {
            csm.setSelectionInterval(columnIndex, columnIndex);
        }
        ListSelectionModel rsm = this.getSelectionModel();
        if (extend) {
            if (toggle) {
                rsm.setAnchorSelectionIndex(rowIndex);
            } else {
                rsm.setLeadSelectionIndex(rowIndex);
            }
        } else if (toggle) {
            if (rsm.isSelectedIndex(rowIndex)) {
                rsm.removeSelectionInterval(rowIndex, rowIndex);
            } else {
                rsm.addSelectionInterval(rowIndex, rowIndex);
            }
        } else {
            rsm.setSelectionInterval(rowIndex, rowIndex);
        }
    }

    protected void fireActionEvent(ActionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(evt);
        }
    }

    protected Component getCellRendererComponent(int row, int col) {
        String value = this.getValueAt(row, col).toString();
        TableCellRenderer rend = this.getCellRenderer(row, col);
        return rend == null ? null : rend.getTableCellRendererComponent(this, value, this.isCellSelected(row, col), this.hasFocus(), row, col);
    }

    protected Component getHeaderRendererComponent(int col) {
        JTableHeader header = this.getTableHeader();
        TableColumnModel tcmodel = header.getColumnModel();
        TableColumn tcol = tcmodel.getColumn(col);
        String value = tcol.getHeaderValue().toString();
        TableCellRenderer rend = tcol.getHeaderRenderer();
        if (rend == null) {
            rend = header.getDefaultRenderer();
        }
        return rend == null ? null : rend.getTableCellRendererComponent(this, value, false, false, -1, col);
    }

    private final boolean cellTextIsFullyVisible(Rectangle rect, int row, int col) {
        int textWidth = this.getCellTextWidth(row, col);
        if (textWidth >= rect.width) {
            return false;
        }
        Rectangle vr = this.getVisibleRect();
        return vr.contains(rect.x, rect.y) && vr.contains(rect.x + textWidth, rect.y);
    }

    private int getHeaderTextWidth(int col) {
        JTableHeader header = this.getTableHeader();
        TableColumnModel tcmodel = header.getColumnModel();
        TableColumn tcol = tcmodel.getColumn(col);
        String value = tcol.getHeaderValue().toString();
        Component comp = this.getHeaderRendererComponent(col);
        return this.getTextWidthInComp(value, comp);
    }

    private int getCellTextWidth(int row, int col) {
        Object svalue = this.getValueAt(row, col);
        if (svalue == null) {
            return 0;
        }
        String value = svalue.toString();
        Component comp = this.getCellRendererComponent(row, col);
        return this.getTextWidthInComp(value, comp);
    }

    private int getTextWidthInComp(String value, Component comp) {
        JLabel label;
        FontMetrics fm = comp.getFontMetrics(comp.getFont());
        int insetwidth = 0;
        if (comp instanceof JComponent) {
            Insets insets = ((JComponent)comp).getInsets();
            insetwidth += insets.left + insets.right;
        }
        if (comp instanceof JLabel && (label = (JLabel)comp).getIcon() != null) {
            insetwidth += label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        return SwingUtilities.computeStringWidth(fm, value) + insetwidth;
    }

    private int getLongestCellTextWidth(int col) {
        int width;
        int numRows;
        int max = -1;
        for (int row = numRows = this.dataModel.getRowCount() - 1; row >= 0; --row) {
            int width2 = this.getCellTextWidth(row, col) + this.getIntercellSpacing().width + 2;
            if (width2 <= max) continue;
            max = width2;
        }
        if (this.autoResizeWithHeaders && (width = this.getHeaderTextWidth(col) + this.getIntercellSpacing().width + 2) > max) {
            max = width;
        }
        return max;
    }

    static {
        URL urlSortUp = HelpfulJTable.class.getResource("sort_up.gif");
        if (urlSortUp != null) {
            SORT_UP = new ImageIcon(urlSortUp);
        } else {
            Log.log((int)9, HelpfulJTable.class, (Object)"Error fetching image sort_up.gif");
        }
        URL urlSortDown = HelpfulJTable.class.getResource("sort_down.gif");
        if (urlSortDown != null) {
            SORT_DOWN = new ImageIcon(urlSortDown);
        } else {
            Log.log((int)9, HelpfulJTable.class, (Object)"Error fetching image sort_down.gif");
        }
    }

    class SortTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private int viewColumn;

        public SortTableHeaderRenderer(int viewColumn) {
            this.viewColumn = viewColumn;
            this.setHorizontalAlignment(10);
            this.setHorizontalTextPosition(10);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setText(value == null ? "" : value.toString());
            if (this.viewColumn == HelpfulJTable.this.sortColumn) {
                switch (HelpfulJTable.this.sortOrder) {
                    case 1: {
                        this.setIcon(SORT_UP);
                        break;
                    }
                    case 2: {
                        this.setIcon(SORT_DOWN);
                        break;
                    }
                    default: {
                        this.setIcon(null);
                        break;
                    }
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    class TableHeaderMouseHandler
    extends MouseAdapter {
        TableHeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            int col = HelpfulJTable.this.getColumnModel().getColumnIndexAtX(evt.getX());
            if (col < 0) {
                return;
            }
            if (evt.getClickCount() == 1) {
                evt.consume();
                if (col == HelpfulJTable.this.sortColumn) {
                    switch (HelpfulJTable.this.sortOrder) {
                        case 1: {
                            HelpfulJTable.this.setSortOrder(2);
                            break;
                        }
                        case 2: {
                            HelpfulJTable.this.setSortOrder(-1);
                            break;
                        }
                        default: {
                            HelpfulJTable.this.setSortOrder(1);
                            break;
                        }
                    }
                } else {
                    HelpfulJTable.this.setSortColumn(col);
                    HelpfulJTable.this.setSortOrder(1);
                }
            } else if (evt.getClickCount() == 2 && HelpfulJTable.this.getTableHeader().getResizingAllowed()) {
                int resizeCol;
                evt.consume();
                Point p = evt.getPoint();
                Rectangle r = HelpfulJTable.this.getTableHeader().getHeaderRect(col);
                r.grow(-3, 0);
                if (r.contains(p)) {
                    return;
                }
                int midPoint = r.x + r.width / 2;
                int n = resizeCol = p.x < midPoint ? col - 1 : col;
                if (resizeCol >= 0) {
                    HelpfulJTable.this.autosizeColumn(resizeCol);
                }
            }
        }
    }

    class TooltipMouseHandler
    extends MouseAdapter {
        private int toolTipInitialDelay = -1;
        private int toolTipReshowDelay = -1;

        TooltipMouseHandler() {
        }

        public void mouseEntered(MouseEvent evt) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            this.toolTipInitialDelay = ttm.getInitialDelay();
            this.toolTipReshowDelay = ttm.getReshowDelay();
            ttm.setInitialDelay(500);
            ttm.setReshowDelay(0);
        }

        public void mouseExited(MouseEvent evt) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            ttm.setInitialDelay(this.toolTipInitialDelay);
            ttm.setReshowDelay(this.toolTipReshowDelay);
        }
    }

    private class KeyHandler
    implements ActionListener {
        private KeyHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            HelpfulJTable.this.fireActionEvent(evt);
        }
    }
}

